/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.geom.intersect.IntersectLineRectangle;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;
import org.jhotdraw8.geom.intersect.Intersections;

public class IntersectRectangleRectangle {
    private IntersectRectangleRectangle() {
    }

    public static @NonNull IntersectionResultEx intersectRectangleRectangleEx(double ax, double ay, double aw, double ah, double bx, double by, double bw, double bh) {
        return IntersectRectangleRectangle.intersectRectangleRectangleEx(new Point2D.Double(ax, ay), new Point2D.Double(ax + aw, ay + ah), new Point2D.Double(bx, by), new Point2D.Double(bx + bw, by + bh));
    }

    public static @NonNull IntersectionResultEx intersectRectangleRectangleEx(@NonNull Point2D a0, @NonNull Point2D a1, @NonNull Point2D b0, @NonNull Point2D b1) {
        Point2D.Double topLeft = Intersections.topLeft(a0, a1);
        Point2D.Double bottomRight = Intersections.bottomRight(a0, a1);
        Point2D.Double topRight = new Point2D.Double(bottomRight.getX(), topLeft.getY());
        Point2D.Double bottomLeft = new Point2D.Double(topLeft.getX(), bottomRight.getY());
        IntersectionResultEx inter1 = IntersectLineRectangle.intersectLineRectangleEx(topLeft, topRight, b0, b1);
        IntersectionResultEx inter2 = IntersectLineRectangle.intersectLineRectangleEx(topRight, bottomRight, b0, b1);
        IntersectionResultEx inter3 = IntersectLineRectangle.intersectLineRectangleEx(bottomRight, bottomLeft, b0, b1);
        IntersectionResultEx inter4 = IntersectLineRectangle.intersectLineRectangleEx(bottomLeft, topLeft, b0, b1);
        ArrayList<IntersectionPointEx> result = new ArrayList<IntersectionPointEx>();
        IntersectionStatus status = IntersectionStatus.NO_INTERSECTION;
        if (inter1.getStatus() == IntersectionStatus.INTERSECTION) {
            result.addAll(inter1.intersections().asList());
        }
        if (inter2.getStatus() == IntersectionStatus.INTERSECTION) {
            result.addAll(inter2.intersections().asList());
        }
        if (inter3.getStatus() == IntersectionStatus.INTERSECTION) {
            result.addAll(inter3.intersections().asList());
        }
        if (inter4.getStatus() == IntersectionStatus.INTERSECTION) {
            result.addAll(inter4.intersections().asList());
        }
        return new IntersectionResultEx(result);
    }
}

