/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.util.AbstractCollection;
import java.util.Collection;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.collection.primitive.DoubleArrayList;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionStatus;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableCollection;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class IntersectionResult {
    private final @NonNull IntersectionStatus status;
    private final @NonNull ImmutableList<IntersectionPoint> intersections;

    public IntersectionResult(@NonNull IntersectionStatus status, @NonNull Collection<? extends IntersectionPoint> copyItems) {
        this.intersections = VectorList.copyOf(copyItems);
        this.status = status;
    }

    public IntersectionResult(@NonNull IntersectionStatus status, @NonNull ImmutableCollection<? extends IntersectionPoint> copyItems) {
        this.intersections = VectorList.copyOf(copyItems);
        this.status = status;
    }

    public IntersectionResult(@NonNull Collection<? extends IntersectionPoint> copyItems) {
        this(copyItems.isEmpty() ? IntersectionStatus.NO_INTERSECTION : IntersectionStatus.INTERSECTION, copyItems);
    }

    public @NonNull IntersectionStatus getStatus() {
        return this.status;
    }

    public @NonNull DoubleArrayList getAllArgumentsA() {
        return this.intersections.stream().mapToDouble(IntersectionPoint::getArgumentA).collect(DoubleArrayList::new, DoubleArrayList::add, AbstractCollection::addAll);
    }

    public @NonNull ImmutableList<IntersectionPoint> intersections() {
        return this.intersections;
    }
}

