/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.util.AbstractCollection;
import java.util.Collections;
import java.util.List;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.collection.primitive.DoubleArrayList;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class IntersectionResultEx {
    private final @NonNull ImmutableList<IntersectionPointEx> intersections;
    private final @NonNull IntersectionStatus status;

    public IntersectionResultEx(@NonNull List<IntersectionPointEx> intersections) {
        this(intersections.isEmpty() ? IntersectionStatus.NO_INTERSECTION : IntersectionStatus.INTERSECTION, intersections);
    }

    public IntersectionResultEx(IntersectionStatus status) {
        this(status, Collections.emptyList());
    }

    public IntersectionResultEx(@NonNull IntersectionStatus status, @NonNull List<IntersectionPointEx> intersections) {
        this.intersections = VectorList.copyOf(intersections);
        this.status = status;
    }

    public @NonNull IntersectionStatus getStatus() {
        return this.status;
    }

    public DoubleArrayList getAllArgumentsB() {
        return this.intersections.stream().mapToDouble(IntersectionPointEx::getArgumentB).collect(DoubleArrayList::new, DoubleArrayList::add, AbstractCollection::addAll);
    }

    public DoubleArrayList getAllArgumentsA() {
        return this.intersections.stream().mapToDouble(IntersectionPoint::getArgumentA).collect(DoubleArrayList::new, DoubleArrayList::add, AbstractCollection::addAll);
    }

    public ImmutableList<IntersectionPointEx> intersections() {
        return this.intersections;
    }
}

