/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.Arrays;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.geom.Polynomial;

class Intersections {
    public static final double EPSILON = 1.1641532182693481E-10;

    private Intersections() {
    }

    private static double @NonNull [] addZeroAndOne(double @NonNull [] clampedRoots) {
        double[] roots = new double[clampedRoots.length + 2];
        int numRoots = 0;
        Arrays.sort(clampedRoots);
        if (clampedRoots.length == 0 || clampedRoots[0] > 0.0) {
            roots[numRoots++] = 0.0;
        }
        for (double clampedRoot : clampedRoots) {
            roots[numRoots++] = clampedRoot;
        }
        if (clampedRoots.length == 0 || clampedRoots[clampedRoots.length - 1] < 1.0) {
            roots[numRoots++] = 1.0;
        }
        return Polynomial.trim(numRoots, roots);
    }

    public static @NonNull Polynomial bezout(double[] e1, double[] e2) {
        double AB = e1[0] * e2[1] - e2[0] * e1[1];
        double AC = e1[0] * e2[2] - e2[0] * e1[2];
        double AD = e1[0] * e2[3] - e2[0] * e1[3];
        double AE = e1[0] * e2[4] - e2[0] * e1[4];
        double AF = e1[0] * e2[5] - e2[0] * e1[5];
        double BC = e1[1] * e2[2] - e2[1] * e1[2];
        double BE = e1[1] * e2[4] - e2[1] * e1[4];
        double BF = e1[1] * e2[5] - e2[1] * e1[5];
        double CD = e1[2] * e2[3] - e2[2] * e1[3];
        double DE = e1[3] * e2[4] - e2[3] * e1[4];
        double DF = e1[3] * e2[5] - e2[3] * e1[5];
        double BFpDE = BF + DE;
        double BEmCD = BE - CD;
        return new Polynomial(AB * BC - AC * AC, AB * BEmCD + AD * BC - 2.0 * AC * AE, AB * BFpDE + AD * BEmCD - AE * AE - 2.0 * AC * AF, AB * DF + AD * BFpDE - 2.0 * AE * AF, AD * DF - AF * AF);
    }

    public static @NonNull Point2D.Double bottomRight(@NonNull Point2D a, @NonNull Point2D b) {
        return new Point2D.Double(Math.max(a.getX(), b.getX()), Math.max(a.getY(), b.getY()));
    }

    public static @NonNull Point2D.Double bottomRight(double ax, double ay, double bx, double by) {
        return new Point2D.Double(Math.max(ax, bx), Math.max(ay, by));
    }

    static boolean gte(@NonNull Point2D a, @NonNull Point2D b) {
        return a.getX() >= b.getX() && a.getY() >= b.getY();
    }

    static boolean lte(@NonNull Point2D a, @NonNull Point2D b) {
        return a.getX() <= b.getX() && a.getY() <= b.getY();
    }

    public static @NonNull Point2D.Double topLeft(@NonNull Point2D a, @NonNull Point2D b) {
        return new Point2D.Double(Math.min(a.getX(), b.getX()), Math.min(a.getY(), b.getY()));
    }

    public static @NonNull Point2D.Double topLeft(double ax, double ay, double bx, double by) {
        return new Point2D.Double(Math.min(ax, bx), Math.min(ay, by));
    }
}

