/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.shape;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.NoSuchElementException;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.geom.shape.BezierNode;
import org.jhotdraw8.geom.shape.BezierPath;

public class BezierPathIterator
implements PathIterator {
    private @NonNull State state;
    private int index;
    private int lastMoveTo;
    private final @NonNull BezierPath path;
    private final @NonNull AffineTransform transform;
    private final double @NonNull [] segCoords = new double[6];
    private int segType;

    public BezierPathIterator(@NonNull BezierPath path, @Nullable AffineTransform transform) {
        this.path = path;
        AffineTransform affineTransform = this.transform = transform == null ? AffineTransform.getTranslateInstance(0.0, 0.0) : transform;
        if (path.isEmpty()) {
            this.state = State.DONE;
        } else {
            this.segType = 0;
            BezierNode current = path.get(0);
            this.segCoords[0] = current.pointX();
            this.segCoords[1] = current.pointY();
            if (path.size() > 1) {
                this.state = State.PRODUCE_SEGMENT;
                ++this.index;
            } else {
                this.state = State.FINAL_SEGMENT;
            }
        }
    }

    @Override
    public int getWindingRule() {
        return this.path.getWindingRule();
    }

    @Override
    public boolean isDone() {
        return this.state == State.DONE;
    }

    @Override
    public void next() {
        if (this.isDone()) {
            return;
        }
        switch (this.state.ordinal()) {
            case 3: {
                this.state = State.DONE;
                break;
            }
            case 0: {
                BezierNode prev = this.path.get(this.index - 1);
                BezierNode current = this.path.get(this.index);
                if (current.hasMask(8)) {
                    this.segCoords[0] = current.pointX();
                    this.segCoords[1] = current.pointY();
                    this.segType = 0;
                    this.lastMoveTo = this.index;
                } else if (prev.hasOut() && current.hasIn()) {
                    this.segCoords[0] = prev.outX();
                    this.segCoords[1] = prev.outY();
                    this.segCoords[2] = current.inX();
                    this.segCoords[3] = current.inY();
                    this.segCoords[4] = current.pointX();
                    this.segCoords[5] = current.pointY();
                    this.segType = 3;
                } else if (prev.hasOut()) {
                    this.segCoords[0] = prev.outX();
                    this.segCoords[1] = prev.outY();
                    this.segCoords[2] = current.pointX();
                    this.segCoords[3] = current.pointY();
                    this.segType = 2;
                } else if (current.hasIn()) {
                    this.segCoords[0] = current.inX();
                    this.segCoords[1] = current.inY();
                    this.segCoords[2] = current.pointX();
                    this.segCoords[3] = current.pointY();
                    this.segType = 2;
                } else {
                    this.segCoords[0] = current.pointX();
                    this.segCoords[1] = current.pointY();
                    this.segType = 1;
                }
                if (current.hasMask(16)) {
                    this.state = State.CLOSE_PATH;
                    break;
                }
                if (this.index < this.path.size() - 1) {
                    ++this.index;
                    break;
                }
                this.state = State.FINAL_SEGMENT;
                break;
            }
            case 1: {
                BezierNode current = this.path.get(this.index);
                BezierNode lastMove = this.path.get(this.lastMoveTo);
                if (current.hasOut() && lastMove.hasIn()) {
                    this.segCoords[0] = current.outX();
                    this.segCoords[1] = current.outY();
                    this.segCoords[2] = lastMove.inX();
                    this.segCoords[3] = lastMove.inY();
                    this.segCoords[4] = lastMove.pointX();
                    this.segCoords[5] = lastMove.pointY();
                    this.segType = 3;
                    this.state = State.PRODUCE_CLOSE;
                    break;
                }
                if (current.hasOut()) {
                    this.segCoords[0] = current.outX();
                    this.segCoords[1] = current.outY();
                    this.segCoords[2] = lastMove.pointX();
                    this.segCoords[3] = lastMove.pointY();
                    this.segType = 2;
                    this.state = State.PRODUCE_CLOSE;
                    break;
                }
                if (lastMove.hasIn()) {
                    this.segCoords[0] = lastMove.inX();
                    this.segCoords[1] = lastMove.inY();
                    this.segCoords[2] = lastMove.pointX();
                    this.segCoords[3] = lastMove.pointY();
                    this.segType = 2;
                    this.state = State.PRODUCE_CLOSE;
                    break;
                }
                if (this.index < this.path.size() - 1) {
                    this.segType = 4;
                    this.state = State.PRODUCE_SEGMENT;
                    ++this.index;
                    break;
                }
                this.segType = 4;
                this.state = State.FINAL_SEGMENT;
                break;
            }
            case 2: {
                this.segType = 4;
                if (this.index < this.path.size() - 1) {
                    this.segType = 4;
                    this.state = State.PRODUCE_SEGMENT;
                    ++this.index;
                    break;
                }
                this.state = State.FINAL_SEGMENT;
                break;
            }
            default: {
                throw new NoSuchElementException();
            }
        }
    }

    @Override
    public int currentSegment(double[] coords) {
        switch (this.segType) {
            case 0: 
            case 1: {
                this.transform.transform(this.segCoords, 0, coords, 0, 1);
                break;
            }
            case 2: {
                this.transform.transform(this.segCoords, 0, coords, 0, 2);
                break;
            }
            case 3: {
                this.transform.transform(this.segCoords, 0, coords, 0, 3);
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new NoSuchElementException();
            }
        }
        return this.segType;
    }

    @Override
    public int currentSegment(float[] coords) {
        switch (this.segType) {
            case 0: 
            case 1: {
                this.transform.transform(this.segCoords, 0, coords, 0, 1);
                break;
            }
            case 2: {
                this.transform.transform(this.segCoords, 0, coords, 0, 2);
                break;
            }
            case 3: {
                this.transform.transform(this.segCoords, 0, coords, 0, 3);
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new NoSuchElementException();
            }
        }
        return this.segType;
    }

    static enum State {
        PRODUCE_SEGMENT,
        CLOSE_PATH,
        PRODUCE_CLOSE,
        FINAL_SEGMENT,
        DONE;

    }
}

