/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.shape;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.SvgPaths;

public interface PathMetrics
extends Shape {
    public double arcLength();

    @Override
    default public PathIterator getPathIterator(@Nullable AffineTransform tx) {
        return this.getSubPathIterator(0.0, this.arcLength(), tx);
    }

    default public @NonNull PointAndDerivative eval(double t) {
        return this.evalAtArcLength(t * this.arcLength());
    }

    public @NonNull PointAndDerivative evalAtArcLength(double var1);

    default public @NonNull PathIterator getSubPathIterator(double t0, double t1, @Nullable AffineTransform tx) {
        double totalArcLength = this.arcLength();
        double s0 = t0 * totalArcLength;
        double s1 = t1 * totalArcLength;
        return this.getSubPathIteratorAtArcLength(s0, s1, tx);
    }

    public @NonNull PathIterator getSubPathIteratorAtArcLength(double var1, double var3, @Nullable AffineTransform var5);

    public @NonNull PathMetrics reverse();

    public static String pathMetricsToString(@NonNull PathMetrics pm) {
        return "PathMetrics{" + pm.arcLength() + "px, \"" + SvgPaths.awtPathIteratorToDoubleSvgString(pm.getPathIterator(null)) + "\"}";
    }

    public boolean isEmpty();
}

