/*
 * @(#)IntersectPolygonPolygon.java
 * Copyright © 2023 The authors and contributors of JHotDraw. MIT License.
 */
package org.jhotdraw8.geom.intersect;


import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class IntersectPolygonPolygon {
    private IntersectPolygonPolygon() {
    }

    /**
     * Computes the intersection between two polygons.
     * <p>
     * The polygons must be closed. That is: the first and the last point of
     * each polygon must be equal.
     *
     * @param points1 the points of the first polygon
     * @param points2 the points of the second polygon
     * @return computed intersection
     */
    public static IntersectionResultEx intersectPolygonPolygonEx(List<Point2D.Double> points1, List<Point2D.Double> points2) {
        List<IntersectionPointEx> result = new ArrayList<>();
        IntersectionStatus status = IntersectionStatus.NO_INTERSECTION;
        int length = points1.size();

        for (int i = 0; i < length; i++) {
            Point2D.Double a1 = points1.get(i);
            Point2D.Double a2 = points1.get((i + 1) % length);
            IntersectionResultEx inter = IntersectLinePolygon.intersectLinePolygonEx(a1, a2, points2);

            result.addAll(inter.intersections().asList());
        }

        return new IntersectionResultEx(result);

    }
}
