/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.awt.geom.Point2D;
import org.jhotdraw8.geom.Points;

public class Angles {
    public static double angle(double x1, double y1, double x2, double y2) {
        double dy = y2 - y1;
        double dx = x2 - x1;
        return Angles.atan2(dy, dx);
    }

    public static double atan2(double dy, double dx) {
        return Points.almostZero(dy) && Points.almostZero(dx) ? 0.0 : Math.atan2(dy, dx);
    }

    public static double angleSubtract(double from, double to) {
        double diff = from - to;
        if (diff < Math.PI * -2) {
            diff += Math.PI * 2;
        }
        return diff;
    }

    public static double anglesSignedSpan(double from, double to) {
        double diff = to - from;
        if (diff > Math.PI) {
            diff -= Math.PI;
        } else if (diff < -Math.PI) {
            diff += Math.PI * 2;
        }
        return diff;
    }

    public static double anglesUnsignedSpan(double from, double to) {
        return from > to ? from - to : to - from;
    }

    public static int direction(double x1, double y1, double x2, double y2) {
        int direction = 0;
        double vy = y2 - y1;
        double vx = x2 - x1;
        direction = vy < vx && vx > -vy ? 4 : (vy > vx && vy > -vx ? 2 : (vx < vy && vx < -vy ? 1 : 8));
        return direction;
    }

    public static Point2D.Double perp(double x, double y) {
        return new Point2D.Double(y, -x);
    }

    public static double atan2Ellipse(double cx, double cy, double rx, double ry, double x, double y) {
        return Angles.atan2(y, x);
    }

    public static double sinDegrees(double aDeg) {
        int aDegInt = (int)aDeg;
        if (aDeg == (double)aDegInt) {
            switch (aDegInt % 360) {
                case 0: {
                    return 0.0;
                }
                case -330: 
                case -210: 
                case 30: 
                case 150: {
                    return 0.5;
                }
                case -150: 
                case -30: 
                case 210: 
                case 330: {
                    return -0.5;
                }
                case -315: 
                case -225: 
                case 45: 
                case 135: {
                    return Math.sqrt(0.5);
                }
                case -135: 
                case -45: 
                case 225: 
                case 315: {
                    return -Math.sqrt(0.5);
                }
                case -300: 
                case -240: 
                case 60: 
                case 120: {
                    return Math.sqrt(0.75);
                }
                case -120: 
                case -60: 
                case 240: 
                case 300: {
                    return -Math.sqrt(0.75);
                }
                case -270: 
                case 90: {
                    return 1.0;
                }
                case -90: 
                case 270: {
                    return -1.0;
                }
            }
        }
        return Math.sin(Math.toRadians(aDeg));
    }

    public static double cosDegrees(double aDeg) {
        return Angles.sinDegrees(aDeg + 90.0);
    }
}

