/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.util.DoubleSummaryStatistics;
import org.jhotdraw8.geom.AbstractPathBuilder;

public class AreaMetricsBuilder
extends AbstractPathBuilder<Double> {
    private final DoubleSummaryStatistics areaTimesTwo = new DoubleSummaryStatistics();
    double lastMoveToX;
    double lastMoveToY;

    @Override
    protected void doClosePath(double lastX, double lastY, double lastMoveToX, double lastMoveToY) {
        this.addToArea(this.lastMoveToX, this.lastMoveToY, lastX, this.getLastY());
    }

    private void addToArea(double x0, double y0, double x1, double y1) {
        this.areaTimesTwo.accept((x0 + x1) * (y0 - y1));
    }

    @Override
    protected void doCurveTo(double lastX, double lastY, double x1, double y1, double x2, double y2, double x, double y) {
        this.addToArea(lastX, lastY, x, y);
    }

    @Override
    protected void doLineTo(double lastX, double lastY, double x, double y) {
        this.addToArea(lastX, lastY, x, y);
    }

    @Override
    protected void doMoveTo(double x, double y) {
        this.lastMoveToX = x;
        this.lastMoveToY = y;
    }

    @Override
    protected void doQuadTo(double lastX, double lastY, double x1, double y1, double x, double y) {
        this.addToArea(this.lastMoveToX, this.lastMoveToY, lastX, lastY);
    }

    @Override
    public Double build() {
        return Math.abs(this.areaTimesTwo.getSum()) * 0.5;
    }
}

