/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.List;
import org.jhotdraw8.geom.AwtPathBuilder;
import org.jhotdraw8.geom.PathBuilder;
import org.jhotdraw8.geom.intersect.IntersectLinePoint;
import org.jspecify.annotations.Nullable;

public class AwtShapes {
    public static <T extends PathBuilder<?>> T buildPathIterator(T builder, PathIterator iter) {
        double[] coords = new double[6];
        while (!iter.isDone()) {
            switch (iter.currentSegment(coords)) {
                case 4: {
                    builder.closePath();
                    break;
                }
                case 3: {
                    builder.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 1: {
                    builder.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    builder.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 0: {
                    builder.moveTo(coords[0], coords[1]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported segment type:" + iter.currentSegment(coords));
                }
            }
            iter.next();
        }
        return builder;
    }

    public static boolean outlineContains(Shape shape, Point2D.Double p, double tolerance) {
        AwtPathBuilder b = new AwtPathBuilder();
        double[] coords = new double[6];
        double prevX = 0.0;
        double prevY = 0.0;
        double moveX = 0.0;
        double moveY = 0.0;
        FlatteningPathIterator i = new FlatteningPathIterator(shape.getPathIterator(new AffineTransform(), tolerance), Math.abs(tolerance + 1.0E-5));
        while (!i.isDone()) {
            switch (i.currentSegment(coords)) {
                case 4: {
                    if (!IntersectLinePoint.lineContainsPoint(prevX, prevY, moveX, moveY, p.x, p.y, tolerance)) break;
                    return true;
                }
                case 1: {
                    if (!IntersectLinePoint.lineContainsPoint(prevX, prevY, coords[0], coords[1], p.x, p.y, tolerance)) break;
                    return true;
                }
                case 0: {
                    moveX = coords[0];
                    moveY = coords[1];
                    break;
                }
            }
            prevX = coords[0];
            prevY = coords[1];
            i.next();
        }
        return false;
    }

    public static PathIterator emptyPathIterator() {
        return new PathIterator(){

            @Override
            public int getWindingRule() {
                return 0;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public void next() {
            }

            @Override
            public int currentSegment(float[] coords) {
                return 4;
            }

            @Override
            public int currentSegment(double[] coords) {
                return 4;
            }
        };
    }

    public static PathIterator pointCoordsToPathIterator(final List<Double> coordsList, final boolean closed, final int windingRule, final @Nullable AffineTransform tx) {
        return new PathIterator(){
            private final int size;
            int index;
            final float[] srcf;
            final double[] srcd;
            {
                this.size = coordsList.size();
                this.index = 0;
                this.srcf = tx == null ? null : new float[2];
                this.srcd = tx == null ? null : new double[2];
            }

            @Override
            public int currentSegment(float[] coords) {
                if (this.index < this.size) {
                    double x = (Double)coordsList.get(this.index);
                    double y = (Double)coordsList.get(this.index + 1);
                    if (tx == null) {
                        coords[0] = (float)x;
                        coords[1] = (float)y;
                    } else {
                        this.srcf[0] = (float)x;
                        this.srcf[1] = (float)y;
                        tx.transform(this.srcf, 0, coords, 0, 1);
                    }
                    return this.index == 0 ? 0 : 1;
                }
                if (this.index == this.size && closed) {
                    return 4;
                }
                throw new IndexOutOfBoundsException();
            }

            @Override
            public int currentSegment(double[] coords) {
                if (this.index < this.size) {
                    double x = (Double)coordsList.get(this.index);
                    double y = (Double)coordsList.get(this.index + 1);
                    if (tx == null) {
                        coords[0] = x;
                        coords[1] = y;
                    } else {
                        this.srcd[0] = x;
                        this.srcd[1] = y;
                        tx.transform(this.srcd, 0, coords, 0, 1);
                    }
                    return this.index == 0 ? 0 : 1;
                }
                if (this.index == this.size && closed) {
                    return 4;
                }
                throw new IndexOutOfBoundsException();
            }

            @Override
            public int getWindingRule() {
                return windingRule;
            }

            @Override
            public boolean isDone() {
                return this.index >= this.size + (closed ? 2 : 0);
            }

            @Override
            public void next() {
                if (this.index < this.size + (closed ? 2 : 0)) {
                    this.index += 2;
                }
            }
        };
    }

    private AwtShapes() {
    }
}

