/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.awt.geom.Rectangle2D;
import java.util.PrimitiveIterator;
import javafx.geometry.BoundingBox;
import javafx.scene.shape.Rectangle;
import org.jhotdraw8.geom.AbstractPathBuilder;
import org.jhotdraw8.geom.CubicCurveCharacteristics;
import org.jhotdraw8.geom.CubicCurves;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.QuadCurveCharacteristics;
import org.jhotdraw8.geom.QuadCurves;

public class BoundingBoxBuilder
extends AbstractPathBuilder<BoundingBox> {
    private double minx = Double.POSITIVE_INFINITY;
    private double miny = Double.POSITIVE_INFINITY;
    private double maxx = Double.NEGATIVE_INFINITY;
    private double maxy = Double.NEGATIVE_INFINITY;

    @Override
    protected void doClosePath(double lastX, double lastY, double lastMoveToX, double lastMoveToY) {
    }

    public void addToBounds(double x, double y) {
        this.minx = Math.min(this.minx, x);
        this.miny = Math.min(this.miny, y);
        this.maxx = Math.max(this.maxx, x);
        this.maxy = Math.max(this.maxy, y);
    }

    @Override
    protected void doCurveTo(double lastX, double lastY, double x1, double y1, double x2, double y2, double x3, double y3) {
        PrimitiveIterator.OfDouble ofDouble = CubicCurveCharacteristics.extremePoints(lastX, lastY, x1, y1, x2, y2, x3, y3).iterator();
        while (ofDouble.hasNext()) {
            double t = (Double)ofDouble.next();
            PointAndDerivative eval = CubicCurves.eval(lastX, lastY, x1, y1, x2, y2, x3, y3, t);
            this.addToBounds(eval.x(), eval.y());
        }
        this.addToBounds(x3, y3);
    }

    @Override
    protected void doLineTo(double lastX, double lastY, double x, double y) {
        this.addToBounds(x, y);
    }

    @Override
    protected void doMoveTo(double x, double y) {
        this.addToBounds(x, y);
    }

    @Override
    protected void doQuadTo(double lastX, double lastY, double x1, double y1, double x2, double y2) {
        PrimitiveIterator.OfDouble ofDouble = QuadCurveCharacteristics.extremePoints(lastX, lastY, x1, y1, x2, y2).iterator();
        while (ofDouble.hasNext()) {
            double t = (Double)ofDouble.next();
            PointAndDerivative eval = QuadCurves.eval(lastX, lastY, x1, y1, x2, y2, t);
            this.addToBounds(eval.x(), eval.y());
        }
        this.addToBounds(x2, y2);
    }

    public Rectangle buildRectangle() {
        if (Double.isNaN(this.minx)) {
            return new Rectangle(0.0, 0.0, 0.0, 0.0);
        }
        return new Rectangle(this.minx, this.miny, this.maxx - this.minx, this.maxy - this.miny);
    }

    public Rectangle2D.Double buildRectangle2D() {
        if (Double.isNaN(this.minx)) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        return new Rectangle2D.Double(this.minx, this.miny, this.maxx - this.minx, this.maxy - this.miny);
    }

    @Override
    public BoundingBox build() {
        if (Double.isNaN(this.minx)) {
            return new BoundingBox(0.0, 0.0, 0.0, 0.0);
        }
        return new BoundingBox(this.minx, this.miny, this.maxx - this.minx, this.maxy - this.miny);
    }

    public boolean isFinite() {
        return Double.isFinite(this.minx) && Double.isFinite(this.miny) && Double.isFinite(this.maxx) && Double.isFinite(this.maxy);
    }
}

