/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Point2D;

public class CardinalSplines {
    private CardinalSplines() {
    }

    public static Point2D[] cardinalSplineToBezier(Point2D[] p, double c) {
        ArrayList<Point2D> b = new ArrayList<Point2D>();
        int n = p.length;
        for (int k = 1; k < n - 2; ++k) {
            Point2D A = p[k - 1];
            Point2D B = p[k];
            Point2D E = p[k + 1];
            Point2D F = p[k + 2];
            Point2D C = B.add(E.subtract(A).multiply(c / 3.0));
            Point2D D = E.subtract(F.subtract(B).multiply(c / 3.0));
            if (b.isEmpty()) {
                b.add(B);
            }
            b.add(C);
            b.add(D);
            b.add(E);
        }
        return b.toArray(new Point2D[0]);
    }

    public static Point2D[] cardinalSplineToBezier(double[] p, double c) {
        Point2D[] points = new Point2D[p.length / 2];
        for (int i = 0; i < points.length; ++i) {
            points[i] = new Point2D(p[i * 2], p[i * 2 + 1]);
        }
        return CardinalSplines.cardinalSplineToBezier(points, c);
    }

    public static Point2D[] cardinalSplineToBezier(List<Double> p, double c) {
        Point2D[] points = new Point2D[p.size() / 2];
        for (int i = 0; i < points.length; ++i) {
            points[i] = new Point2D(p.get(i * 2).doubleValue(), p.get(i * 2 + 1).doubleValue());
        }
        return CardinalSplines.cardinalSplineToBezier(points, c);
    }
}

