/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.awt.geom.PathIterator;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;
import javafx.scene.shape.FillRule;
import org.jspecify.annotations.Nullable;

public class ConcatenatedPathIterator
implements PathIterator {
    private @Nullable PathIterator current;
    private final Deque<PathIterator> iterators;
    private final int windingRule;

    public ConcatenatedPathIterator(FillRule fillRule, List<PathIterator> iteratorList) {
        this(fillRule == FillRule.EVEN_ODD ? 0 : 1, iteratorList);
    }

    public ConcatenatedPathIterator(int windingRule, List<PathIterator> iteratorList) {
        this.windingRule = windingRule;
        this.iterators = new ArrayDeque<PathIterator>(iteratorList);
        this.current = iteratorList.isEmpty() ? null : this.iterators.removeFirst();
    }

    @Override
    public int currentSegment(float[] coords) {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.current.currentSegment(coords);
    }

    @Override
    public int currentSegment(double[] coords) {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.current.currentSegment(coords);
    }

    @Override
    public int getWindingRule() {
        return this.windingRule;
    }

    @Override
    public boolean isDone() {
        while (this.current != null && this.current.isDone()) {
            this.current = this.iterators.isEmpty() ? null : this.iterators.removeFirst();
        }
        return this.current == null;
    }

    @Override
    public void next() {
        if (!this.isDone() && this.current != null) {
            this.current.next();
        }
    }
}

