/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.List;

public class ConvexHull {
    private ConvexHull() {
    }

    public static List<Point2D.Double> getConvexHull2D(List<Point2D.Double> points) {
        return Arrays.asList(ConvexHull.getConvexHull2D(points.toArray(new Point2D.Double[0])));
    }

    public static Point2D.Double[] getConvexHull2D(Point2D.Double[] points) {
        if (points.length < 3) {
            return (Point2D.Double[])points.clone();
        }
        Point2D.Double[] sorted = (Point2D.Double[])points.clone();
        Arrays.sort(sorted, (o1, o2) -> {
            int cmp = Double.compare(o1.x, o2.x);
            return cmp == 0 ? Double.compare(o1.y, o2.y) : cmp;
        });
        Point2D.Double[] hull = new Point2D.Double[sorted.length + 2];
        int upper = 0;
        hull[upper++] = sorted[0];
        hull[upper++] = sorted[1];
        for (int i = 2; i < sorted.length; ++i) {
            hull[upper++] = sorted[i];
            while (upper > 2 && !ConvexHull.isRightTurn2D(hull[upper - 3], hull[upper - 2], hull[upper - 1])) {
                hull[upper - 2] = hull[upper - 1];
                --upper;
            }
        }
        int lower = upper;
        hull[lower++] = sorted[sorted.length - 2];
        for (int i = sorted.length - 3; i >= 0; --i) {
            hull[lower++] = sorted[i];
            while (lower - upper > 1 && !ConvexHull.isRightTurn2D(hull[lower - 3], hull[lower - 2], hull[lower - 1])) {
                hull[lower - 2] = hull[lower - 1];
                --lower;
            }
        }
        Point2D.Double[] convexHull = new Point2D.Double[--lower];
        System.arraycopy(hull, 0, convexHull, 0, lower);
        return convexHull;
    }

    public static boolean isRightTurn2D(Point2D.Double p1, Point2D.Double p2, Point2D.Double p3) {
        if (p1.equals(p2) || p2.equals(p3)) {
            return false;
        }
        double val = p2.x * p3.y + p1.x * p2.y + p3.x * p1.y - (p2.x * p1.y + p3.x * p2.y + p1.x * p3.y);
        return val > 0.0;
    }
}

