/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.awt.geom.CubicCurve2D;
import java.util.PrimitiveIterator;
import org.jhotdraw8.collection.primitive.DoubleArrayList;
import org.jhotdraw8.geom.CubicCurveCharacteristics;
import org.jhotdraw8.geom.CubicCurves;
import org.jhotdraw8.geom.Points;

public class CubicCurveToQuadCurves {
    public int approximateCubicCurve(double[] p, int offsetP, double[] q, int offsetQ, double tolerance) {
        return this.approximateCubicCurve(p, offsetP, q, offsetQ, tolerance, 2);
    }

    private int approximateCubicCurve(double[] p, int offsetP, double[] q, int offsetQ, double tolerance, int maxDepth) {
        double errorSquared;
        double d = errorSquared = maxDepth == 0 ? 0.0 : this.estimateCubicCurveApproximationErrorSquared(p, offsetP);
        if (errorSquared > tolerance * tolerance) {
            DoubleArrayList list = CubicCurveCharacteristics.inflectionPoints(p, offsetP);
            Double singularPoint = CubicCurveCharacteristics.singularPoint(p, offsetP);
            if (singularPoint != null) {
                list.add(singularPoint);
                list.sort();
            }
            double epsilon = 1.0E-6;
            PrimitiveIterator.OfDouble ofDouble = list.iterator();
            while (ofDouble.hasNext()) {
                double t = (Double)ofDouble.next();
                if (Points.almostEqual(t, 0.0, 1.0E-6) || Points.almostEqual(t, 1.0, 1.0E-6)) continue;
                return this.approximateCubicCurveSplitCase(p, offsetP, t, q, offsetQ, tolerance, maxDepth);
            }
            return this.approximateCubicCurveSplitCase(p, offsetP, 0.5, q, offsetQ, tolerance, maxDepth);
        }
        return this.approximateCubicCurveBaseCase(p, offsetP, q, offsetQ, tolerance);
    }

    private int approximateCubicCurveBaseCase(double[] p, int offsetP, double[] q, int offsetQ, double tolerance) {
        double x0 = p[offsetP];
        double y0 = p[offsetP + 1];
        double x1 = p[offsetP + 2];
        double y1 = p[offsetP + 3];
        double x2 = p[offsetP + 4];
        double y2 = p[offsetP + 5];
        double x3 = p[offsetP + 6];
        double y3 = p[offsetP + 7];
        int qq = offsetQ;
        q[qq] = x0;
        q[qq + 1] = y0;
        if (CubicCurve2D.getFlatnessSq(p, offsetP) <= tolerance * tolerance) {
            q[qq + 2] = (x0 + x3) * 0.5;
            q[qq + 3] = (y0 + y3) * 0.5;
            q[qq + 4] = x3;
            q[qq + 5] = y3;
            return 1;
        }
        double gamma = 0.5;
        double x2i = x0 + 1.5 * gamma * (x1 - x0);
        double y2i = y0 + 1.5 * gamma * (y1 - y0);
        double x2iplus1 = x3 + 1.5 * (1.0 - gamma) * (x2 - x3);
        double y2iplus1 = y3 + 1.5 * (1.0 - gamma) * (y2 - y3);
        q[qq + 2] = x2i;
        q[qq + 3] = y2i;
        double d = (1.0 - gamma) * x2i + gamma * x2iplus1;
        q[qq + 6] = d;
        q[qq + 4] = d;
        double d2 = (1.0 - gamma) * y2i + gamma * y2iplus1;
        q[qq + 7] = d2;
        q[qq + 5] = d2;
        q[qq + 8] = x2iplus1;
        q[qq + 9] = y2iplus1;
        q[qq + 10] = x3;
        q[qq + 11] = y3;
        return 2;
    }

    private int approximateCubicCurveSplitCase(double[] p, int offsetP, double t, double[] q, int offsetQ, double tolerance, int maxDepth) {
        double[] pp = new double[16];
        CubicCurves.split(p, offsetP, t, pp, 0, pp, 8);
        int count = this.approximateCubicCurve(pp, 0, q, offsetQ, tolerance, maxDepth - 1);
        return count + this.approximateCubicCurve(pp, 8, q, offsetQ + count * 6, tolerance, maxDepth - 1);
    }

    private double estimateCubicCurveApproximationErrorSquared(double[] p, int offsetP) {
        double x0 = p[offsetP];
        double y0 = p[offsetP + 1];
        double x1 = p[offsetP + 2];
        double y1 = p[offsetP + 3];
        double x2 = p[offsetP + 4];
        double y2 = p[offsetP + 5];
        double x3 = p[offsetP + 6];
        double y3 = p[offsetP + 7];
        double ex = -x0 + 3.0 * x1 - 3.0 * x2 + x3;
        double ey = -y0 + 3.0 * y1 - 3.0 * y2 + y3;
        return (ex * ex + ey * ey) * 3.429355281207133E-4;
    }
}

