/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.util.Arrays;
import java.util.List;
import javafx.geometry.Point2D;

public class FXConvexHull {
    private FXConvexHull() {
    }

    public static List<Point2D> getConvexHull(List<Point2D> points) {
        return Arrays.asList(FXConvexHull.getConvexHull(points.toArray(new Point2D[0])));
    }

    public static Point2D[] getConvexHull(Point2D[] points) {
        if (points.length < 3) {
            return (Point2D[])points.clone();
        }
        Point2D[] sorted = (Point2D[])points.clone();
        Arrays.sort(sorted, (o1, o2) -> {
            double v = o1.getX() - o2.getX();
            if (v == 0.0) {
                v = o1.getY() - o2.getY();
            }
            return v > 0.0 ? 1 : (v < 0.0 ? -1 : 0);
        });
        Point2D[] hull = new Point2D[sorted.length + 2];
        int upper = 0;
        hull[upper++] = sorted[0];
        hull[upper++] = sorted[1];
        for (int i = 2; i < sorted.length; ++i) {
            hull[upper++] = sorted[i];
            while (upper > 2 && !FXConvexHull.isRightTurn(hull[upper - 3], hull[upper - 2], hull[upper - 1])) {
                hull[upper - 2] = hull[upper - 1];
                --upper;
            }
        }
        int lower = upper;
        hull[lower++] = sorted[sorted.length - 2];
        for (int i = sorted.length - 3; i >= 0; --i) {
            hull[lower++] = sorted[i];
            while (lower - upper > 1 && !FXConvexHull.isRightTurn(hull[lower - 3], hull[lower - 2], hull[lower - 1])) {
                hull[lower - 2] = hull[lower - 1];
                --lower;
            }
        }
        Point2D[] convexHull = new Point2D[--lower];
        System.arraycopy(hull, 0, convexHull, 0, lower);
        return convexHull;
    }

    public static boolean isRightTurn(Point2D p1, Point2D p2, Point2D p3) {
        if (p1.equals((Object)p2) || p2.equals((Object)p3)) {
            return false;
        }
        double val = p2.getX() * p3.getY() + p1.getX() * p2.getY() + p3.getX() * p1.getY() - (p2.getX() * p1.getY() + p3.getX() * p2.getY() + p1.getX() * p3.getY());
        return val > 0.0;
    }
}

