/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import org.jhotdraw8.geom.AbstractPathBuilder;

public class FXPathPointsBuilder
extends AbstractPathBuilder<List<PathElement>> {
    private final List<PathElement> elements;
    private boolean needsSquareAtLastPoint;
    private double squareSize = 5.0;

    public FXPathPointsBuilder() {
        this(5.0, new ArrayList<PathElement>());
    }

    public FXPathPointsBuilder(List<PathElement> elements) {
        this(5.0, elements);
    }

    public FXPathPointsBuilder(double squareSize, List<PathElement> elements) {
        this.elements = elements;
        this.squareSize = squareSize;
    }

    private void addSquare(double x, double y) {
        double halfSize = this.squareSize * 0.5;
        this.elements.add((PathElement)new MoveTo(x - halfSize, y - halfSize));
        this.elements.add((PathElement)new LineTo(x + halfSize, y - halfSize));
        this.elements.add((PathElement)new LineTo(x + halfSize, y + halfSize));
        this.elements.add((PathElement)new LineTo(x - halfSize, y + halfSize));
        this.elements.add((PathElement)new ClosePath());
    }

    @Override
    public List<PathElement> build() {
        if (this.needsSquareAtLastPoint) {
            this.addSquare(this.getLastX(), this.getLastY());
            this.needsSquareAtLastPoint = false;
        }
        return this.elements;
    }

    @Override
    protected void doArcTo(double lastX, double lastY, double rx, double ry, double xAxisRotation, double x, double y, boolean largeArcFlag, boolean sweepFlag) {
        this.needsSquareAtLastPoint = true;
    }

    @Override
    protected void doClosePath(double lastX, double lastY, double lastMoveToX, double lastMoveToY) {
        if (this.needsSquareAtLastPoint) {
            this.addSquare(lastX, lastY);
            this.needsSquareAtLastPoint = false;
        }
    }

    @Override
    protected void doCurveTo(double lastX, double lastY, double x, double y, double x0, double y0, double x1, double y1) {
        this.needsSquareAtLastPoint = true;
    }

    @Override
    protected void doLineTo(double lastX, double lastY, double x, double y) {
        this.needsSquareAtLastPoint = true;
    }

    @Override
    protected void doMoveTo(double x, double y) {
        if (this.needsSquareAtLastPoint) {
            this.addSquare(this.getLastX(), this.getLastY());
            this.needsSquareAtLastPoint = false;
        }
        this.addSquare(x, y);
    }

    @Override
    protected void doQuadTo(double lastX, double lastY, double x, double y, double x0, double y0) {
        this.needsSquareAtLastPoint = true;
    }

    public List<PathElement> getElements() {
        if (this.needsSquareAtLastPoint) {
            this.addSquare(this.getLastX(), this.getLastY());
            this.needsSquareAtLastPoint = false;
        }
        return this.elements;
    }
}

