/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.transform.Rotate;
import org.jhotdraw8.geom.Angles;

public class FXPreciseRotate
extends Rotate {
    public FXPreciseRotate(double r, double x, double y) {
        super(r, x, y);
    }

    public FXPreciseRotate(double r) {
        this(r, 0.0, 0.0);
    }

    public Point2D inverseTransform(double x, double y) {
        Point3D axis = this.getAxis();
        if (axis == Z_AXIS || axis.getX() == 0.0 && axis.getY() == 0.0 && axis.getZ() > 0.0) {
            double px = this.getPivotX();
            double py = this.getPivotY();
            double angle = this.getAngle();
            double cos = Angles.cosDegrees(angle);
            double sin = Angles.sinDegrees(angle);
            double mxx = cos;
            double mxy = -sin;
            double tx = px * (1.0 - cos) + py * sin;
            double myx = sin;
            double myy = cos;
            double ty = py * (1.0 - cos) - px * sin;
            return new Point2D(mxx * x + mxy * y + tx, myx * x + myy * y + ty);
        }
        return super.transform(x, y);
    }

    public double getMxx() {
        return this.computeMatrix().mxx;
    }

    public double getMxy() {
        return this.computeMatrix().mxy;
    }

    public double getTx() {
        return this.computeMatrix().tx;
    }

    public double getMyx() {
        return this.computeMatrix().myx;
    }

    public double getMyy() {
        return this.computeMatrix().myy;
    }

    public double getTy() {
        return this.computeMatrix().ty;
    }

    private Matrix computeMatrix() {
        Point3D axis = this.getAxis();
        if (axis == Z_AXIS || axis.getX() == 0.0 && axis.getY() == 0.0 && axis.getZ() > 0.0) {
            double sin;
            double cos;
            double px = this.getPivotX();
            double py = this.getPivotY();
            double angle = this.getAngle();
            if (angle == 180.0 || angle == -180.0) {
                cos = -1.0;
                sin = 0.0;
            } else if (angle == 90.0) {
                cos = 0.0;
                sin = 1.0;
            } else if (angle == -90.0 || angle == 270.0) {
                cos = 0.0;
                sin = -1.0;
            } else {
                return new Matrix(super.getMxx(), super.getMxy(), super.getTx(), super.getMyx(), super.getMyy(), super.getTy());
            }
            double mxx = cos;
            double mxy = -sin;
            double tx = px * (1.0 - cos) + py * sin;
            double myx = sin;
            double myy = cos;
            double ty = py * (1.0 - cos) - px * sin;
            return new Matrix(mxx, mxy, tx, myx, myy, ty);
        }
        return new Matrix(super.getMxx(), super.getMxy(), super.getTx(), super.getMyx(), super.getMyy(), super.getTy());
    }

    public Point2D transform(double x, double y) {
        Point3D axis = this.getAxis();
        if (axis == Z_AXIS || axis.getX() == 0.0 && axis.getY() == 0.0 && axis.getZ() > 0.0) {
            double sin;
            double cos;
            double px = this.getPivotX();
            double py = this.getPivotY();
            double angle = this.getAngle();
            if (angle == 180.0 || angle == -180.0) {
                cos = -1.0;
                sin = 0.0;
            } else if (angle == 90.0) {
                cos = 0.0;
                sin = 1.0;
            } else if (angle == -90.0 || angle == 270.0) {
                cos = 0.0;
                sin = -1.0;
            } else {
                return super.transform(x, y);
            }
            double mxx = cos;
            double mxy = -sin;
            double tx = px * (1.0 - cos) + py * sin;
            double myx = sin;
            double myy = cos;
            double ty = py * (1.0 - cos) - px * sin;
            return new Point2D(Math.fma(mxx, x, Math.fma(mxy, y, tx)), Math.fma(myx, x, Math.fma(myy, y, ty)));
        }
        return super.transform(x, y);
    }

    public void transform2DPoints(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (srcPts == null || dstPts == null) {
            throw new NullPointerException();
        }
        srcOff = this.getFixedSrcOffset(srcPts, srcOff, dstPts, dstOff, numPts, 2);
        this.transform2DPointsImpl(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    private int getFixedSrcOffset(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts, int dimensions) {
        if (dstPts == srcPts && dstOff > srcOff && dstOff < srcOff + numPts * dimensions) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * dimensions);
            return dstOff;
        }
        return srcOff;
    }

    private void transform2DPointsImpl(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        Matrix matrix = this.computeMatrix();
        double mxx = matrix.mxx;
        double myx = matrix.myx;
        double mxy = matrix.mxy;
        double myy = matrix.myy;
        double tx = matrix.tx;
        double ty = matrix.ty;
        while (numPts < 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            dstPts[dstOff++] = Math.fma(mxx, x, Math.fma(mxy, y, tx));
            dstPts[dstOff++] = Math.fma(myx, x, Math.fma(myy, y, ty));
            --numPts;
        }
    }

    public String toString() {
        return "FXPrecise" + super.toString();
    }

    private record Matrix(double mxx, double mxy, double tx, double myx, double myy, double ty) {
    }
}

