/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import org.jhotdraw8.geom.Rectangles;
import org.jspecify.annotations.Nullable;

public class FXRectangles {
    public static BoundingBox getBounds(Shape shape) {
        java.awt.geom.Rectangle2D r = shape.getBounds2D();
        return new BoundingBox(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public static Rectangle2D.Double toAwtRectangle2D(Bounds r) {
        return new Rectangle2D.Double(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight());
    }

    public static Rectangle2D toRectangle2D(Bounds r) {
        return new Rectangle2D(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight());
    }

    public static BoundingBox add(Bounds a, Bounds b) {
        double x = Math.min(a.getMinX(), b.getMinX());
        double y = Math.min(a.getMinY(), b.getMinY());
        return new BoundingBox(x, y, Math.max(a.getMaxX(), b.getMaxX()) - x, Math.max(a.getMaxY(), b.getMaxY()) - y);
    }

    public static Point2D center(Bounds r) {
        return new Point2D(r.getMinX() + r.getWidth() * 0.5, r.getMinY() + r.getHeight() * 0.5);
    }

    public static boolean contains(Bounds r, Point2D p, double tolerance) {
        return FXRectangles.contains(r, p.getX(), p.getY(), tolerance);
    }

    public static boolean contains(Bounds r, double x, double y, double tolerance) {
        return Rectangles.contains(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight(), x, y, tolerance);
    }

    public static Bounds getBounds(Rectangle2D r) {
        return new BoundingBox(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight());
    }

    public static Bounds grow(Bounds r, double h, double v) {
        return new BoundingBox(r.getMinX() - h, r.getMinY() - v, r.getWidth() + h * 2.0, r.getHeight() + v * 2.0);
    }

    public static Bounds grow(Bounds r, double hv) {
        return FXRectangles.grow(r, hv, hv);
    }

    public static Bounds union(Bounds a, Bounds ... bs) {
        double minx = a.getMinX();
        double miny = a.getMinY();
        double maxx = a.getMaxX();
        double maxy = a.getMaxY();
        for (Bounds b : bs) {
            minx = Math.min(minx, b.getMinX());
            miny = Math.min(miny, b.getMinY());
            maxx = Math.max(maxx, b.getMaxX());
            maxy = Math.max(maxy, b.getMaxY());
        }
        return new BoundingBox(minx, miny, maxx - minx, maxy - miny);
    }

    public static boolean isFinite(Bounds bounds) {
        return Double.isFinite(bounds.getMinX()) && Double.isFinite(bounds.getMinY()) && Double.isFinite(bounds.getWidth()) && Double.isFinite(bounds.getHeight());
    }

    public static Bounds intersection(Bounds a, Bounds b) {
        double minx = Math.max(a.getMinX(), b.getMinX());
        double miny = Math.max(a.getMinY(), b.getMinY());
        double maxx = Math.min(a.getMaxX(), b.getMaxX());
        double maxy = Math.min(a.getMaxY(), b.getMaxY());
        return new BoundingBox(minx, miny, maxx - minx, maxy - miny);
    }

    private static Rectangle2D add(Rectangle2D r, double newx, double newy) {
        double x1 = Math.min(r.getMinX(), newx);
        double x2 = Math.max(r.getMaxX(), newx);
        double y1 = Math.min(r.getMinY(), newy);
        double y2 = Math.max(r.getMaxY(), newy);
        return new Rectangle2D(x1, y1, x2 - x1, y2 - y1);
    }

    public static Point2D center(java.awt.geom.Rectangle2D r) {
        return new Point2D(r.getCenterX(), r.getCenterY());
    }

    public static Point2D center(Rectangle2D r) {
        return new Point2D(r.getMinX() + r.getWidth() * 0.5, r.getMinY() + r.getHeight() * 0.5);
    }

    public static Point2D east(Rectangle2D r) {
        return new Point2D(r.getMinX() + r.getWidth(), r.getMinY() + r.getHeight() / 2.0);
    }

    public static Point2D north(Rectangle2D r) {
        return new Point2D(r.getMinX() + r.getWidth() * 0.5, r.getMinY());
    }

    public static int outcode(Rectangle2D r1, Rectangle2D r2) {
        int outcode = 0;
        if (r2.getMinX() > r1.getMinX() + r1.getWidth()) {
            outcode = 4;
        } else if (r2.getMinX() + r2.getWidth() < r1.getMinX()) {
            outcode = 1;
        }
        if (r2.getMinY() > r1.getMinY() + r1.getHeight()) {
            outcode |= 8;
        } else if (r2.getMinY() + r2.getHeight() < r1.getMinY()) {
            outcode |= 2;
        }
        return outcode;
    }

    public static Point2D south(Rectangle2D r) {
        return new Point2D(r.getMinX() + r.getWidth() * 0.5, r.getMinY() + r.getHeight());
    }

    static BoundingBox subtractInsets(Bounds b, Insets i) {
        return new BoundingBox(b.getMinX() + i.getLeft(), b.getMinY() + i.getTop(), b.getWidth() - i.getLeft() - i.getRight(), b.getHeight() - i.getTop() - i.getBottom());
    }

    public static boolean isEmpty(Rectangle2D b) {
        return b.getWidth() <= 0.0 || b.getHeight() <= 0.0;
    }

    public static String toString(@Nullable Bounds b) {
        return b == null ? "null" : b.getMinX() + "," + b.getMinY() + "," + b.getWidth() + "," + b.getHeight();
    }

    public static boolean contains(Rectangle2D r1, Rectangle2D r2) {
        return r2.getMinX() >= r1.getMinX() && r2.getMinY() >= r1.getMinY() && r2.getMinX() + Math.max(0.0, r2.getWidth()) <= r1.getMinX() + Math.max(0.0, r1.getWidth()) && r2.getMinY() + Math.max(0.0, r2.getHeight()) <= r1.getMinY() + Math.max(0.0, r1.getHeight());
    }

    public static Rectangle2D grow(Rectangle2D r, double h, double v) {
        return new Rectangle2D(r.getMinX() - h, r.getMinY() - v, r.getWidth() + h * 2.0, r.getHeight() + v * 2.0);
    }

    public static String toString(@Nullable Rectangle2D b) {
        return b == null ? "null" : b.getMinX() + "," + b.getMinY() + "," + b.getWidth() + "," + b.getHeight();
    }

    public static Point2D west(Rectangle2D r) {
        return new Point2D(r.getMinX(), r.getMinY() + r.getHeight() / 2.0);
    }
}

