/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.util.function.ToDoubleFunction;

public class Integrals {
    private Integrals() {
    }

    public static double rombergQuadrature(ToDoubleFunction<Double> f, double t0, double t1) {
        return Integrals.rombergQuadrature(f, t0, t1, 0.1);
    }

    public static double rombergQuadrature(ToDoubleFunction<Double> f, double t0, double t1, double epsilon) {
        int maxSteps = 5;
        double h = t1 - t0;
        double[] Rp = new double[maxSteps];
        double[] Rc = new double[maxSteps];
        Rp[0] = (f.applyAsDouble(t0) + f.applyAsDouble(t1)) * h * 0.5;
        for (int i = 1; i < maxSteps; ++i) {
            h *= 0.5;
            double c = 0.0;
            int ep = 1 << i - 1;
            for (int j = 1; j <= ep; ++j) {
                c += f.applyAsDouble(Math.fma((double)(2 * j - 1), h, t0));
            }
            Rc[0] = Math.fma(h, c, 0.5 * Rp[0]);
            double n_k = 1.0;
            for (int j = 1; j <= i; ++j) {
                Rc[j] = Math.fma(n_k *= 4.0, Rc[j - 1], -Rp[j - 1]) / (n_k - 1.0);
            }
            if (i > 1 && Math.abs(Rp[i - 1] - Rc[i]) < epsilon) {
                return Rc[i - 1];
            }
            double[] tmp = Rp;
            Rp = Rc;
            Rc = tmp;
        }
        return Rp[maxSteps - 1];
    }

    public static double simpson(ToDoubleFunction<Double> func, double min, double max, double eps) {
        double s;
        double st;
        int maxSteps = 20;
        double range = max - min;
        double t = st = 0.5 * range * (func.applyAsDouble(min) + func.applyAsDouble(max));
        double os = s = 4.0 * st / 3.0;
        double ost = st;
        int it = 1;
        for (int n = 2; n <= maxSteps; ++n) {
            double delta = range / (double)it;
            double x = min + 0.5 * delta;
            double sum = 0.0;
            for (double i = 1.0; i <= (double)it; i += 1.0) {
                sum += func.applyAsDouble(x);
                x += delta;
            }
            st = t = 0.5 * (t + range * sum / (double)it);
            s = (4.0 * st - ost) / 3.0;
            if (Math.abs(s - os) < eps * Math.abs(os)) break;
            os = s;
            ost = st;
            it <<= 1;
        }
        return s;
    }

    public static double gaussLegendre3(ToDoubleFunction<Double> func, double a, double b) {
        double c = (b - a) * 0.5;
        double d = (a + b) * 0.5;
        double Qd1 = func.applyAsDouble(-0.774596669 * c + d);
        double Qd2 = func.applyAsDouble(d);
        double Qd3 = func.applyAsDouble(0.774596669 * c + d);
        return c * (0.5555555555555556 * (Qd1 + Qd3) + 0.8888888888888888 * Qd2);
    }

    public static double gaussLegendre5(ToDoubleFunction<Double> func, double a, double b) {
        double c = (b - a) * 0.5;
        double d = (a + b) * 0.5;
        double Qd1 = func.applyAsDouble(-0.90618 * c + d);
        double Qd2 = func.applyAsDouble(-0.538469 * c + d);
        double Qd3 = func.applyAsDouble(d);
        double Qd4 = func.applyAsDouble(0.538469 * c + d);
        double Qd5 = func.applyAsDouble(0.90618 * c + d);
        return c * (0.236927 * (Qd1 + Qd5) + 0.478629 * (Qd2 + Qd4) + 0.568889 * Qd3);
    }

    public static double gaussLegendre7(ToDoubleFunction<Double> func, double a, double b) {
        double c = (b - a) * 0.5;
        double d = (a + b) * 0.5;
        double Qd1 = func.applyAsDouble(-0.949108 * c + d);
        double Qd2 = func.applyAsDouble(-0.741531 * c + d);
        double Qd3 = func.applyAsDouble(-0.405845 * c + d);
        double Qd4 = func.applyAsDouble(d);
        double Qd5 = func.applyAsDouble(0.405845 * c + d);
        double Qd6 = func.applyAsDouble(0.741531 * c + d);
        double Qd7 = func.applyAsDouble(0.949108 * c + d);
        return c * (0.129485 * (Qd1 + Qd7) + 0.279705 * (Qd2 + Qd6) + 0.38183 * (Qd3 + Qd5) + 0.417959 * Qd4);
    }
}

