/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.awt.geom.Point2D;
import org.jhotdraw8.base.function.DoubleConsumer2;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.Points;
import org.jspecify.annotations.Nullable;

public class Lines {
    public static PointAndDerivative eval(double x0, double y0, double x1, double y1, double t) {
        return new PointAndDerivative(Lines.lerp(x0, x1, t), Lines.lerp(y0, y1, t), x1 - x0, y1 - y0);
    }

    public static boolean isCollinear(double a, double b, double m, double n, double x, double y) {
        return Lines.isCollinear(a, b, m, n, x, y, 1.0E-6);
    }

    public static boolean isCollinear(double a, double b, double m, double n, double x, double y, double tolerance) {
        return Math.abs(a * (n - y) + m * (y - b) + x * (b - n)) < tolerance;
    }

    public static double distanceFromLine(double xa, double ya, double xb, double yb, double xc, double yc) {
        return Math.sqrt(Lines.squaredDistanceFromLine(xa, ya, xb, yb, xc, yc));
    }

    public static double squaredDistanceFromLine(double xa, double ya, double xb, double yb, double xc, double yc) {
        double xdiff = xb - xa;
        double ydiff = yb - ya;
        double l2 = xdiff * xdiff + ydiff * ydiff;
        if (l2 == 0.0) {
            return Points.squaredDistance(xa, ya, xc, yc);
        }
        double rnum = (ya - yc) * (ya - yb) - (xa - xc) * (xb - xa);
        double r = rnum / l2;
        if (r < 0.0) {
            return Points.squaredDistance(xa, ya, xc, yc);
        }
        if (r > 1.0) {
            return Points.squaredDistance(xb, yb, xc, yc);
        }
        double xi = xa + r * xdiff;
        double yi = ya + r * ydiff;
        double xd = xc - xi;
        double yd = yc - yi;
        return xd * xd + yd * yd;
    }

    public static double lerp(double a, double b, double t) {
        return (b - a) * t + a;
    }

    public static double arcLength(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Points.squaredDistance(x1, y1, x2, y2));
    }

    public static double arcLength(double[] coords, int offset) {
        return Math.sqrt(Points.squaredDistance(coords[offset], coords[offset + 1], coords[offset + 2], coords[offset + 3]));
    }

    public static double arcLength(double x1, double y1, double x2, double y2, double t) {
        return t * Lines.arcLength(x1, y1, x2, y2);
    }

    public static double invArcLength(double x1, double y1, double x2, double y2, double s) {
        return s / Lines.arcLength(x1, y1, x2, y2);
    }

    public static double invArcLength(double[] p, int offset, double s) {
        return s / Lines.arcLength(p[offset], p[offset + 1], p[offset + 2], p[offset + 3]);
    }

    public static void split(double x0, double y0, double x1, double y1, double t, @Nullable DoubleConsumer2 first, @Nullable DoubleConsumer2 second) {
        double x12 = (x1 - x0) * t + x0;
        double y12 = (y1 - y0) * t + y0;
        if (first != null) {
            first.accept(x12, y12);
        }
        if (second != null) {
            second.accept(x1, y1);
        }
    }

    public static void split(double[] p, int o, double t, double @Nullable [] first, int offsetFirst, double @Nullable [] second, int offsetSecond) {
        double x0 = p[o];
        double y0 = p[o + 1];
        double x1 = p[o + 2];
        double y1 = p[o + 3];
        double x12 = (x1 - x0) * t + x0;
        double y12 = (y1 - y0) * t + y0;
        if (first != null) {
            first[offsetFirst] = x0;
            first[offsetFirst + 1] = y0;
            first[offsetFirst + 2] = x12;
            first[offsetFirst + 3] = y12;
        }
        if (second != null) {
            second[offsetSecond] = x12;
            second[offsetSecond + 1] = y12;
            second[offsetSecond + 2] = x1;
            second[offsetSecond + 3] = y1;
        }
    }

    public static void subLine(double[] p, int o, double t0, double t1, double[] first, int offsetFirst) {
        double x0 = p[o];
        double y0 = p[o + 1];
        double x1 = p[o + 2];
        double y1 = p[o + 3];
        double x11 = (x1 - x0) * t0 + x0;
        double y11 = (y1 - y0) * t0 + y0;
        double x22 = (x1 - x0) * t1 + x0;
        double y22 = (y1 - y0) * t1 + y0;
        first[offsetFirst] = x11;
        first[offsetFirst + 1] = y11;
        first[offsetFirst + 2] = x22;
        first[offsetFirst + 3] = y22;
    }

    public static Point2D.Double lerp(double x0, double y0, double x1, double y1, double t) {
        return new Point2D.Double(x0 + (x1 - x0) * t, y0 + (y1 - y0) * t);
    }

    public static Point2D.Double lerp(double[] a, int offset, double t) {
        double x0 = a[offset];
        double y0 = a[offset + 1];
        double x1 = a[offset + 2];
        double y1 = a[offset + 3];
        return new Point2D.Double(x0 + (x1 - x0) * t, y0 + (y1 - y0) * t);
    }

    public static PointAndDerivative eval(double[] a, int offset, double t) {
        double x0 = a[offset];
        double y0 = a[offset + 1];
        double x1 = a[offset + 2];
        double y1 = a[offset + 3];
        return new PointAndDerivative(x0 + (x1 - x0) * t, y0 + (y1 - y0) * t, x1 - x0, y1 - y0);
    }

    public static Point2D.Double lerp(Point2D start, Point2D end, double t) {
        return Lines.lerp(start.getX(), start.getY(), end.getX(), end.getY(), t);
    }
}

