/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.awt.geom.Path2D;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.geom.AbstractPathBuilder;
import org.jhotdraw8.geom.AwtShapes;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.PathBuilder;
import org.jspecify.annotations.Nullable;

public class MarkerPathBuilder<T>
extends AbstractPathBuilder<T> {
    private final Path2D.Double startMarker;
    private final Path2D.Double endMarker;
    private final Path2D.Double midMarker;
    private final PathBuilder<T> out;
    private boolean needsStartMarker;
    private boolean needsEndMarker;
    private double tangentX;
    private double tangentY;

    public MarkerPathBuilder(PathBuilder<T> out, Path2D.Double startMarker, Path2D.Double endMarker, Path2D.Double midMarker) {
        this.startMarker = startMarker;
        this.endMarker = endMarker;
        this.midMarker = midMarker;
        this.out = out;
    }

    @Override
    protected void doClosePath(double lastX, double lastY, double lastMoveToX, double lastMoveToY) {
    }

    @Override
    protected void doCurveTo(double lastX, double lastY, double x1, double y1, double x2, double y2, double x3, double y3) {
        this.doStartOrMidMarker(x1, y1);
        this.tangentX = x2;
        this.tangentY = y2;
        this.needsEndMarker = true;
    }

    @Override
    protected void doLineTo(double lastX, double lastY, double x, double y) {
        this.doStartOrMidMarker(x, y);
        this.tangentX = lastX;
        this.tangentY = lastY;
        this.needsEndMarker = true;
    }

    private void doStartOrMidMarker(double x, double y) {
        Path2D.Double marker;
        if (this.needsStartMarker) {
            this.needsStartMarker = false;
            marker = this.startMarker;
        } else {
            marker = this.midMarker;
        }
        if (marker == null) {
            return;
        }
        double x0 = this.getLastX();
        double y0 = this.getLastY();
        Transform tx = FXTransforms.rotate(x0 - x, y0 - y, 0.0, 0.0).createConcatenation((Transform)new Translate(x, y));
        AwtShapes.buildPathIterator(this.out, marker.getPathIterator(FXTransforms.toAwt(tx)));
    }

    private void doEndMarker() {
        if (this.needsEndMarker) {
            this.needsEndMarker = false;
            if (this.endMarker == null) {
                return;
            }
            double x = this.getLastX();
            double y = this.getLastY();
            double x0 = this.tangentX;
            double y0 = this.tangentY;
            Transform tx = FXTransforms.rotate(x0 - x, y0 - y, x, y).createConcatenation((Transform)new Translate(x, y));
            AwtShapes.buildPathIterator(this.out, this.startMarker.getPathIterator(FXTransforms.toAwt(tx)));
        }
    }

    @Override
    protected void doMoveTo(double x, double y) {
        this.needsStartMarker = true;
    }

    @Override
    protected void doQuadTo(double lastX, double lastY, double x1, double y1, double x2, double y2) {
        this.doStartOrMidMarker(x1, y1);
        this.tangentX = x1;
        this.tangentY = y1;
        this.needsEndMarker = true;
    }

    @Override
    public @Nullable T build() {
        return this.out.build();
    }
}

