/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.transform.Transform;
import org.jhotdraw8.geom.AbstractPathBuilder;
import org.jhotdraw8.geom.FXRectangles;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.PathBuilder;
import org.jspecify.annotations.Nullable;

public class NineRegionsScalingBuilder<T>
extends AbstractPathBuilder<T> {
    private final double minX;
    private final double minY;
    private final double maxX;
    private final double maxY;
    private final Transform topLeft;
    private final Transform topRight;
    private final Transform bottomRight;
    private final Transform bottomLeft;
    private final Transform top;
    private final Transform right;
    private final Transform bottom;
    private final Transform left;
    private final Transform center;
    private final PathBuilder<T> target;

    public NineRegionsScalingBuilder(PathBuilder<T> dest, Bounds srcBounds, Insets srcInsets, Bounds destBounds) {
        this.target = dest;
        double it = srcInsets.getTop();
        double ib = srcInsets.getBottom();
        double ir = srcInsets.getRight();
        double il = srcInsets.getLeft();
        BoundingBox si = FXRectangles.subtractInsets(srcBounds, srcInsets);
        this.minX = si.getMinX();
        this.maxX = si.getMaxX();
        this.minY = si.getMinY();
        this.maxY = si.getMaxY();
        double sx = srcBounds.getMinX();
        double sy = srcBounds.getMinY();
        double sw = srcBounds.getWidth();
        double sh = srcBounds.getHeight();
        double dx = destBounds.getMinX();
        double dy = destBounds.getMinY();
        double dw = destBounds.getWidth();
        double dh = destBounds.getHeight();
        this.center = FXTransforms.createReshapeTransform(sx + il, sy + it, sw - il - ir, sh - it - ib, dx + il, dy + it, dw - il - ir, dh - it - ib);
        this.top = FXTransforms.createReshapeTransform(sx + il, sy + it, sw - il - ir, it, dx + il, dy + it, dw - il - ir, it);
        this.bottom = FXTransforms.createReshapeTransform(sx + il, sy + sh - ib, sw - il - ir, ib, dx + il, dy + dh - ib, dw - il - ir, ib);
        this.left = FXTransforms.createReshapeTransform(sx, sy + it, il, sh - it - ib, dx, dy + it, il, dh - it - ib);
        this.right = FXTransforms.createReshapeTransform(sx + sw - ir, sy + it, ir, sh - it - ib, dx + dw - ir, dy + it, ir, dh - it - ib);
        this.topLeft = FXTransforms.createReshapeTransform(sx, sy, il, it, dx, dy, il, it);
        this.bottomLeft = FXTransforms.createReshapeTransform(sx, sy + sh - ib, il, ib, dx, dy + dh - ib, il, ib);
        this.topRight = FXTransforms.createReshapeTransform(sx + sw - ir, sy, ir, it, dx + dw - ir, dy, ir, it);
        this.bottomRight = FXTransforms.createReshapeTransform(sx + sw - ir, sy + sh - ib, ir, ib, dx + dw - ir, dy + dh - ib, ir, ib);
    }

    @Override
    protected void doClosePath(double lastX, double lastY, double lastMoveToX, double lastMoveToY) {
        this.target.closePath();
    }

    private Point2D transform(double x, double y) {
        Transform t = x < this.minX ? (y < this.minY ? this.topLeft : (y > this.maxY ? this.bottomLeft : this.left)) : (x > this.maxX ? (y < this.minY ? this.topRight : (y > this.maxY ? this.bottomRight : this.right)) : (y < this.minY ? this.top : (y > this.maxY ? this.bottom : this.center)));
        return t.transform(x, y);
    }

    @Override
    protected void doCurveTo(double lastX, double lastY, double x1, double y1, double x2, double y2, double x3, double y3) {
        Point2D p1 = this.transform(x1, y1);
        Point2D p2 = this.transform(x2, y2);
        Point2D p3 = this.transform(x3, y3);
        this.target.curveTo(p1.getX(), p1.getY(), p2.getX(), p2.getY(), p3.getX(), p3.getY());
    }

    @Override
    protected void doLineTo(double lastX, double lastY, double x, double y) {
        Point2D p = this.transform(x, y);
        this.target.lineTo(p.getX(), p.getY());
    }

    @Override
    protected void doMoveTo(double x, double y) {
        Point2D p = this.transform(x, y);
        this.target.moveTo(p.getX(), p.getY());
    }

    @Override
    protected void doQuadTo(double lastX, double lastY, double x1, double y1, double x2, double y2) {
        Point2D p1 = this.transform(x1, y1);
        Point2D p2 = this.transform(x2, y2);
        this.target.quadTo(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    @Override
    public @Nullable T build() {
        return this.target.build();
    }
}

