/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.util.function.BiFunction;
import org.jhotdraw8.geom.Angles;

public record PointAndDerivative(double x, double y, double dx, double dy) {
    public <T> T getPoint(BiFunction<Double, Double, T> factory) {
        return factory.apply(this.x, this.y);
    }

    public <T> T getDerivative(BiFunction<Double, Double, T> factory) {
        return factory.apply(this.dx, this.dy);
    }

    public double getAngle() {
        return Angles.atan2(this.dy, this.dx);
    }

    public PointAndDerivative reverse() {
        return new PointAndDerivative(this.x, this.y, -this.dx, -this.dy);
    }
}

