/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javafx.geometry.Point2D;
import org.jhotdraw8.collection.primitive.IntArrayList;
import org.jhotdraw8.geom.Angles;
import org.jhotdraw8.geom.PathBuilder;
import org.jhotdraw8.geom.intersect.IntersectLinePoint;
import org.jhotdraw8.geom.shape.BezierNode;
import org.jhotdraw8.geom.shape.BezierPath;

public class PolylineToCubicCurve {
    private PolylineToCubicCurve() {
    }

    public static void fitBezierPath(PathBuilder<?> builder, Point2D[] digitizedPoints, double error) {
        PolylineToCubicCurve.fitBezierPath(builder, Arrays.asList(digitizedPoints), error);
    }

    public static void fitBezierPath(PathBuilder<?> builder, List<Point2D> digitizedPoints, double error) {
        ArrayList<ArrayList<Point2D>> segments = PolylineToCubicCurve.splitAtCorners(digitizedPoints, 0.767944870877505, error * error);
        int n = segments.size();
        for (int i = 0; i < n; ++i) {
            ArrayList<Point2D> seg = segments.get(i);
            seg = PolylineToCubicCurve.removeClosePoints(seg, error * 2.0);
            seg = PolylineToCubicCurve.reduceNoise(seg, 0.8);
            segments.set(i, seg);
        }
        boolean isEmpty = false;
        for (ArrayList<Point2D> seg : segments) {
            if (!seg.isEmpty()) continue;
            isEmpty = false;
            break;
        }
        if (!isEmpty) {
            double errorSquared = error * error;
            boolean first = true;
            block7: for (ArrayList<Point2D> seg : segments) {
                switch (seg.size()) {
                    case 0: {
                        continue block7;
                    }
                    case 1: {
                        if (first) {
                            builder.moveTo(seg.getFirst().getX(), seg.getFirst().getY());
                            first = false;
                            continue block7;
                        }
                        builder.lineTo(seg.getFirst().getX(), seg.getFirst().getY());
                        continue block7;
                    }
                    case 2: {
                        if (first) {
                            builder.moveTo(seg.getFirst().getX(), seg.getFirst().getY());
                            first = false;
                        }
                        builder.lineTo(seg.get(1).getX(), seg.get(1).getY());
                        continue block7;
                    }
                }
                if (first) {
                    builder.moveTo(seg.getFirst().getX(), seg.getFirst().getY());
                    first = false;
                }
                Point2D tHat1 = PolylineToCubicCurve.computeLeftTangent(seg, 0);
                Point2D tHat2 = PolylineToCubicCurve.computeRightTangent(seg, seg.size() - 1);
                PolylineToCubicCurve.fitCubic(builder, seg, 0, seg.size() - 1, tHat1, tHat2, errorSquared);
            }
        }
    }

    public static void fitBezierPath(PathBuilder<?> builder, BezierPath digitizedPoints, double error) {
        ArrayList<Point2D> d = new ArrayList<Point2D>();
        Iterator iterator = digitizedPoints.iterator();
        while (iterator.hasNext()) {
            BezierNode n = (BezierNode)iterator.next();
            d.add(new Point2D(n.pointX(), n.pointY()));
        }
        PolylineToCubicCurve.fitBezierPath(builder, d, error);
    }

    public static ArrayList<Point2D> removeClosePoints(List<Point2D> digitizedPoints, double minDistance) {
        if (minDistance == 0.0) {
            return PolylineToCubicCurve.removeCoincidentPoints(digitizedPoints);
        }
        double squaredDistance = minDistance * minDistance;
        ArrayList<Point2D> cleaned = new ArrayList<Point2D>();
        if (!digitizedPoints.isEmpty()) {
            Point2D prev = digitizedPoints.getFirst();
            cleaned.add(prev);
            for (Point2D p : digitizedPoints) {
                if (!(PolylineToCubicCurve.v2SquaredDistanceBetween2Points(prev, p) > squaredDistance)) continue;
                cleaned.add(p);
                prev = p;
            }
            if (!prev.equals((Object)digitizedPoints.getLast())) {
                cleaned.set(cleaned.size() - 1, digitizedPoints.getLast());
            }
        }
        return cleaned;
    }

    private static ArrayList<Point2D> removeCoincidentPoints(List<Point2D> digitizedPoints) {
        ArrayList<Point2D> cleaned = new ArrayList<Point2D>();
        if (!digitizedPoints.isEmpty()) {
            Point2D prev = digitizedPoints.getFirst();
            cleaned.add(prev);
            for (Point2D p : digitizedPoints) {
                if (prev.equals((Object)p)) continue;
                cleaned.add(p);
                prev = p;
            }
        }
        return cleaned;
    }

    public static ArrayList<ArrayList<Point2D>> splitAtCorners(List<Point2D> digitizedPoints, double maxAngle, double minDistance) {
        IntArrayList cornerIndices = PolylineToCubicCurve.findCorners(digitizedPoints, maxAngle, minDistance);
        ArrayList<ArrayList<Point2D>> segments = new ArrayList<ArrayList<Point2D>>(cornerIndices.size() + 1);
        if (cornerIndices.isEmpty()) {
            segments.add(new ArrayList<Point2D>(digitizedPoints));
        } else {
            segments.add(new ArrayList<Point2D>(digitizedPoints.subList(0, cornerIndices.getAsInt(0) + 1)));
            for (int i = 1; i < cornerIndices.size(); ++i) {
                segments.add(new ArrayList<Point2D>(digitizedPoints.subList(cornerIndices.getAsInt(i - 1), cornerIndices.getAsInt(i) + 1)));
            }
            segments.add(new ArrayList<Point2D>(digitizedPoints.subList(cornerIndices.getAsInt(cornerIndices.size() - 1), digitizedPoints.size())));
        }
        return segments;
    }

    public static IntArrayList findCorners(List<Point2D> digitizedPoints, double minAngle, double minDistance) {
        IntArrayList cornerIndices = new IntArrayList();
        double squaredDistance = minDistance * minDistance;
        int previousCorner = -1;
        double previousCornerAngle = 0.0;
        int n = digitizedPoints.size();
        for (int i = 1; i < n - 1; ++i) {
            double aNext;
            double aPrev;
            double angle;
            Point2D p = digitizedPoints.get(i);
            Point2D prev = null;
            boolean intersectsPreviousCorner = false;
            for (int j = i - 1; j >= 0; --j) {
                if (j != previousCorner && !(PolylineToCubicCurve.v2SquaredDistanceBetween2Points(digitizedPoints.get(j), p) >= squaredDistance)) continue;
                prev = digitizedPoints.get(j);
                intersectsPreviousCorner = j < previousCorner;
                break;
            }
            if (prev == null) continue;
            Point2D next = null;
            for (int j = i + 1; j < n; ++j) {
                if (!(PolylineToCubicCurve.v2SquaredDistanceBetween2Points(digitizedPoints.get(j), p) >= squaredDistance)) continue;
                next = digitizedPoints.get(j);
                break;
            }
            if (next == null || !((angle = Math.abs((aPrev = Angles.atan2(prev.getY() - p.getY(), prev.getX() - p.getX())) - (aNext = Angles.atan2(next.getY() - p.getY(), next.getX() - p.getX())))) < Math.PI - minAngle) && !(angle > Math.PI + minAngle)) continue;
            if (intersectsPreviousCorner) {
                cornerIndices.setAsInt(cornerIndices.size() - 1, i);
            } else {
                cornerIndices.addAsInt(i);
            }
            previousCorner = i;
            previousCornerAngle = angle;
        }
        return cornerIndices;
    }

    public static ArrayList<Point2D> reduceNoise(List<Point2D> digitizedPoints, double weight) {
        ArrayList<Point2D> cleaned = new ArrayList<Point2D>();
        if (!digitizedPoints.isEmpty()) {
            Point2D prev = digitizedPoints.getFirst();
            cleaned.add(prev);
            double pnWeight = (1.0 - weight) / 2.0;
            int n = digitizedPoints.size() - 1;
            for (int i = 1; i < n; ++i) {
                Point2D cur = digitizedPoints.get(i);
                Point2D next = digitizedPoints.get(i + 1);
                cleaned.add(new Point2D(cur.getX() * weight + pnWeight * prev.getX() + pnWeight * next.getX(), cur.getY() * weight + pnWeight * prev.getY() + pnWeight * next.getY()));
                prev = cur;
            }
            if (digitizedPoints.size() > 1) {
                cleaned.add(digitizedPoints.getLast());
            }
        }
        return cleaned;
    }

    private static void fitCubic(PathBuilder<?> builder, ArrayList<Point2D> d, int first, int last, Point2D tHat1, Point2D tHat2, double errorSquared) {
        int[] splitPoint = new int[1];
        int maxIterations = 4;
        double iterationError = errorSquared * errorSquared;
        int nPts = last - first + 1;
        if (nPts == 2) {
            double dist = PolylineToCubicCurve.v2DistanceBetween2Points(d.get(last), d.get(first)) / 3.0;
            Point2D bezCurve0 = d.get(first);
            Point2D bezCurve3 = d.get(last);
            tHat1 = PolylineToCubicCurve.v2Scale(tHat1, dist);
            Point2D bezCurve1 = PolylineToCubicCurve.v2Add(bezCurve0, tHat1);
            tHat2 = PolylineToCubicCurve.v2Scale(tHat2, dist);
            Point2D bezCurve2 = PolylineToCubicCurve.v2Add(bezCurve3, tHat2);
            builder.curveTo(bezCurve1.getX(), bezCurve1.getY(), bezCurve2.getX(), bezCurve2.getY(), bezCurve3.getX(), bezCurve3.getY());
            return;
        }
        double[] u = PolylineToCubicCurve.chordLengthParameterize(d, first, last);
        Point2D[] bezCurve = PolylineToCubicCurve.generateBezier(d, first, last, u, tHat1, tHat2);
        double maxError = PolylineToCubicCurve.computeMaxError(d, first, last, bezCurve, u, splitPoint);
        if (maxError < errorSquared) {
            PolylineToCubicCurve.addCurveTo(builder, bezCurve, errorSquared, first == 0 && last == d.size() - 1);
            return;
        }
        if (maxError < iterationError) {
            for (int i = 0; i < maxIterations; ++i) {
                double[] uPrime = PolylineToCubicCurve.reparameterize(d, first, last, u, bezCurve);
                maxError = PolylineToCubicCurve.computeMaxError(d, first, last, bezCurve = PolylineToCubicCurve.generateBezier(d, first, last, uPrime, tHat1, tHat2), uPrime, splitPoint);
                if (maxError < errorSquared) {
                    PolylineToCubicCurve.addCurveTo(builder, bezCurve, errorSquared, first == 0 && last == d.size() - 1);
                    return;
                }
                u = uPrime;
            }
        }
        Point2D tHatCenter = PolylineToCubicCurve.computeCenterTangent(d, splitPoint[0]);
        if (first < splitPoint[0]) {
            PolylineToCubicCurve.fitCubic(builder, d, first, splitPoint[0], tHat1, tHatCenter, errorSquared);
        } else {
            builder.lineTo(d.get(splitPoint[0]).getX(), d.get(splitPoint[0]).getY());
        }
        tHatCenter = PolylineToCubicCurve.v2Negate(tHatCenter);
        if (splitPoint[0] < last) {
            PolylineToCubicCurve.fitCubic(builder, d, splitPoint[0], last, tHatCenter, tHat2, errorSquared);
        } else {
            builder.lineTo(d.get(last).getX(), d.get(last).getY());
        }
    }

    private static void addCurveTo(PathBuilder<?> builder, Point2D[] bezCurve, double errorSquared, boolean connectsCorners) {
        Point2D.Double lastNode = builder.getLastPoint();
        double error = Math.sqrt(errorSquared);
        if (connectsCorners && IntersectLinePoint.lineContainsPoint(lastNode.getX(), lastNode.getY(), bezCurve[3].getX(), bezCurve[3].getY(), bezCurve[1].getX(), bezCurve[1].getY(), error) && IntersectLinePoint.lineContainsPoint(lastNode.getX(), lastNode.getY(), bezCurve[3].getX(), bezCurve[3].getY(), bezCurve[2].getX(), bezCurve[2].getY(), error)) {
            builder.lineTo(bezCurve[3].getX(), bezCurve[3].getY());
        } else {
            builder.curveTo(bezCurve[1].getX(), bezCurve[1].getY(), bezCurve[2].getX(), bezCurve[2].getY(), bezCurve[3].getX(), bezCurve[3].getY());
        }
    }

    private static Point2D computeLeftTangent(ArrayList<Point2D> d, int end) {
        Point2D tHat1 = PolylineToCubicCurve.v2SubII(d.get(end + 1), d.get(end));
        tHat1 = PolylineToCubicCurve.v2Normalize(tHat1);
        return tHat1;
    }

    private static Point2D computeRightTangent(ArrayList<Point2D> d, int end) {
        Point2D tHat2 = PolylineToCubicCurve.v2SubII(d.get(end - 1), d.get(end));
        tHat2 = PolylineToCubicCurve.v2Normalize(tHat2);
        return tHat2;
    }

    private static Point2D computeCenterTangent(ArrayList<Point2D> d, int center) {
        Point2D V1 = PolylineToCubicCurve.v2SubII(d.get(center - 1), d.get(center));
        Point2D V2 = PolylineToCubicCurve.v2SubII(d.get(center), d.get(center + 1));
        Point2D tHatCenter = new Point2D((V1.getX() + V2.getX()) / 2.0, (V1.getY() + V2.getY()) / 2.0);
        tHatCenter = PolylineToCubicCurve.v2Normalize(tHatCenter);
        return tHatCenter;
    }

    private static double[] chordLengthParameterize(ArrayList<Point2D> d, int first, int last) {
        int i;
        double[] u = new double[last - first + 1];
        u[0] = 0.0;
        for (i = first + 1; i <= last; ++i) {
            u[i - first] = u[i - first - 1] + PolylineToCubicCurve.v2DistanceBetween2Points(d.get(i), d.get(i - 1));
        }
        for (i = first + 1; i <= last; ++i) {
            u[i - first] = u[i - first] / u[last - first];
        }
        return u;
    }

    private static double[] reparameterize(ArrayList<Point2D> d, int first, int last, double[] u, Point2D[] bezCurve) {
        int nPts = last - first + 1;
        double[] uPrime = new double[nPts];
        for (int i = first; i <= last; ++i) {
            uPrime[i - first] = PolylineToCubicCurve.newtonRaphsonRootFind(bezCurve, d.get(i), u[i - first]);
        }
        return uPrime;
    }

    private static double newtonRaphsonRootFind(Point2D[] Q, Point2D P, double u) {
        int i;
        Point2D[] Q1 = new Point2D[3];
        Point2D[] Q2 = new Point2D[2];
        Point2D Q_u = PolylineToCubicCurve.bezierII(3, Q, u);
        for (i = 0; i <= 2; ++i) {
            Q1[i] = new Point2D((Q[i + 1].getX() - Q[i].getX()) * 3.0, (Q[i + 1].getY() - Q[i].getY()) * 3.0);
        }
        for (i = 0; i <= 1; ++i) {
            Q2[i] = new Point2D((Q1[i + 1].getX() - Q1[i].getX()) * 2.0, (Q1[i + 1].getY() - Q1[i].getY()) * 2.0);
        }
        Point2D Q1_u = PolylineToCubicCurve.bezierII(2, Q1, u);
        Point2D Q2_u = PolylineToCubicCurve.bezierII(1, Q2, u);
        double numerator = (Q_u.getX() - P.getX()) * Q1_u.getX() + (Q_u.getY() - P.getY()) * Q1_u.getY();
        double denominator = Q1_u.getX() * Q1_u.getX() + Q1_u.getY() * Q1_u.getY() + (Q_u.getX() - P.getX()) * Q2_u.getX() + (Q_u.getY() - P.getY()) * Q2_u.getY();
        double uPrime = u - numerator / denominator;
        return uPrime;
    }

    private static double computeMaxError(ArrayList<Point2D> d, int first, int last, Point2D[] bezCurve, double[] u, int[] splitPoint) {
        splitPoint[0] = (last - first + 1) / 2;
        double maxDist = 0.0;
        for (int i = first + 1; i < last; ++i) {
            Point2D P = PolylineToCubicCurve.bezierII(3, bezCurve, u[i - first]);
            Point2D v = PolylineToCubicCurve.v2SubII(P, d.get(i));
            double dist = PolylineToCubicCurve.v2SquaredLength(v);
            if (!(dist >= maxDist)) continue;
            maxDist = dist;
            splitPoint[0] = i;
        }
        return maxDist;
    }

    private static Point2D[] generateBezier(ArrayList<Point2D> d, int first, int last, double[] uPrime, Point2D tHat1, Point2D tHat2) {
        Point2D[] bezCurve = new Point2D[4];
        for (int i = 0; i < bezCurve.length; ++i) {
        }
        double dist = PolylineToCubicCurve.v2DistanceBetween2Points(d.get(last), d.get(first)) / 3.0;
        bezCurve[0] = d.get(first);
        bezCurve[3] = d.get(last);
        bezCurve[1] = PolylineToCubicCurve.v2Add(bezCurve[0], PolylineToCubicCurve.v2Scale(tHat1, dist));
        bezCurve[2] = PolylineToCubicCurve.v2Add(bezCurve[3], PolylineToCubicCurve.v2Scale(tHat2, dist));
        return bezCurve;
    }

    private static Point2D bezierII(int degree, Point2D[] V, double t) {
        int i;
        Point2D[] vTemp = new Point2D[degree + 1];
        for (i = 0; i <= degree; ++i) {
            vTemp[i] = V[i];
        }
        for (i = 1; i <= degree; ++i) {
            for (int j = 0; j <= degree - i; ++j) {
                vTemp[j] = new Point2D((1.0 - t) * vTemp[j].getX() + t * vTemp[j + 1].getX(), (1.0 - t) * vTemp[j].getY() + t * vTemp[j + 1].getY());
            }
        }
        Point2D q = vTemp[0];
        return q;
    }

    private static double v2DistanceBetween2Points(Point2D a, Point2D b) {
        return Math.sqrt(PolylineToCubicCurve.v2SquaredDistanceBetween2Points(a, b));
    }

    private static double v2SquaredDistanceBetween2Points(Point2D a, Point2D b) {
        double dx = a.getX() - b.getX();
        double dy = a.getY() - b.getY();
        return dx * dx + dy * dy;
    }

    private static Point2D v2Scale(Point2D v, double newlen) {
        double len = PolylineToCubicCurve.v2Length(v);
        double x = v.getX();
        double y = v.getY();
        if (len != 0.0) {
            x *= newlen / len;
            y *= newlen / len;
        }
        return new Point2D(x, y);
    }

    private static double v2Length(Point2D a) {
        return Math.sqrt(PolylineToCubicCurve.v2SquaredLength(a));
    }

    private static double v2SquaredLength(Point2D a) {
        return a.getX() * a.getX() + a.getY() * a.getY();
    }

    private static Point2D v2Add(Point2D a, Point2D b) {
        return new Point2D(a.getX() + b.getX(), a.getY() + b.getY());
    }

    private static Point2D v2Negate(Point2D v) {
        return new Point2D(-v.getX(), -v.getY());
    }

    private static Point2D v2Normalize(Point2D v) {
        double len = PolylineToCubicCurve.v2Length(v);
        if (len != 0.0) {
            return new Point2D(v.getX() / len, v.getY() / len);
        }
        return v;
    }

    private static Point2D v2SubII(Point2D a, Point2D b) {
        Point2D c = new Point2D(a.getX() - b.getX(), a.getY() - b.getY());
        return c;
    }
}

