/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.util.function.ToDoubleFunction;
import org.jhotdraw8.base.function.Function3;
import org.jhotdraw8.collection.pair.OrderedPair;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;

public class Solvers {
    private Solvers() {
    }

    public static OrderedPair<ToDoubleFunction<Double>, Double> polynomialApprox3(Function3<ToDoubleFunction<Double>, Double, Double, Double> quadratureFunction, ToDoubleFunction<Double> fp, double xmin, double xmax) {
        double y1 = (Double)quadratureFunction.apply(fp, (Object)xmin, (Object)(xmin + (xmax - xmin) / 3.0));
        double y2 = (Double)quadratureFunction.apply(fp, (Object)xmin, (Object)(xmin + (xmax - xmin) / 1.5));
        double y3 = (Double)quadratureFunction.apply(fp, (Object)xmin, (Object)xmax);
        double a = 13.5 * y1 - 13.5 * y2 + 4.5 * y3;
        double b = -22.5 * y1 + 18.0 * y2 - 4.5 * y3;
        double c = 9.0 * y1 - 4.5 * y2 + y3;
        return new SimpleOrderedPair(x -> {
            x = (x - xmin) / (xmax - xmin);
            return a * x * x * x + b * x * x + c * x;
        }, (Object)Math.abs(y3));
    }

    public static OrderedPair<ToDoubleFunction<Double>, Double> invPolynomialApprox3(Function3<ToDoubleFunction<Double>, Double, Double, Double> quadratureFunction, ToDoubleFunction<Double> fp, double xmin, double xmax) {
        ToDoubleFunction<Double> f = t -> Math.abs((Double)quadratureFunction.apply((Object)fp, (Object)xmin, (Object)(xmin + (xmax - xmin) * t)));
        double f3 = f.applyAsDouble(1.0);
        double t1 = Solvers.bisectionMethod(f, 0.3333333333333333 * f3, 0.0, 1.0, 1.0E-7);
        double t2 = Solvers.bisectionMethod(f, 0.6666666666666666 * f3, 0.0, 1.0, 1.0E-7);
        double t3 = 1.0;
        double a = (27.0 * t1 - 27.0 * t2 + 9.0 * t3) / (2.0 * f3 * f3 * f3);
        double b = (-45.0 * t1 + 36.0 * t2 - 9.0 * t3) / (2.0 * f3 * f3);
        double c = (18.0 * t1 - 9.0 * t2 + 2.0 * t3) / (2.0 * f3);
        return new SimpleOrderedPair(g -> {
            double t = a * g * g * g + b * g * g + c * g;
            return xmin + (xmax - xmin) * t;
        }, (Object)f3);
    }

    public static double bisectionMethod(ToDoubleFunction<Double> f, double y, double xmin, double xmax, double tolerance) {
        int maxIterations = 100;
        int n = 0;
        double toleranceX = Math.abs(xmax - xmin) * tolerance;
        double toleranceY = tolerance;
        while (true) {
            double x = (xmin + xmax) * 0.5;
            if (n >= 100) {
                return x;
            }
            double dy = f.applyAsDouble(x) - y;
            if (Math.abs(dy) < toleranceY || Math.abs(xmax - xmin) * 0.5 < toleranceX) {
                return x;
            }
            if (dy > 0.0) {
                xmax = x;
            } else {
                xmin = x;
            }
            ++n;
        }
    }

    public static double hybridNewtonBisectionMethod(Function3<ToDoubleFunction<Double>, Double, Double, Double> quadratureFunction, ToDoubleFunction<Double> f, double y, double xmin, double xmax, double x0, double epsilon) {
        return Solvers.hybridNewtonBisectionMethod((Double x) -> (Double)quadratureFunction.apply((Object)f, (Object)0.0, x), f, y, xmin, xmax, x0, epsilon);
    }

    public static double hybridNewtonBisectionMethod(ToDoubleFunction<Double> f, ToDoubleFunction<Double> df, double y, double xmin, double xmax, double x0, double epsilon) {
        double dy;
        int maxIterations = 100;
        double x = x0;
        double lowerBound = xmin;
        double upperBound = xmax;
        for (int i = 0; i < 100 && !(Math.abs(dy = f.applyAsDouble(x) - y) < epsilon); ++i) {
            double derivative = df.applyAsDouble(x);
            double candidateX = x - dy / derivative;
            if (dy > 0.0) {
                upperBound = x;
                if (candidateX <= xmin) {
                    x = (upperBound + lowerBound) / 2.0;
                    continue;
                }
                x = candidateX;
                continue;
            }
            lowerBound = x;
            x = candidateX >= xmax ? (upperBound + lowerBound) / 2.0 : candidateX;
        }
        return x;
    }

    public static SimpleOrderedPair<ToDoubleFunction<Double>, Double> invPolynomialChebyshevApprox(int N, Function3<ToDoubleFunction<Double>, Double, Double, Double> quadratureFunction, ToDoubleFunction<Double> fp, double tmin, double tmax) {
        ToDoubleFunction<Double> fLength = t -> Math.abs((Double)quadratureFunction.apply((Object)fp, (Object)tmin, t));
        double totalLength = fLength.applyAsDouble(tmax);
        ToDoubleFunction<Double> t2 = L -> Solvers.bisectionMethod(fLength, L, tmin, tmax, 1.0E-7);
        return new SimpleOrderedPair(Solvers.polynomialChebyshevApprox(N, t2, 0.0, totalLength, tmin, tmax), (Object)totalLength);
    }

    public static ToDoubleFunction<Double> polynomialChebyshevApprox(int N, ToDoubleFunction<Double> f, double xmin, double xmax, double ymin, double ymax) {
        double[] fs = new double[N];
        for (int k = 0; k < N; ++k) {
            double u = Math.cos(Math.PI * ((double)(k + 1) - 0.5) / (double)N);
            fs[k] = f.applyAsDouble(xmin + (xmax - xmin) * (u + 1.0) / 2.0);
        }
        double[] c = new double[N];
        for (int j = 0; j < N; ++j) {
            double a = 0.0;
            for (int k = 0; k < N; ++k) {
                a += fs[k] * Math.cos((double)j * Math.PI * ((double)(k + 1) - 0.5) / (double)N);
            }
            c[j] = 2.0 / (double)N * a;
        }
        return x -> {
            x = Math.min(xmax, Math.max(xmin, x));
            double u = (x - xmin) / (xmax - xmin) * 2.0 - 1.0;
            double a = 0.0;
            for (int j = 0; j < N; ++j) {
                a += c[j] * Math.cos((double)j * Math.acos(u));
            }
            double y = -0.5 * c[0] + a;
            if (!Double.isNaN(ymin) && !Double.isNaN(ymax)) {
                y = Math.min(ymax, Math.max(ymin, y));
            }
            return y;
        };
    }
}

