/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.text.Text;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.jhotdraw8.geom.FXShapes;

public class TransformFlattener {
    private boolean canFlattenTranslate(Node node) {
        if (node.getRotate() != 0.0 || node.getScaleX() != 1.0 || node.getScaleY() != 1.0) {
            return false;
        }
        for (Transform t : node.getTransforms()) {
            if (t instanceof Translate) continue;
            return false;
        }
        return true;
    }

    private Translate flattenTranslateTransforms(Node node) {
        Translate translate = new Translate(node.getTranslateX(), node.getTranslateY());
        for (Transform t : node.getTransforms()) {
            if (t instanceof Translate) {
                Translate tt = (Translate)t;
                translate = (Translate)translate.createConcatenation((Transform)tt);
                continue;
            }
            throw new IllegalArgumentException("node has non-translate transforms.");
        }
        node.setTranslateX(0.0);
        node.setTranslateY(0.0);
        node.getTransforms().clear();
        Node node2 = node.getClip();
        if (node2 instanceof Shape) {
            Shape s = (Shape)node2;
            node.setClip((Node)FXShapes.awtShapeToFXShape(FXShapes.fxShapeToAwtShape(s).getPathIterator(FXShapes.fxTransformToAwtTransform((Transform)translate))));
        }
        return translate;
    }

    public void flattenTranslates(Node node) {
        if (node instanceof Parent) {
            this.flattenTranslatesInParent((Parent)node);
        } else if (node instanceof Shape) {
            this.flattenTranslatesInShape((Shape)node);
        }
    }

    private void flattenTranslatesInParent(Parent parent) {
        if (!this.canFlattenTranslate((Node)parent)) {
            return;
        }
        Translate translate = this.flattenTranslateTransforms((Node)parent);
        if (!translate.isIdentity()) {
            for (Node child : parent.getChildrenUnmodifiable()) {
                child.getTransforms().addFirst((Object)translate);
            }
        }
        for (Node child : parent.getChildrenUnmodifiable()) {
            this.flattenTranslates(child);
        }
    }

    private void flattenTranslatesInPath(Path path) {
        if (!this.canFlattenTranslate((Node)path)) {
            return;
        }
        Translate t = this.flattenTranslateTransforms((Node)path);
        double tx = t.getTx();
        double ty = t.getTy();
        boolean first = true;
        ArrayList<Object> list = new ArrayList<Object>(path.getElements().size());
        for (PathElement element : path.getElements()) {
            if (element.isAbsolute() || first) {
                PathElement pathElement;
                Objects.requireNonNull(element);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClosePath.class, MoveTo.class, LineTo.class, QuadCurveTo.class, CubicCurveTo.class, ArcTo.class}, (Object)pathElement, n)) {
                    case 0: {
                        ClosePath closePath = (ClosePath)pathElement;
                        list.add(element);
                        break;
                    }
                    case 1: {
                        MoveTo e = (MoveTo)pathElement;
                        list.add(new MoveTo(e.getX() + tx, e.getY() + ty));
                        break;
                    }
                    case 2: {
                        LineTo e = (LineTo)pathElement;
                        list.add(new LineTo(e.getX() + tx, e.getY() + ty));
                        break;
                    }
                    case 3: {
                        QuadCurveTo e = (QuadCurveTo)pathElement;
                        list.add(new QuadCurveTo(e.getControlX() + tx, e.getControlY() + ty, e.getX() + tx, e.getY() + ty));
                        break;
                    }
                    case 4: {
                        CubicCurveTo e = (CubicCurveTo)pathElement;
                        list.add(new CubicCurveTo(e.getControlX1() + tx, e.getControlY1() + ty, e.getControlX2() + tx, e.getControlY2() + ty, e.getX() + tx, e.getY() + ty));
                        break;
                    }
                    case 5: {
                        ArcTo e = (ArcTo)pathElement;
                        list.add(new ArcTo(e.getRadiusX(), e.getRadiusY(), e.getXAxisRotation(), e.getX() + tx, e.getY() + ty, e.isLargeArcFlag(), e.isSweepFlag()));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("unknown element type: " + String.valueOf(element));
                    }
                }
            } else {
                list.add(element);
            }
            first = false;
        }
        path.getElements().setAll(list);
    }

    private void flattenTranslatesInPolygon(Polygon path) {
        if (!this.canFlattenTranslate((Node)path)) {
            return;
        }
        Translate t = this.flattenTranslateTransforms((Node)path);
        ObservableList points = path.getPoints();
        int n = points.size();
        for (int i = 0; i < n; i += 2) {
            double x = (Double)points.get(i);
            double y = (Double)points.get(i + 1);
            Point2D p = t.transform(x, y);
            points.set(i, (Object)p.getX());
            points.set(i + 1, (Object)p.getY());
        }
    }

    private void flattenTranslatesInPolyline(Polyline path) {
        if (!this.canFlattenTranslate((Node)path)) {
            return;
        }
        Translate t = this.flattenTranslateTransforms((Node)path);
        ObservableList points = path.getPoints();
        int n = points.size();
        for (int i = 0; i < n; i += 2) {
            double x = (Double)points.get(i);
            double y = (Double)points.get(i + 1);
            Point2D p = t.transform(x, y);
            points.set(i, (Object)p.getX());
            points.set(i + 1, (Object)p.getY());
        }
    }

    private void flattenTranslatesInLine(Line shape) {
        if (!this.canFlattenTranslate((Node)shape)) {
            return;
        }
        Translate t = this.flattenTranslateTransforms((Node)shape);
        Point2D p = t.transform(shape.getStartX(), shape.getStartY());
        shape.setStartX(p.getX());
        shape.setStartY(p.getY());
        Point2D p2 = t.transform(shape.getEndX(), shape.getEndY());
        shape.setEndX(p2.getX());
        shape.setEndY(p2.getY());
    }

    private void flattenTranslatesInEllipse(Ellipse shape) {
        if (!this.canFlattenTranslate((Node)shape)) {
            return;
        }
        Translate t = this.flattenTranslateTransforms((Node)shape);
        Point2D p = t.transform(shape.getCenterX(), shape.getCenterY());
        shape.setCenterX(p.getX());
        shape.setCenterY(p.getY());
    }

    private void flattenTranslatesInRectangle(Rectangle shape) {
        if (!this.canFlattenTranslate((Node)shape)) {
            return;
        }
        Translate t = this.flattenTranslateTransforms((Node)shape);
        Point2D p = t.transform(shape.getX(), shape.getY());
        shape.setX(p.getX());
        shape.setY(p.getY());
    }

    private void flattenTranslatesInText(Text shape) {
        if (!this.canFlattenTranslate((Node)shape)) {
            return;
        }
        Translate t = this.flattenTranslateTransforms((Node)shape);
        Point2D p = t.transform(shape.getX(), shape.getY());
        shape.setX(p.getX());
        shape.setY(p.getY());
    }

    private void flattenTranslatesInShape(Shape shape) {
        if (shape instanceof Path) {
            this.flattenTranslatesInPath((Path)shape);
        } else if (shape instanceof Polygon) {
            this.flattenTranslatesInPolygon((Polygon)shape);
        } else if (shape instanceof Polyline) {
            this.flattenTranslatesInPolyline((Polyline)shape);
        } else if (shape instanceof Line) {
            this.flattenTranslatesInLine((Line)shape);
        } else if (shape instanceof Ellipse) {
            this.flattenTranslatesInEllipse((Ellipse)shape);
        } else if (shape instanceof Rectangle) {
            this.flattenTranslatesInRectangle((Rectangle)shape);
        } else if (shape instanceof Text) {
            this.flattenTranslatesInText((Text)shape);
        }
    }
}

