/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.biarc;

import java.awt.geom.Point2D;
import org.jhotdraw8.geom.Angles;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.Points2D;
import org.jhotdraw8.geom.biarc.Arc;
import org.jhotdraw8.geom.biarc.Line;

public record BiArc(Arc a1, Arc a2) {
    public static BiArc create(Point2D.Double p1, Point2D.Double t1, Point2D.Double p2, Point2D.Double t2, Point2D.Double tp) {
        double sum = 0.0;
        sum += (tp.getX() - p1.getX()) * (tp.getY() + p1.getY());
        sum += (p2.getX() - tp.getX()) * (p2.getY() + tp.getY());
        boolean cw = (sum += (p1.getX() - p2.getX()) * (p1.getY() + p2.getY())) < 0.0;
        Line tl1 = Line.createPerpendicularAt(p1, Points2D.add(p1, t1));
        Line tl2 = Line.createPerpendicularAt(p2, Points2D.add(p2, t2));
        Point2D.Double P1T2 = Points2D.multiply(Points2D.add(p1, tp), 0.5);
        Line pbP1T = Line.createPerpendicularAt(P1T2, tp);
        Point2D.Double P2T2 = Points2D.multiply(Points2D.add(p2, tp), 0.5);
        Line pbP2T = Line.createPerpendicularAt(P2T2, tp);
        Point2D.Double C1 = tl1.Intersection(pbP1T);
        Point2D.Double C2 = tl2.Intersection(pbP2T);
        double r1 = Points2D.magnitude(Points2D.subtract(C1, p1));
        double r2 = Points2D.magnitude(Points2D.subtract(C2, p2));
        Point2D.Double startVector1 = Points2D.subtract(p1, C1);
        Point2D.Double endVector1 = Points2D.subtract(tp, C1);
        double startAngle1 = Points.almostZero(startVector1) ? 0.0 : Angles.atan2(startVector1.getY(), startVector1.getX());
        double sweepAngle1 = Points.almostZero(endVector1) ? 0.0 : Angles.atan2(endVector1.getY(), endVector1.getX()) - startAngle1;
        Point2D.Double startVector2 = Points2D.subtract(tp, C2);
        Point2D.Double endVector2 = Points2D.subtract(p2, C2);
        double startAngle2 = Angles.atan2(startVector2.getY(), startVector2.getX());
        double sweepAngle2 = Angles.atan2(endVector2.getY(), endVector2.getX()) - startAngle2;
        if (cw && sweepAngle1 < 0.0) {
            sweepAngle1 = Math.PI * 2 + sweepAngle1;
        }
        if (!cw && sweepAngle1 > 0.0) {
            sweepAngle1 -= Math.PI * 2;
        }
        if (cw && sweepAngle2 < 0.0) {
            sweepAngle2 = Math.PI * 2 + sweepAngle2;
        }
        if (!cw && sweepAngle2 > 0.0) {
            sweepAngle2 -= Math.PI * 2;
        }
        return new BiArc(new Arc(C1, r1, startAngle1, sweepAngle1, p1, tp), new Arc(C2, r2, startAngle2, sweepAngle2, tp, p2));
    }

    public Point2D.Double pointAt(double t) {
        double s = this.a1.length() / (this.a1.length() + this.a2.length());
        if (t <= s) {
            return this.a1.pointAt(t / s);
        }
        return this.a2.pointAt((t - s) / (1.0 - s));
    }

    public double length() {
        return this.a1.length() + this.a2.length();
    }
}

