/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.biarc;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.collection.primitive.DoubleArrayList;
import org.jhotdraw8.geom.CubicCurveCharacteristics;
import org.jhotdraw8.geom.CubicCurves;
import org.jhotdraw8.geom.Points2D;
import org.jhotdraw8.geom.biarc.BiArc;
import org.jhotdraw8.geom.intersect.IntersectRayRay;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class CubicCurveToBiArc {
    private CubicCurveToBiArc() {
    }

    public static List<BiArc> approxCubicBezier(CubicCurve2D.Double bezier, int nrPointsToCheck, double tolerance) {
        ArrayList<BiArc> biarcs = new ArrayList<BiArc>();
        int maxCurves = 1024;
        ArrayDeque<CubicCurve2D.Double> stack = new ArrayDeque<CubicCurve2D.Double>();
        CubicCurveToBiArc.splitAtInflectionPoints(bezier, stack);
        while (!stack.isEmpty()) {
            bezier = stack.pop();
            Point2D C1 = bezier.getP1().equals(bezier.getCtrlP1()) ? bezier.getCtrlP2() : bezier.getCtrlP1();
            Point2D C2 = bezier.getP2().equals(bezier.getCtrlP2()) ? bezier.getCtrlP1() : bezier.getCtrlP2();
            Point2D a0 = bezier.getP1();
            Point2D b0 = bezier.getP2();
            IntersectionResultEx intersectionResultEx = IntersectRayRay.intersectRayRayEx(a0, Points2D.subtract(C1, a0), b0, Points2D.subtract(C2, b0));
            if (intersectionResultEx.getStatus() == IntersectionStatus.NO_INTERSECTION_PARALLEL && stack.size() < 4096) {
                CubicCurve2D.Double first = new CubicCurve2D.Double();
                CubicCurve2D.Double second = new CubicCurve2D.Double();
                bezier.subdivide(first, second);
                stack.push(second);
                stack.push(first);
                continue;
            }
            if (intersectionResultEx.getStatus() != IntersectionStatus.INTERSECTION) continue;
            IntersectionPointEx V = (IntersectionPointEx)intersectionResultEx.intersections().getFirst();
            Point2D.Double P1 = new Point2D.Double(bezier.getX1(), bezier.getY1());
            Point2D.Double P2 = new Point2D.Double(bezier.getX2(), bezier.getY2());
            Point2D.Double G = CubicCurveToBiArc.computeIncenterPoint(V, P1, P2);
            BiArc biarc = BiArc.create(P1, Points2D.subtract(P1, C1), P2, Points2D.subtract(P2, C2), G);
            double tMaxError = CubicCurveToBiArc.getParamWithMaxErrorOverTolerance(bezier, nrPointsToCheck, tolerance, biarc);
            if (tMaxError != -1.0 && stack.size() + biarcs.size() < maxCurves) {
                SimpleOrderedPair<CubicCurve2D.Double, CubicCurve2D.Double> bs = CubicCurves.split(bezier, tMaxError);
                stack.push((CubicCurve2D.Double)bs.second());
                stack.push((CubicCurve2D.Double)bs.first());
                continue;
            }
            biarcs.add(biarc);
        }
        return biarcs;
    }

    public static Point2D.Double computeIncenterPoint(Point2D.Double a, Point2D.Double b, Point2D.Double c) {
        double dac = c.distance(a);
        double dab = b.distance(a);
        double dbc = b.distance(c);
        return Points2D.divide(Points2D.sum(Points2D.multiply(b, dac), Points2D.multiply(c, dab), Points2D.multiply(a, dbc)), dac + dab + dbc);
    }

    private static double getParamWithMaxErrorOverTolerance(CubicCurve2D.Double bezier, int nrPointsToCheck, double tolerance, BiArc biarc) {
        double maxDistance = tolerance;
        double maxDistanceAt = -1.0;
        double parameterStep = 1.0 / (double)nrPointsToCheck;
        for (int i = 0; i <= nrPointsToCheck; ++i) {
            Point2D.Double u2;
            double t = parameterStep * (double)i;
            Point2D.Double u1 = biarc.pointAt(t);
            double distance = u1.distance(u2 = CubicCurves.eval(CubicCurves.toArray(bezier), 0, t).getPoint(Point2D.Double::new));
            if (!(distance > maxDistance)) continue;
            maxDistance = distance;
            maxDistanceAt = t;
        }
        return maxDistanceAt;
    }

    public static void splitAtInflectionPoints(CubicCurve2D.Double bezier, ArrayDeque<CubicCurve2D.Double> stack) {
        if (bezier.getP1().equals(bezier.getCtrlP1()) || bezier.getP2().equals(bezier.getCtrlP2())) {
            stack.push(bezier);
        } else {
            DoubleArrayList inflex = CubicCurveCharacteristics.inflectionPoints(bezier);
            if (inflex.size() == 1) {
                SimpleOrderedPair<CubicCurve2D.Double, CubicCurve2D.Double> splitted = CubicCurves.split(bezier, inflex.getFirst());
                stack.push((CubicCurve2D.Double)splitted.second());
                stack.push((CubicCurve2D.Double)splitted.first());
            } else if (inflex.size() == 2) {
                double t2;
                double t1 = inflex.get(0);
                if (t1 > (t2 = inflex.get(1).doubleValue())) {
                    double tmp = t1;
                    t1 = t2;
                    t2 = tmp;
                }
                SimpleOrderedPair<CubicCurve2D.Double, CubicCurve2D.Double> splitted1 = CubicCurves.split(bezier, t1);
                t2 = (1.0 - t1) * t2;
                SimpleOrderedPair<CubicCurve2D.Double, CubicCurve2D.Double> splitted2 = CubicCurves.split((CubicCurve2D.Double)splitted1.second(), t2);
                stack.push((CubicCurve2D.Double)splitted2.second());
                stack.push((CubicCurve2D.Double)splitted2.first());
                stack.push((CubicCurve2D.Double)splitted1.first());
            } else {
                stack.push(bezier);
            }
        }
    }
}

