/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.contour;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import org.jhotdraw8.base.function.Consumer3;
import org.jhotdraw8.base.function.Function5;
import org.jhotdraw8.collection.pair.OrderedPair;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.collection.primitive.IntArrayDeque;
import org.jhotdraw8.collection.primitive.IntArrayList;
import org.jhotdraw8.geom.AABB;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.Points2D;
import org.jhotdraw8.geom.contour.BulgeConversionFunctions;
import org.jhotdraw8.geom.contour.ContourIntersections;
import org.jhotdraw8.geom.contour.IntrPlineSegsResult;
import org.jhotdraw8.geom.contour.OpenPolylineSlice;
import org.jhotdraw8.geom.contour.PlineCoincidentIntersect;
import org.jhotdraw8.geom.contour.PlineIntersect;
import org.jhotdraw8.geom.contour.PlineIntersectsResult;
import org.jhotdraw8.geom.contour.PlineOffsetSegment;
import org.jhotdraw8.geom.contour.PlinePath;
import org.jhotdraw8.geom.contour.PlineSegIntrType;
import org.jhotdraw8.geom.contour.PlineVertex;
import org.jhotdraw8.geom.contour.SplitResult;
import org.jhotdraw8.geom.contour.StaticSpatialIndex;
import org.jhotdraw8.geom.contour.Utils;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class ContourBuilder {
    static boolean pointValidForOffset(PlinePath pline, double offset, StaticSpatialIndex spatialIndex, Point2D.Double point, IntArrayDeque queryStack) {
        return ContourBuilder.pointValidForOffset(pline, offset, spatialIndex, point, queryStack, 1.0E-4);
    }

    static boolean pointValidForOffset(PlinePath pline, double offset, StaticSpatialIndex spatialIndex, Point2D.Double point, IntArrayDeque queryStack, double offsetTol) {
        double absOffset = Math.abs(offset) - offsetTol;
        double minDistSq = absOffset * absOffset;
        boolean[] pointValid = new boolean[]{true};
        IntPredicate visitor = i -> {
            int j = Utils.nextWrappingIndex(i, pline);
            Point2D.Double closestPoint = PlineVertex.closestPointOnSeg((PlineVertex)pline.get(i), (PlineVertex)pline.get(j), point);
            double distSq = closestPoint.distanceSq(point);
            pointValid[0] = distSq > minDistSq;
            return pointValid[0];
        };
        spatialIndex.visitQuery(point.getX() - absOffset, point.getY() - absOffset, point.getX() + absOffset, point.getY() + absOffset, visitor, queryStack);
        return pointValid[0];
    }

    void addOrReplaceIfSamePos(PlinePath pline, PlineVertex vertex) {
        this.addOrReplaceIfSamePos(pline, vertex, 1.0E-5);
    }

    void addOrReplaceIfSamePos(PlinePath pline, PlineVertex vertex, double epsilon) {
        if (pline.isEmpty()) {
            pline.addVertex(vertex);
            return;
        }
        if (Points.almostEqual(pline.lastVertex().pos(), vertex.pos(), epsilon)) {
            pline.lastVertex().bulge(vertex.bulge());
            return;
        }
        pline.addVertex(vertex);
    }

    void arcToArcJoin(PlineOffsetSegment s1, PlineOffsetSegment s2, boolean connectionArcsAreCCW, PlinePath result) {
        PlineVertex v1 = s1.v1();
        PlineVertex v2 = s1.v2();
        PlineVertex u1 = s2.v1();
        PlineVertex u2 = s2.v2();
        assert (!v1.bulgeIsZero() && !u1.bulgeIsZero()) : "both segs should be arcs";
        BulgeConversionFunctions.ArcRadiusAndCenter arc1 = BulgeConversionFunctions.arcRadiusAndCenter(v1, v2);
        BulgeConversionFunctions.ArcRadiusAndCenter arc2 = BulgeConversionFunctions.arcRadiusAndCenter(u1, u2);
        Runnable connectUsingArc = () -> {
            Point2D.Double arcCenter = s1.origV2Pos();
            Point2D.Double sp = v2.pos();
            Point2D.Double ep = u1.pos();
            double bulge = this.bulgeForConnection(arcCenter, sp, ep, connectionArcsAreCCW);
            this.addOrReplaceIfSamePos(result, new PlineVertex(sp, bulge));
            this.addOrReplaceIfSamePos(result, u1);
        };
        Consumer<Point2D.Double> processIntersect = intersect -> {
            boolean trueArcIntersect1 = Utils.pointWithinArcSweepAngle(arc1.center, v1.pos(), v2.pos(), v1.bulge(), intersect);
            boolean trueArcIntersect2 = Utils.pointWithinArcSweepAngle(arc2.center, u1.pos(), u2.pos(), u1.bulge(), intersect);
            if (trueArcIntersect1 && trueArcIntersect2) {
                double endAngle;
                double a2;
                double theta;
                PlineVertex prevVertex = result.lastVertex();
                if (!prevVertex.bulgeIsZero()) {
                    double a1 = Utils.angle(arc1.center, intersect);
                    BulgeConversionFunctions.ArcRadiusAndCenter prevArc = BulgeConversionFunctions.arcRadiusAndCenter(prevVertex, v2);
                    double prevArcStartAngle = Utils.angle(prevArc.center, prevVertex.pos());
                    double updatedPrevTheta = Utils.deltaAngle(prevArcStartAngle, a1);
                    if (updatedPrevTheta > 0.0 == prevVertex.bulgeIsPos()) {
                        result.lastVertex().bulge(Math.tan(updatedPrevTheta * 0.25));
                    }
                }
                if ((theta = Utils.deltaAngle(a2 = Utils.angle(arc2.center, intersect), endAngle = Utils.angle(arc2.center, u2.pos()))) > 0.0 == u1.bulgeIsPos()) {
                    this.addOrReplaceIfSamePos(result, new PlineVertex((Point2D.Double)intersect, Math.tan(theta * 0.25)));
                } else {
                    this.addOrReplaceIfSamePos(result, new PlineVertex((Point2D.Double)intersect, u1.bulge()));
                }
            } else {
                connectUsingArc.run();
            }
        };
        IntersectionResult intrResult = ContourIntersections.intrCircle2Circle2(arc1.radius, arc1.center, arc2.radius, arc2.center);
        switch (intrResult.getStatus()) {
            case NO_INTERSECTION_OUTSIDE: 
            case NO_INTERSECTION_INSIDE: {
                connectUsingArc.run();
                break;
            }
            case INTERSECTION: {
                double dist2;
                ImmutableList<IntersectionPoint> intersections = intrResult.intersections();
                if (intersections.size() == 1) {
                    processIntersect.accept((Point2D.Double)intersections.getFirst());
                    break;
                }
                assert (intersections.size() == 2) : "there must be 2 intersections";
                double dist1 = ((IntersectionPoint)intersections.getFirst()).distanceSq(s1.origV2Pos());
                if (dist1 < (dist2 = ((IntersectionPoint)intersections.getLast()).distanceSq(s1.origV2Pos()))) {
                    processIntersect.accept((Point2D.Double)intersections.getFirst());
                    break;
                }
                processIntersect.accept((Point2D.Double)intersections.getLast());
                break;
            }
            case NO_INTERSECTION_COINCIDENT: {
                this.addOrReplaceIfSamePos(result, u1);
            }
        }
    }

    void arcToLineJoin(PlineOffsetSegment s1, PlineOffsetSegment s2, boolean connectionArcsAreCCW, PlinePath result) {
        PlineVertex v1 = s1.v1();
        PlineVertex v2 = s1.v2();
        PlineVertex u1 = s2.v1();
        PlineVertex u2 = s2.v2();
        assert (!v1.bulgeIsZero() && u1.bulgeIsZero()) : "first seg should be line, second seg should be arc";
        Runnable connectUsingArc = () -> {
            Point2D.Double arcCenter = s1.origV2Pos();
            Point2D.Double sp = v2.pos();
            Point2D.Double ep = u1.pos();
            double bulge = this.bulgeForConnection(arcCenter, sp, ep, connectionArcsAreCCW);
            this.addOrReplaceIfSamePos(result, new PlineVertex(sp, bulge));
            this.addOrReplaceIfSamePos(result, u1);
        };
        BulgeConversionFunctions.ArcRadiusAndCenter arc = BulgeConversionFunctions.arcRadiusAndCenter(v1, v2);
        BiConsumer<Double, Point2D.Double> processIntersect = (t, intersect) -> {
            boolean trueSegIntersect = !this.falseIntersect((double)t);
            boolean trueArcIntersect = Utils.pointWithinArcSweepAngle(arc.center, v1.pos(), v2.pos(), v1.bulge(), intersect);
            if (trueSegIntersect && trueArcIntersect) {
                PlineVertex prevVertex = result.lastVertex();
                if (!prevVertex.bulgeIsZero()) {
                    double a = Utils.angle(arc.center, intersect);
                    BulgeConversionFunctions.ArcRadiusAndCenter prevArc = BulgeConversionFunctions.arcRadiusAndCenter(prevVertex, v2);
                    double prevArcStartAngle = Utils.angle(prevArc.center, prevVertex.pos());
                    double updatedPrevTheta = Utils.deltaAngle(prevArcStartAngle, a);
                    if (updatedPrevTheta > 0.0 == prevVertex.bulgeIsPos()) {
                        result.lastVertex().bulge(Math.tan(updatedPrevTheta * 0.25));
                    }
                }
                this.addOrReplaceIfSamePos(result, new PlineVertex((Point2D.Double)intersect, 0.0));
            } else {
                connectUsingArc.run();
            }
        };
        IntersectionResult intrResult = ContourIntersections.intrLineSeg2Circle2(u1.pos(), u2.pos(), arc.radius, arc.center);
        ImmutableList<IntersectionPoint> intersections = intrResult.intersections();
        if (intersections.isEmpty()) {
            connectUsingArc.run();
        } else if (intersections.size() == 1) {
            processIntersect.accept(((IntersectionPoint)intersections.getFirst()).argumentA(), Utils.pointFromParametric(u1.pos(), u2.pos(), ((IntersectionPoint)intersections.getFirst()).argumentA()));
        } else {
            Point2D.Double i2;
            double dist2;
            assert (intersections.size() == 2) : "should have 2 intersects here";
            Point2D.Double origPoint = s2.collapsedArc() ? u1.pos() : s1.origV2Pos();
            Point2D.Double i1 = Utils.pointFromParametric(u1.pos(), u2.pos(), ((IntersectionPoint)intersections.getFirst()).argumentA());
            double dist1 = i1.distanceSq(origPoint);
            if (dist1 < (dist2 = (i2 = Utils.pointFromParametric(u1.pos(), u2.pos(), ((IntersectionPoint)intersections.getLast()).argumentA())).distanceSq(origPoint))) {
                processIntersect.accept(((IntersectionPoint)intersections.getFirst()).argumentA(), i1);
            } else {
                processIntersect.accept(((IntersectionPoint)intersections.getLast()).argumentA(), i2);
            }
        }
    }

    double bulgeForConnection(Point2D.Double arcCenter, Point2D.Double sp, Point2D.Double ep, boolean isCCW) {
        double a1 = Utils.angle(arcCenter, sp);
        double a2 = Utils.angle(arcCenter, ep);
        double absSweepAngle = Math.abs(Utils.deltaAngle(a1, a2));
        double absBulge = Math.tan(absSweepAngle * 0.25);
        if (isCCW) {
            return absBulge;
        }
        return -absBulge;
    }

    public PlinePath createRawOffsetPline(PlinePath pline, double offset) {
        PlinePath result = new PlinePath();
        if (pline.size() < 2) {
            return result;
        }
        List<PlineOffsetSegment> rawOffsets = this.createUntrimmedOffsetSegments(pline, offset);
        if (rawOffsets.isEmpty()) {
            return result;
        }
        if (rawOffsets.size() == 1 && rawOffsets.getFirst().collapsedArc()) {
            return result;
        }
        result = new PlinePath(pline.size());
        result.isClosed(pline.isClosed());
        boolean connectionArcsAreCCW = offset < 0.0;
        Consumer3 joinResultVisitor = (s1, s2, presult) -> {
            boolean s1IsLine = s1.v1().bulgeIsZero();
            boolean s2IsLine = s2.v1().bulgeIsZero();
            if (s1IsLine && s2IsLine) {
                this.lineToLineJoin((PlineOffsetSegment)s1, (PlineOffsetSegment)s2, connectionArcsAreCCW, (PlinePath)presult);
            } else if (s1IsLine) {
                this.lineToArcJoin((PlineOffsetSegment)s1, (PlineOffsetSegment)s2, connectionArcsAreCCW, (PlinePath)presult);
            } else if (s2IsLine) {
                this.arcToLineJoin((PlineOffsetSegment)s1, (PlineOffsetSegment)s2, connectionArcsAreCCW, (PlinePath)presult);
            } else {
                this.arcToArcJoin((PlineOffsetSegment)s1, (PlineOffsetSegment)s2, connectionArcsAreCCW, (PlinePath)presult);
            }
        };
        result.addVertex(rawOffsets.get(0).v1());
        if (rawOffsets.size() > 1) {
            PlineOffsetSegment seg01 = rawOffsets.get(0);
            PlineOffsetSegment seg12 = rawOffsets.get(1);
            joinResultVisitor.accept((Object)seg01, (Object)seg12, (Object)result);
        }
        boolean firstVertexReplaced = result.size() == 1;
        for (int i = 2; i < rawOffsets.size(); ++i) {
            PlineOffsetSegment seg1 = rawOffsets.get(i - 1);
            PlineOffsetSegment seg2 = rawOffsets.get(i);
            joinResultVisitor.accept((Object)seg1, (Object)seg2, (Object)result);
        }
        if (pline.isClosed() && result.size() > 1) {
            PlineOffsetSegment s12 = rawOffsets.getLast();
            PlineOffsetSegment s22 = rawOffsets.getFirst();
            PlinePath closingPartResult = new PlinePath();
            closingPartResult.addVertex(result.lastVertex());
            joinResultVisitor.accept((Object)s12, (Object)s22, (Object)closingPartResult);
            result.set(result.size() - 1, (PlineVertex)closingPartResult.getFirst());
            for (int i = 1; i < closingPartResult.size(); ++i) {
                result.addVertex((PlineVertex)closingPartResult.get(i));
            }
            result.removeLast();
            if (!firstVertexReplaced) {
                Point2D.Double updatedFirstPos = closingPartResult.lastVertex().pos();
                if (((PlineVertex)result.get(0)).bulgeIsZero()) {
                    result.set(0, new PlineVertex(updatedFirstPos, 0.0));
                } else if (result.size() > 1) {
                    double a2;
                    BulgeConversionFunctions.ArcRadiusAndCenter arc = BulgeConversionFunctions.arcRadiusAndCenter((PlineVertex)result.get(0), (PlineVertex)result.get(1));
                    double a1 = Utils.angle(arc.center, updatedFirstPos);
                    double updatedTheta = Utils.deltaAngle(a1, a2 = Utils.angle(arc.center, ((PlineVertex)result.get(1)).pos()));
                    if (updatedTheta < 0.0 && ((PlineVertex)result.get(0)).bulgeIsPos() || updatedTheta > 0.0 && ((PlineVertex)result.get(0)).bulgeIsNeg()) {
                        result.set(0, new PlineVertex(updatedFirstPos, ((PlineVertex)result.getFirst()).bulge()));
                    } else {
                        result.set(0, new PlineVertex(updatedFirstPos, Math.tan(updatedTheta * 0.25)));
                    }
                }
            }
            if (result.size() > 1 && Points.almostEqual(((PlineVertex)result.get(0)).pos(), ((PlineVertex)result.get(1)).pos(), 1.0E-5)) {
                result.removeFirst();
            }
        } else {
            this.addOrReplaceIfSamePos(result, rawOffsets.getLast().v2());
        }
        if (result.size() == 1) {
            result.clear();
        }
        return result;
    }

    List<PlineOffsetSegment> createUntrimmedOffsetSegments(PlinePath pline, double offset) {
        int size = pline.size();
        int segmentCount = pline.isClosed() ? size : size - 1;
        ArrayList<PlineOffsetSegment> result = new ArrayList<PlineOffsetSegment>(segmentCount);
        BiConsumer<PlineVertex, PlineVertex> lineVisitor = (v1, v2) -> {
            Point2D.Double edge = Points2D.subtract(v2.pos(), v1.pos());
            Point2D.Double offsetV = Points2D.multiply(Utils.unitPerp(edge), offset);
            PlineOffsetSegment seg = new PlineOffsetSegment(new PlineVertex(Points2D.add(v1.pos(), offsetV), 0.0), new PlineVertex(Points2D.add(v2.pos(), offsetV), 0.0), v2.pos(), false);
            result.add(seg);
        };
        BiConsumer<PlineVertex, PlineVertex> arcVisitor = (v1, v2) -> {
            BulgeConversionFunctions.ArcRadiusAndCenter arc = BulgeConversionFunctions.arcRadiusAndCenter(v1, v2);
            double offs = v1.bulgeIsNeg() ? offset : -offset;
            double radiusAfterOffset = arc.radius + offs;
            Point2D.Double v1ToCenter = Points2D.normalize(Points2D.subtract(v1.pos(), arc.center));
            Point2D.Double v2ToCenter = Points2D.normalize(Points2D.subtract(v2.pos(), arc.center));
            boolean isCollapsedArc = radiusAfterOffset < 1.0E-8;
            PlineOffsetSegment seg = new PlineOffsetSegment(new PlineVertex(Points2D.add(Points2D.multiply(v1ToCenter, offs), v1.pos()), isCollapsedArc ? 0.0 : v1.bulge()), new PlineVertex(Points2D.add(Points2D.multiply(v2ToCenter, offs), v2.pos()), v2.bulge()), v2.pos(), isCollapsedArc);
            result.add(seg);
        };
        BiConsumer<PlineVertex, PlineVertex> offsetVisitor = (v1, v2) -> {
            double dy;
            double dx = v1.getX() - v2.getX();
            double squaredDistance = Math.fma(dx, dx, (dy = v1.getY() - v2.getY()) * dy);
            if (squaredDistance <= 1.0E-5) {
                return;
            }
            if (v1.bulgeIsZero()) {
                lineVisitor.accept((PlineVertex)v1, (PlineVertex)v2);
            } else {
                arcVisitor.accept((PlineVertex)v1, (PlineVertex)v2);
            }
        };
        for (int i = 0; i < segmentCount; ++i) {
            offsetVisitor.accept((PlineVertex)pline.get(i), (PlineVertex)pline.get((i + 1) % size));
        }
        return result;
    }

    List<OpenPolylineSlice> dualSliceAtIntersectsForOffset(PlinePath originalPline, PlinePath rawOffsetPline, PlinePath dualRawOffsetPline, double offset) {
        ArrayList<OpenPolylineSlice> result = new ArrayList<OpenPolylineSlice>();
        if (rawOffsetPline.size() < 2) {
            return result;
        }
        StaticSpatialIndex origPlineSpatialIndex = PlinePath.createApproxSpatialIndex(originalPline);
        Map<Integer, List<Point2D.Double>> intersectsLookup = this.computeIntersectionsOfRawWithSelfWithDualRawAndAtEndPoints(originalPline, rawOffsetPline, dualRawOffsetPline, offset);
        IntArrayDeque queryStack = new IntArrayDeque(8);
        if (intersectsLookup.isEmpty()) {
            if (!ContourBuilder.pointValidForOffset(originalPline, offset, origPlineSpatialIndex, ((PlineVertex)rawOffsetPline.getFirst()).pos(), queryStack)) {
                return result;
            }
            OpenPolylineSlice back = new OpenPolylineSlice(Integer.MAX_VALUE, rawOffsetPline);
            back.pline.isClosed(false);
            if (originalPline.isClosed()) {
                back.pline.addVertex((PlineVertex)rawOffsetPline.getFirst());
                back.pline.lastVertex().bulge(0.0);
            }
            result.add(back);
            return result;
        }
        for (Map.Entry<Integer, List<Point2D.Double>> entry : intersectsLookup.entrySet()) {
            Point2D.Double startPos = ((PlineVertex)rawOffsetPline.get(entry.getKey())).pos();
            Comparator<Point2D.Double> cmp = Comparator.comparingDouble(si -> si.distanceSq(startPos));
            entry.getValue().sort(cmp);
        }
        BiPredicate<PlineVertex, PlineVertex> intersectsOrigPline = (v1, v2) -> {
            AABB approxBB = PlineVertex.createFastApproxBoundingBox(v1, v2);
            boolean[] intersects = new boolean[]{false};
            IntPredicate visitor = i -> {
                int j = Utils.nextWrappingIndex(i, originalPline);
                IntrPlineSegsResult intrResult = ContourIntersections.intrPlineSegs(v1, v2, (PlineVertex)originalPline.get(i), (PlineVertex)originalPline.get(j));
                intersects[0] = intrResult.intrType != PlineSegIntrType.NoIntersect;
                return !intersects[0];
            };
            origPlineSpatialIndex.visitQuery(approxBB.minX(), approxBB.minY(), approxBB.maxX(), approxBB.maxY(), visitor, queryStack);
            return intersects[0];
        };
        if (!originalPline.isClosed()) {
            PlinePath firstSlice = new PlinePath();
            int index = 0;
            int loopCount = 0;
            int maxLoopCount = rawOffsetPline.size();
            while (true) {
                if (loopCount++ > maxLoopCount) {
                    assert (false) : "Bug detected, should never loop this many times!";
                    break;
                }
                List<Point2D.Double> iter = intersectsLookup.get(index);
                if (iter == null) {
                    if (!ContourBuilder.pointValidForOffset(originalPline, offset, origPlineSpatialIndex, ((PlineVertex)rawOffsetPline.get(index)).pos(), queryStack) || index != 0 && intersectsOrigPline.test(firstSlice.lastVertex(), (PlineVertex)rawOffsetPline.get(index))) break;
                } else {
                    Point2D.Double intersectPos = iter.getFirst();
                    if (!ContourBuilder.pointValidForOffset(originalPline, offset, origPlineSpatialIndex, intersectPos, queryStack)) break;
                    SplitResult split = PlineVertex.splitAtPoint((PlineVertex)rawOffsetPline.get(index), (PlineVertex)rawOffsetPline.get(index + 1), intersectPos);
                    PlineVertex sliceEndVertex = new PlineVertex(intersectPos, 0.0);
                    Point2D.Double midpoint = PlineVertex.segMidpoint(split.updatedStart, sliceEndVertex);
                    if (!ContourBuilder.pointValidForOffset(originalPline, offset, origPlineSpatialIndex, midpoint, queryStack) || intersectsOrigPline.test(split.updatedStart, sliceEndVertex)) break;
                    this.addOrReplaceIfSamePos(firstSlice, split.updatedStart);
                    this.addOrReplaceIfSamePos(firstSlice, sliceEndVertex);
                    result.add(new OpenPolylineSlice(0, firstSlice));
                    break;
                }
                this.addOrReplaceIfSamePos(firstSlice, (PlineVertex)rawOffsetPline.get(index));
                ++index;
            }
        }
        for (Map.Entry<Integer, List<Point2D.Double>> kvp : intersectsLookup.entrySet()) {
            int sIndex = kvp.getKey();
            List<Point2D.Double> siList = kvp.getValue();
            PlineVertex startVertex = (PlineVertex)rawOffsetPline.get(sIndex);
            int nextIndex = Utils.nextWrappingIndex(sIndex, rawOffsetPline);
            PlineVertex endVertex = (PlineVertex)rawOffsetPline.get(nextIndex);
            if (siList.size() != 1) {
                SplitResult firstSplit = PlineVertex.splitAtPoint(startVertex, endVertex, siList.getFirst());
                PlineVertex prevVertex = firstSplit.splitVertex;
                for (int i = 1; i < siList.size(); ++i) {
                    Point2D.Double midpoint;
                    SplitResult split = PlineVertex.splitAtPoint(prevVertex, endVertex, siList.get(i));
                    prevVertex = split.splitVertex;
                    if (Points.almostEqual(split.updatedStart.pos(), split.splitVertex.pos(), 1.0E-5) || !ContourBuilder.pointValidForOffset(originalPline, offset, origPlineSpatialIndex, split.updatedStart.pos(), queryStack) || !ContourBuilder.pointValidForOffset(originalPline, offset, origPlineSpatialIndex, split.splitVertex.pos(), queryStack) || !ContourBuilder.pointValidForOffset(originalPline, offset, origPlineSpatialIndex, midpoint = PlineVertex.segMidpoint(split.updatedStart, split.splitVertex), queryStack) || intersectsOrigPline.test(split.updatedStart, split.splitVertex)) continue;
                    OpenPolylineSlice back = new OpenPolylineSlice(sIndex);
                    back.pline.addVertex(split.updatedStart);
                    back.pline.addVertex(split.splitVertex);
                    result.add(back);
                }
            }
            if (!ContourBuilder.pointValidForOffset(originalPline, offset, origPlineSpatialIndex, siList.getLast(), queryStack)) continue;
            SplitResult split = PlineVertex.splitAtPoint(startVertex, endVertex, siList.getLast());
            PlinePath currSlice = new PlinePath();
            currSlice.addVertex(split.splitVertex.clone());
            int index = nextIndex;
            boolean isValidPline = true;
            int loopCount = 0;
            int maxLoopCount = rawOffsetPline.size();
            while (true) {
                if (loopCount++ > maxLoopCount) {
                    assert (false) : "Bug detected, should never loop this many times!";
                    break;
                }
                if (!ContourBuilder.pointValidForOffset(originalPline, offset, origPlineSpatialIndex, ((PlineVertex)rawOffsetPline.get(index)).pos(), queryStack)) {
                    isValidPline = false;
                    break;
                }
                if (intersectsOrigPline.test(currSlice.lastVertex(), (PlineVertex)rawOffsetPline.get(index))) {
                    isValidPline = false;
                    break;
                }
                this.addOrReplaceIfSamePos(currSlice, (PlineVertex)rawOffsetPline.get(index));
                List<Point2D.Double> nextIntr = intersectsLookup.get(index);
                if (nextIntr != null) {
                    Point2D.Double intersectPos = nextIntr.getFirst();
                    if (!ContourBuilder.pointValidForOffset(originalPline, offset, origPlineSpatialIndex, intersectPos, queryStack)) {
                        isValidPline = false;
                        break;
                    }
                    nextIndex = Utils.nextWrappingIndex(index, rawOffsetPline);
                    split = PlineVertex.splitAtPoint(currSlice.lastVertex(), (PlineVertex)rawOffsetPline.get(nextIndex), intersectPos);
                    PlineVertex sliceEndVertex = new PlineVertex(intersectPos, 0.0);
                    Point2D.Double mp = PlineVertex.segMidpoint(split.updatedStart, sliceEndVertex);
                    if (!ContourBuilder.pointValidForOffset(originalPline, offset, origPlineSpatialIndex, mp, queryStack)) {
                        isValidPline = false;
                        break;
                    }
                    currSlice.lastVertex(split.updatedStart);
                    this.addOrReplaceIfSamePos(currSlice, sliceEndVertex);
                    break;
                }
                if (index == rawOffsetPline.size() - 1) {
                    if (!originalPline.isClosed()) break;
                    index = 0;
                    continue;
                }
                ++index;
            }
            if (!isValidPline || currSlice.size() <= 1) continue;
            result.add(new OpenPolylineSlice(sIndex, currSlice));
        }
        return result;
    }

    private Map<Integer, List<Point2D.Double>> computeIntersectionsOfRawWithSelfWithDualRawAndAtEndPoints(PlinePath originalPline, PlinePath rawOffsetPline, PlinePath dualRawOffsetPline, double offset) {
        HashMap<Integer, List<Point2D.Double>> intersectsLookup;
        StaticSpatialIndex rawOffsetPlineSpatialIndex = PlinePath.createApproxSpatialIndex(rawOffsetPline);
        ArrayList<PlineIntersect> selfIntersects = new ArrayList<PlineIntersect>();
        ContourIntersections.allSelfIntersects(rawOffsetPline, selfIntersects, rawOffsetPlineSpatialIndex);
        PlineIntersectsResult dualIntersects = new PlineIntersectsResult();
        ContourIntersections.findIntersects(rawOffsetPline, dualRawOffsetPline, rawOffsetPlineSpatialIndex, dualIntersects);
        if (!originalPline.isClosed()) {
            ArrayList<OrderedPair<Integer, List<Point2D.Double>>> intersects = new ArrayList<OrderedPair<Integer, List<Point2D.Double>>>();
            this.offsetCircleIntersectsWithPline(rawOffsetPline, offset, ((PlineVertex)originalPline.getFirst()).pos(), rawOffsetPlineSpatialIndex, intersects);
            this.offsetCircleIntersectsWithPline(rawOffsetPline, offset, originalPline.lastVertex().pos(), rawOffsetPlineSpatialIndex, intersects);
            intersectsLookup = new HashMap(2 * selfIntersects.size() + intersects.size());
            for (OrderedPair orderedPair : intersects) {
                intersectsLookup.computeIfAbsent((Integer)orderedPair.first(), k -> new ArrayList()).addAll((Collection)orderedPair.second());
            }
        } else {
            intersectsLookup = new HashMap<Integer, List<Point2D.Double>>(2 * selfIntersects.size());
        }
        for (PlineIntersect plineIntersect : selfIntersects) {
            intersectsLookup.computeIfAbsent(plineIntersect.sIndex1, k -> new ArrayList()).add(plineIntersect.pos);
            intersectsLookup.computeIfAbsent(plineIntersect.sIndex2, k -> new ArrayList()).add(plineIntersect.pos);
        }
        for (PlineIntersect plineIntersect : dualIntersects.intersects) {
            intersectsLookup.computeIfAbsent(plineIntersect.sIndex1, k -> new ArrayList()).add(plineIntersect.pos);
        }
        for (PlineCoincidentIntersect plineCoincidentIntersect : dualIntersects.coincidentIntersects) {
            intersectsLookup.computeIfAbsent(plineCoincidentIntersect.sIndex1, k -> new ArrayList()).add(plineCoincidentIntersect.point1);
            intersectsLookup.computeIfAbsent(plineCoincidentIntersect.sIndex1, k -> new ArrayList()).add(plineCoincidentIntersect.point2);
        }
        return intersectsLookup;
    }

    boolean falseIntersect(double t) {
        return t < 0.0 || t > 1.0;
    }

    void lineToArcJoin(PlineOffsetSegment s1, PlineOffsetSegment s2, boolean connectionArcsAreCCW, PlinePath result) {
        PlineVertex v1 = s1.v1();
        PlineVertex v2 = s1.v2();
        PlineVertex u1 = s2.v1();
        PlineVertex u2 = s2.v2();
        assert (v1.bulgeIsZero() && !u1.bulgeIsZero()) : "first seg should be arc, second seg should be line";
        Runnable connectUsingArc = () -> {
            Point2D.Double arcCenter = s1.origV2Pos();
            Point2D.Double sp = v2.pos();
            Point2D.Double ep = u1.pos();
            double bulge = this.bulgeForConnection(arcCenter, sp, ep, connectionArcsAreCCW);
            this.addOrReplaceIfSamePos(result, new PlineVertex(sp, bulge));
            this.addOrReplaceIfSamePos(result, u1);
        };
        BulgeConversionFunctions.ArcRadiusAndCenter arc = BulgeConversionFunctions.arcRadiusAndCenter(u1, u2);
        BiConsumer<Double, Point2D.Double> processIntersect = (t, intersect) -> {
            boolean trueSegIntersect = !this.falseIntersect((double)t);
            boolean trueArcIntersect = Utils.pointWithinArcSweepAngle(arc.center, u1.pos(), u2.pos(), u1.bulge(), intersect);
            if (trueSegIntersect && trueArcIntersect) {
                double arcEndAngle;
                double a = Utils.angle(arc.center, intersect);
                double theta = Utils.deltaAngle(a, arcEndAngle = Utils.angle(arc.center, u2.pos()));
                if (theta > 0.0 == u1.bulgeIsPos()) {
                    this.addOrReplaceIfSamePos(result, new PlineVertex((Point2D.Double)intersect, Math.tan(theta * 0.25)));
                } else {
                    this.addOrReplaceIfSamePos(result, new PlineVertex((Point2D.Double)intersect, u1.bulge()));
                }
            } else if (t > 1.0 && !trueArcIntersect) {
                connectUsingArc.run();
            } else if (s1.collapsedArc()) {
                connectUsingArc.run();
            } else {
                this.addOrReplaceIfSamePos(result, new PlineVertex(v2.pos(), 0.0));
                this.addOrReplaceIfSamePos(result, u1);
            }
        };
        IntersectionResult intrResult = ContourIntersections.intrLineSeg2Circle2(v1.pos(), v2.pos(), arc.radius, arc.center);
        ImmutableList<IntersectionPoint> intersections = intrResult.intersections();
        if (intersections.isEmpty()) {
            connectUsingArc.run();
        } else if (intersections.size() == 1) {
            processIntersect.accept(((IntersectionPoint)intersections.getFirst()).argumentA(), (Point2D.Double)intersections.getFirst());
        } else {
            Point2D.Double i2;
            double dist2;
            assert (intersections.size() == 2) : "should have 2 intersects here";
            Point2D.Double i1 = (Point2D.Double)intersections.getFirst();
            double dist1 = i1.distanceSq(s1.origV2Pos());
            if (dist1 < (dist2 = (i2 = (Point2D.Double)intersections.getLast()).distanceSq(s1.origV2Pos()))) {
                processIntersect.accept(((IntersectionPoint)intersections.getFirst()).argumentA(), i1);
            } else {
                processIntersect.accept(((IntersectionPoint)intersections.getLast()).argumentA(), i2);
            }
        }
    }

    void lineToLineJoin(PlineOffsetSegment s1, PlineOffsetSegment s2, boolean connectionArcsAreCCW, PlinePath result) {
        PlineVertex v1 = s1.v1();
        PlineVertex v2 = s1.v2();
        PlineVertex u1 = s2.v1();
        PlineVertex u2 = s2.v2();
        assert (v1.bulgeIsZero() && u1.bulgeIsZero()) : "both segs should be lines";
        Runnable connectUsingArc = () -> {
            Point2D.Double arcCenter = s1.origV2Pos();
            Point2D.Double sp = v2.pos();
            Point2D.Double ep = u1.pos();
            double bulge = this.bulgeForConnection(arcCenter, sp, ep, connectionArcsAreCCW);
            this.addOrReplaceIfSamePos(result, new PlineVertex(sp, bulge));
            this.addOrReplaceIfSamePos(result, new PlineVertex(ep, 0.0));
        };
        if (s1.collapsedArc() || s2.collapsedArc()) {
            connectUsingArc.run();
        } else {
            IntersectionResultEx intrResult = ContourIntersections.intrLineSeg2LineSeg2(v1.pos(), v2.pos(), u1.pos(), u2.pos());
            ImmutableList<IntersectionPointEx> intersections = intrResult.intersections();
            switch (intrResult.getStatus()) {
                case NO_INTERSECTION_PARALLEL: {
                    connectUsingArc.run();
                    break;
                }
                case INTERSECTION: {
                    this.addOrReplaceIfSamePos(result, new PlineVertex((Point2D.Double)intersections.getFirst(), 0.0));
                    break;
                }
                case NO_INTERSECTION_COINCIDENT: {
                    this.addOrReplaceIfSamePos(result, new PlineVertex(v2.pos(), 0.0));
                    break;
                }
                case NO_INTERSECTION: {
                    connectUsingArc.run();
                }
            }
        }
    }

    void offsetCircleIntersectsWithPline(PlinePath pline, double offset, Point2D.Double circleCenter, StaticSpatialIndex spatialIndex, List<OrderedPair<Integer, List<Point2D.Double>>> output) {
        double circleRadius = Math.abs(offset);
        IntArrayList queryResults = new IntArrayList();
        spatialIndex.query(circleCenter.getX() - circleRadius, circleCenter.getY() - circleRadius, circleCenter.getX() + circleRadius, circleCenter.getY() + circleRadius, queryResults);
        Predicate<Double> validLineSegIntersect = t -> !this.falseIntersect((double)t) && Math.abs(t) > 1.0E-5;
        Function5 validArcSegIntersect = (arcCenter, arcStart, arcEnd, bulge, intrPoint) -> !Points.almostEqual(arcStart, intrPoint, 1.0E-5) && Utils.pointWithinArcSweepAngle(arcCenter, arcStart, arcEnd, bulge, intrPoint);
        PrimitiveIterator.OfInt ofInt = queryResults.iterator();
        while (ofInt.hasNext()) {
            int sIndex = (Integer)ofInt.next();
            PlineVertex v1 = (PlineVertex)pline.get(sIndex);
            PlineVertex v2 = (PlineVertex)pline.get(sIndex + 1);
            if (v1.bulgeIsZero()) {
                IntersectionResult intrResult = ContourIntersections.intrLineSeg2Circle2(v1.pos(), v2.pos(), circleRadius, circleCenter);
                ImmutableList<IntersectionPoint> intersections = intrResult.intersections();
                if (intersections.isEmpty()) continue;
                if (intersections.size() == 1) {
                    if (!validLineSegIntersect.test(((IntersectionPoint)intersections.getFirst()).argumentA())) continue;
                    output.add((OrderedPair<Integer, List<Point2D.Double>>)new SimpleOrderedPair((Object)sIndex, Collections.singletonList((Point2D.Double)intersections.getFirst())));
                    continue;
                }
                assert (intersections.size() == 2) : "should be two intersects here";
                if (validLineSegIntersect.test(((IntersectionPoint)intersections.getFirst()).argumentA())) {
                    output.add((OrderedPair<Integer, List<Point2D.Double>>)new SimpleOrderedPair((Object)sIndex, Collections.singletonList((Point2D.Double)intersections.getFirst())));
                }
                if (!validLineSegIntersect.test(((IntersectionPoint)intersections.getLast()).argumentA())) continue;
                output.add((OrderedPair<Integer, List<Point2D.Double>>)new SimpleOrderedPair((Object)sIndex, Collections.singletonList((Point2D.Double)intersections.getLast())));
                continue;
            }
            BulgeConversionFunctions.ArcRadiusAndCenter arc = BulgeConversionFunctions.arcRadiusAndCenter(v1, v2);
            IntersectionResult intrResult = ContourIntersections.intrCircle2Circle2(arc.radius, arc.center, circleRadius, circleCenter);
            switch (intrResult.getStatus()) {
                case NO_INTERSECTION_OUTSIDE: 
                case NO_INTERSECTION_INSIDE: 
                case NO_INTERSECTION_COINCIDENT: {
                    break;
                }
                case INTERSECTION: {
                    ImmutableList<IntersectionPoint> intersections = intrResult.intersections();
                    if (intersections.size() == 1) {
                        if (!((Boolean)validArcSegIntersect.apply((Object)arc.center, (Object)v1.pos(), (Object)v2.pos(), (Object)v1.bulge(), (Object)((Point2D.Double)intersections.getFirst()))).booleanValue()) break;
                        output.add((OrderedPair<Integer, List<Point2D.Double>>)new SimpleOrderedPair((Object)sIndex, Collections.singletonList((Point2D.Double)intersections.getFirst())));
                        break;
                    }
                    assert (intersections.size() == 2) : "there must be 2 intersections";
                    if (((Boolean)validArcSegIntersect.apply((Object)arc.center, (Object)v1.pos(), (Object)v2.pos(), (Object)v1.bulge(), (Object)((Point2D.Double)intersections.getFirst()))).booleanValue()) {
                        output.add((OrderedPair<Integer, List<Point2D.Double>>)new SimpleOrderedPair((Object)sIndex, Collections.singletonList((Point2D.Double)intersections.getFirst())));
                    }
                    if (!((Boolean)validArcSegIntersect.apply((Object)arc.center, (Object)v1.pos(), (Object)v2.pos(), (Object)v1.bulge(), (Object)((Point2D.Double)intersections.getLast()))).booleanValue()) break;
                    output.add((OrderedPair<Integer, List<Point2D.Double>>)new SimpleOrderedPair((Object)sIndex, Collections.singletonList((Point2D.Double)intersections.getLast())));
                }
            }
        }
    }

    public List<PlinePath> parallelOffset(PlinePath pline, double offset) {
        return this.parallelOffset(pline, offset, true);
    }

    private List<PlinePath> parallelOffset(PlinePath pline, double offset, boolean mayHaveSelfIntersects) {
        if (pline.size() < 2) {
            return new ArrayList<PlinePath>();
        }
        PlinePath rawOffset = this.createRawOffsetPline(pline, offset);
        if (pline.isClosed() && !mayHaveSelfIntersects) {
            List<OpenPolylineSlice> slices = this.slicesFromRawOffset(pline, rawOffset, offset);
            return this.stitchOffsetSlicesTogether(slices, pline.isClosed(), rawOffset.size() - 1);
        }
        PlinePath dualRawOffset = this.createRawOffsetPline(pline, -offset);
        List<OpenPolylineSlice> slices = this.dualSliceAtIntersectsForOffset(pline, rawOffset, dualRawOffset, offset);
        return this.stitchOffsetSlicesTogether(slices, pline.isClosed(), rawOffset.size() - 1);
    }

    List<OpenPolylineSlice> slicesFromRawOffset(PlinePath originalPline, PlinePath rawOffsetPline, double offset) {
        assert (originalPline.isClosed()) : "use dual slice at intersects for open polylines";
        ArrayList<OpenPolylineSlice> result = new ArrayList<OpenPolylineSlice>();
        if (rawOffsetPline.size() < 2) {
            return result;
        }
        StaticSpatialIndex origPlineSpatialIndex = PlinePath.createApproxSpatialIndex(originalPline);
        StaticSpatialIndex rawOffsetPlineSpatialIndex = PlinePath.createApproxSpatialIndex(rawOffsetPline);
        ArrayList<PlineIntersect> selfIntersects = new ArrayList<PlineIntersect>();
        ContourIntersections.allSelfIntersects(rawOffsetPline, selfIntersects, rawOffsetPlineSpatialIndex);
        IntArrayDeque queryStack = new IntArrayDeque(8);
        if (selfIntersects.isEmpty()) {
            if (!ContourBuilder.pointValidForOffset(originalPline, offset, origPlineSpatialIndex, ((PlineVertex)rawOffsetPline.getFirst()).pos(), queryStack)) {
                return result;
            }
            OpenPolylineSlice back = new OpenPolylineSlice(Integer.MAX_VALUE, rawOffsetPline);
            result.add(back);
            back.pline.isClosed(false);
            back.pline.addVertex((PlineVertex)rawOffsetPline.getFirst());
            back.pline.lastVertex().bulge(0.0);
            return result;
        }
        HashMap<Integer, List> intersectsLookup = new HashMap<Integer, List>(2 * selfIntersects.size());
        for (PlineIntersect plineIntersect : selfIntersects) {
            intersectsLookup.computeIfAbsent(plineIntersect.sIndex1, k -> new ArrayList()).add(plineIntersect.pos);
            intersectsLookup.computeIfAbsent(plineIntersect.sIndex2, k -> new ArrayList()).add(plineIntersect.pos);
        }
        for (Map.Entry entry : intersectsLookup.entrySet()) {
            Point2D.Double startPos = ((PlineVertex)rawOffsetPline.get((Integer)entry.getKey())).pos();
            Comparator<Point2D.Double> cmp = Comparator.comparingDouble(si -> si.distanceSq(startPos));
            ((List)entry.getValue()).sort(cmp);
        }
        BiPredicate<PlineVertex, PlineVertex> intersectsOrigPline = (v1, v2) -> {
            AABB approxBB = PlineVertex.createFastApproxBoundingBox(v1, v2);
            boolean[] hasIntersect = new boolean[]{false};
            IntPredicate visitor = i -> {
                int j = Utils.nextWrappingIndex(i, originalPline);
                IntrPlineSegsResult intrResult = ContourIntersections.intrPlineSegs(v1, v2, (PlineVertex)originalPline.get(i), (PlineVertex)originalPline.get(j));
                hasIntersect[0] = intrResult.intrType != PlineSegIntrType.NoIntersect;
                return !hasIntersect[0];
            };
            origPlineSpatialIndex.visitQuery(approxBB.minX(), approxBB.minY(), approxBB.maxX(), approxBB.maxY(), visitor, queryStack);
            return hasIntersect[0];
        };
        for (Map.Entry kvp : intersectsLookup.entrySet()) {
            int sIndex = (Integer)kvp.getKey();
            List siList = (List)kvp.getValue();
            PlineVertex startVertex = (PlineVertex)rawOffsetPline.get(sIndex);
            int nextIndex = Utils.nextWrappingIndex(sIndex, rawOffsetPline);
            PlineVertex endVertex = (PlineVertex)rawOffsetPline.get(nextIndex);
            if (siList.size() != 1) {
                SplitResult firstSplit = PlineVertex.splitAtPoint(startVertex, endVertex, (Point2D.Double)siList.getFirst());
                PlineVertex prevVertex = firstSplit.splitVertex;
                for (int i = 1; i < siList.size(); ++i) {
                    Point2D.Double midpoint;
                    SplitResult split = PlineVertex.splitAtPoint(prevVertex, endVertex, (Point2D.Double)siList.get(i));
                    prevVertex = split.splitVertex;
                    if (Points.almostEqual(split.updatedStart.pos(), split.splitVertex.pos(), 1.0E-5) || !ContourBuilder.pointValidForOffset(originalPline, offset, origPlineSpatialIndex, split.updatedStart.pos(), queryStack) || !ContourBuilder.pointValidForOffset(originalPline, offset, origPlineSpatialIndex, split.splitVertex.pos(), queryStack) || !ContourBuilder.pointValidForOffset(originalPline, offset, origPlineSpatialIndex, midpoint = PlineVertex.segMidpoint(split.updatedStart, split.splitVertex), queryStack) || intersectsOrigPline.test(split.updatedStart, split.splitVertex)) continue;
                    OpenPolylineSlice back = new OpenPolylineSlice(sIndex);
                    back.pline.addVertex(split.updatedStart);
                    back.pline.addVertex(split.splitVertex);
                    result.add(back);
                }
            }
            if (!ContourBuilder.pointValidForOffset(originalPline, offset, origPlineSpatialIndex, (Point2D.Double)siList.getLast(), queryStack)) continue;
            SplitResult split = PlineVertex.splitAtPoint(startVertex, endVertex, (Point2D.Double)siList.getLast());
            PlinePath currSlice = new PlinePath();
            currSlice.addVertex(split.splitVertex);
            int index = nextIndex;
            boolean isValidPline = true;
            int loopCount = 0;
            int maxLoopCount = rawOffsetPline.size();
            while (true) {
                if (loopCount++ > maxLoopCount) {
                    assert (false) : "Bug detected, should never loop this many times!";
                    break;
                }
                if (!ContourBuilder.pointValidForOffset(originalPline, offset, origPlineSpatialIndex, ((PlineVertex)rawOffsetPline.get(index)).pos(), queryStack)) {
                    isValidPline = false;
                    break;
                }
                if (intersectsOrigPline.test(currSlice.lastVertex(), (PlineVertex)rawOffsetPline.get(index))) {
                    isValidPline = false;
                    break;
                }
                this.addOrReplaceIfSamePos(currSlice, (PlineVertex)rawOffsetPline.get(index));
                List nextIntr = (List)intersectsLookup.get(index);
                if (nextIntr != null) {
                    Point2D.Double intersectPos = (Point2D.Double)nextIntr.getFirst();
                    if (!ContourBuilder.pointValidForOffset(originalPline, offset, origPlineSpatialIndex, intersectPos, queryStack)) {
                        isValidPline = false;
                        break;
                    }
                    nextIndex = Utils.nextWrappingIndex(index, rawOffsetPline);
                    split = PlineVertex.splitAtPoint(currSlice.lastVertex(), (PlineVertex)rawOffsetPline.get(nextIndex), intersectPos);
                    PlineVertex sliceEndVertex = new PlineVertex(intersectPos, 0.0);
                    Point2D.Double mp = PlineVertex.segMidpoint(split.updatedStart, sliceEndVertex);
                    if (!ContourBuilder.pointValidForOffset(originalPline, offset, origPlineSpatialIndex, mp, queryStack)) {
                        isValidPline = false;
                        break;
                    }
                    currSlice.lastVertex(split.updatedStart);
                    this.addOrReplaceIfSamePos(currSlice, sliceEndVertex);
                    break;
                }
                index = Utils.nextWrappingIndex(index, rawOffsetPline);
            }
            boolean bl = isValidPline = isValidPline && currSlice.size() > 1;
            if (isValidPline && Points.almostEqual(((PlineVertex)currSlice.getFirst()).pos(), currSlice.lastVertex().pos())) {
                boolean bl2 = isValidPline = currSlice.getPathLength() > 0.01;
            }
            if (!isValidPline) continue;
            result.add(new OpenPolylineSlice(sIndex, currSlice));
        }
        return result;
    }

    protected List<PlinePath> stitchOffsetSlicesTogether(List<OpenPolylineSlice> slices, boolean closedPolyline, int origMaxIndex) {
        return this.stitchOffsetSlicesTogether(slices, closedPolyline, origMaxIndex, 1.0E-4);
    }

    protected List<PlinePath> stitchOffsetSlicesTogether(List<OpenPolylineSlice> slices, boolean closedPolyline, int origMaxIndex, double joinThreshold) {
        ArrayList<PlinePath> result = new ArrayList<PlinePath>();
        if (slices.isEmpty()) {
            return result;
        }
        if (slices.size() == 1) {
            result.add(slices.getFirst().pline);
            if (closedPolyline && Points.almostEqual(((PlineVertex)((PlinePath)result.getFirst()).getFirst()).pos(), ((PlinePath)result.getFirst()).lastVertex().pos(), joinThreshold)) {
                ((PlinePath)result.getFirst()).isClosed(true);
                ((PlinePath)result.getFirst()).removeLast();
            }
            return result;
        }
        StaticSpatialIndex spatialIndex = new StaticSpatialIndex(slices.size());
        for (OpenPolylineSlice slice : slices) {
            Point2D.Double point = ((PlineVertex)slice.pline.getFirst()).pos();
            spatialIndex.add(point.getX() - joinThreshold, point.getY() - joinThreshold, point.getX() + joinThreshold, point.getY() + joinThreshold);
        }
        spatialIndex.finish();
        BitSet visitedIndexes = new BitSet(slices.size());
        IntArrayList queryResults = new IntArrayList();
        IntArrayDeque queryStack = new IntArrayDeque(8);
        block1: for (int i = 0; i < slices.size(); ++i) {
            if (visitedIndexes.get(i)) continue;
            visitedIndexes.set(i, true);
            PlinePath currPline = new PlinePath();
            int currIndex = i;
            Point2D.Double initialStartPoint = ((PlineVertex)slices.get((int)i).pline.getFirst()).pos();
            int loopCount = 0;
            int maxLoopCount = slices.size();
            while (true) {
                if (loopCount++ > maxLoopCount) {
                    assert (false) : "Bug detected, should never loop this many times!";
                    continue block1;
                }
                int currLoopStartIndex = slices.get((int)currIndex).intrStartIndex;
                PlinePath currSlice = slices.get((int)currIndex).pline;
                Point2D.Double currEndPoint = slices.get((int)currIndex).pline.lastVertex().pos();
                currPline.addAll(currSlice);
                queryResults.clear();
                spatialIndex.query(currEndPoint.getX() - joinThreshold, currEndPoint.getY() - joinThreshold, currEndPoint.getX() + joinThreshold, currEndPoint.getY() + joinThreshold, queryResults, queryStack);
                queryResults.removeIfAsInt(visitedIndexes::get);
                Function<Integer, OrderedPair> indexDistAndEqualInitial = index -> {
                    OpenPolylineSlice slice = (OpenPolylineSlice)slices.get((int)index);
                    int indexDist = currLoopStartIndex <= slice.intrStartIndex ? slice.intrStartIndex - currLoopStartIndex : origMaxIndex - currLoopStartIndex + slice.intrStartIndex;
                    boolean equalToInitial = Points.almostEqual(slice.pline.lastVertex().pos(), initialStartPoint, 1.0E-5);
                    return new SimpleOrderedPair((Object)indexDist, (Object)equalToInitial);
                };
                queryResults.sort((index1, index2) -> {
                    OrderedPair distAndEqualInitial1 = (OrderedPair)indexDistAndEqualInitial.apply((Integer)index1);
                    OrderedPair distAndEqualInitial2 = (OrderedPair)indexDistAndEqualInitial.apply((Integer)index2);
                    if (((Integer)distAndEqualInitial1.first()).equals(distAndEqualInitial2.first())) {
                        return ((Boolean)distAndEqualInitial1.second() != false ? 1 : 0) - ((Boolean)distAndEqualInitial2.second() != false ? 1 : 0);
                    }
                    return (Integer)distAndEqualInitial2.first() - (Integer)distAndEqualInitial1.first();
                });
                if (queryResults.isEmpty()) {
                    if (currPline.size() <= 1) continue block1;
                    if (closedPolyline && Points.almostEqual(((PlineVertex)currPline.getFirst()).pos(), currPline.lastVertex().pos(), 1.0E-5)) {
                        currPline.removeLast();
                        currPline.isClosed(true);
                    }
                    result.add(currPline);
                    continue block1;
                }
                visitedIndexes.set(queryResults.getAsInt(0), true);
                currPline.removeLast();
                currIndex = queryResults.getAsInt(0);
            }
        }
        return result;
    }
}

