/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.contour;

import java.awt.geom.Point2D;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.function.BiPredicate;
import java.util.function.DoubleFunction;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jhotdraw8.base.function.Consumer3;
import org.jhotdraw8.base.function.Consumer4;
import org.jhotdraw8.base.function.Function3;
import org.jhotdraw8.collection.pair.NonNullOrderedPair;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.collection.primitive.IntArrayDeque;
import org.jhotdraw8.collection.primitive.IntArrayList;
import org.jhotdraw8.geom.AABB;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.contour.BulgeConversionFunctions;
import org.jhotdraw8.geom.contour.CoincidentSlicesResult;
import org.jhotdraw8.geom.contour.IntrPlineSegsResult;
import org.jhotdraw8.geom.contour.PlineCoincidentIntersect;
import org.jhotdraw8.geom.contour.PlineIntersect;
import org.jhotdraw8.geom.contour.PlineIntersectsResult;
import org.jhotdraw8.geom.contour.PlinePath;
import org.jhotdraw8.geom.contour.PlineSegIntrType;
import org.jhotdraw8.geom.contour.PlineVertex;
import org.jhotdraw8.geom.contour.SplitResult;
import org.jhotdraw8.geom.contour.StaticSpatialIndex;
import org.jhotdraw8.geom.contour.Utils;
import org.jhotdraw8.geom.intersect.IntersectCircleCircle;
import org.jhotdraw8.geom.intersect.IntersectCircleLine;
import org.jhotdraw8.geom.intersect.IntersectLineLine;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.icollection.immutable.ImmutableList;

public class ContourIntersections {
    public static final double REAL_THRESHOLD = 1.0E-8;

    private ContourIntersections() {
    }

    public static IntersectionResult intrCircle2Circle2(double radius1, Point2D.Double center1, double radius2, Point2D.Double center2) {
        return IntersectCircleCircle.intersectCircleCircle(center1, radius1, center2, radius2, 1.0E-8);
    }

    public static IntersectionResultEx intrLineSeg2LineSeg2(Point2D.Double u1, Point2D.Double u2, Point2D.Double v1, Point2D.Double v2) {
        return IntersectLineLine.intersectLineLineEx(u1, u2, v1, v2, 1.0E-8);
    }

    public static IntersectionResult intrLineSeg2Circle2(Point2D.Double p0, Point2D.Double p1, double radius, Point2D.Double circleCenter) {
        return IntersectCircleLine.intersectLineCircle(p0, p1, circleCenter, radius, 1.0E-8);
    }

    static CoincidentSlicesResult sortAndJoinCoincidentSlices(List<PlineCoincidentIntersect> coincidentIntrs, PlinePath pline1, PlinePath pline2) {
        Point2D.Double firstSliceBegin;
        Point2D.Double lastSliceEnd;
        CoincidentSlicesResult result = new CoincidentSlicesResult();
        if (coincidentIntrs.isEmpty()) {
            return result;
        }
        for (PlineCoincidentIntersect intr : coincidentIntrs) {
            double dist2;
            Point2D.Double sp = ((PlineVertex)pline1.get(intr.sIndex1)).pos();
            double dist1 = sp.distanceSq(intr.point1);
            if (!(dist1 > (dist2 = sp.distanceSq(intr.point2)))) continue;
            Point2D.Double swap = intr.point1;
            intr.point1 = intr.point2;
            intr.point2 = swap;
        }
        coincidentIntrs.sort((intr1, intr2) -> {
            if (intr1.sIndex1 != intr2.sIndex1) {
                return intr1.sIndex1 - intr2.sIndex1;
            }
            Point2D.Double sp = ((PlineVertex)pline1.get(intr1.sIndex1)).pos();
            double dist1 = sp.distanceSq(intr1.point1);
            double dist2 = sp.distanceSq(intr2.point1);
            return Double.compare(dist1, dist2);
        });
        Deque<PlineIntersect> sliceStartPoints = result.sliceStartPoints;
        Deque<PlineIntersect> sliceEndPoints = result.sliceEndPoints;
        Deque<PlinePath> coincidentSlices = result.coincidentSlices;
        PlinePath[] currCoincidentSlice = new PlinePath[]{new PlinePath()};
        IntConsumer startCoincidentSliceAt = intrIndex -> {
            PlineCoincidentIntersect intr = (PlineCoincidentIntersect)coincidentIntrs.get(intrIndex);
            PlineVertex v1 = (PlineVertex)pline1.get(intr.sIndex1);
            PlineVertex v2 = (PlineVertex)pline1.get(Utils.nextWrappingIndex(intr.sIndex1, pline1));
            PlineVertex u1 = (PlineVertex)pline2.get(intr.sIndex2);
            SplitResult split1 = PlineVertex.splitAtPoint(v1, v2, intr.point1);
            currCoincidentSlice[0].addVertex(split1.splitVertex);
            SplitResult split2 = PlineVertex.splitAtPoint(v1, v2, intr.point2);
            currCoincidentSlice[0].addVertex(split2.splitVertex);
            PlineIntersect sliceStart = new PlineIntersect();
            sliceStart.pos = split1.splitVertex.pos();
            sliceStart.sIndex1 = Points.almostEqual(v1.pos(), intr.point1, 1.0E-5) ? Utils.prevWrappingIndex(intr.sIndex1, pline1) : intr.sIndex1;
            sliceStart.sIndex2 = Points.almostEqual(u1.pos(), sliceStart.pos, 1.0E-5) ? Utils.prevWrappingIndex(intr.sIndex2, pline2) : intr.sIndex2;
            sliceStartPoints.add(sliceStart);
        };
        IntConsumer endCoincidentSliceAt = intrIndex -> {
            PlineCoincidentIntersect intr = (PlineCoincidentIntersect)coincidentIntrs.get(intrIndex);
            PlineVertex u1 = (PlineVertex)pline2.get(intr.sIndex2);
            coincidentSlices.add(currCoincidentSlice[0]);
            currCoincidentSlice[0] = new PlinePath();
            PlineIntersect sliceEnd = new PlineIntersect();
            sliceEnd.pos = intr.point2;
            sliceEnd.sIndex1 = intr.sIndex1;
            sliceEnd.sIndex2 = Points.almostEqual(u1.pos(), sliceEnd.pos, 1.0E-5) ? Utils.prevWrappingIndex(intr.sIndex2, pline2) : intr.sIndex2;
            sliceEndPoints.add(sliceEnd);
        };
        startCoincidentSliceAt.accept(0);
        for (int i = 1; i < coincidentIntrs.size(); ++i) {
            PlineCoincidentIntersect intr = coincidentIntrs.get(i);
            PlineVertex v1 = (PlineVertex)pline1.get(intr.sIndex1);
            PlineVertex v2 = (PlineVertex)pline1.get(Utils.nextWrappingIndex(intr.sIndex1, pline1));
            if (Points.almostEqual(intr.point1, currCoincidentSlice[0].lastVertex().pos(), 1.0E-5)) {
                currCoincidentSlice[0].removeLast();
                SplitResult split1 = PlineVertex.splitAtPoint(v1, v2, intr.point1);
                currCoincidentSlice[0].addVertex(split1.splitVertex);
                SplitResult split2 = PlineVertex.splitAtPoint(v1, v2, intr.point2);
                currCoincidentSlice[0].addVertex(split2.splitVertex);
                continue;
            }
            endCoincidentSliceAt.accept(i - 1);
            startCoincidentSliceAt.accept(i);
        }
        endCoincidentSliceAt.accept(coincidentIntrs.size() - 1);
        if (coincidentSlices.size() > 1 && Points.almostEqual(lastSliceEnd = coincidentSlices.getLast().lastVertex().pos(), firstSliceBegin = ((PlineVertex)coincidentSlices.getFirst().getFirst()).pos(), 1.0E-5)) {
            PlinePath lastSlice = coincidentSlices.getLast();
            lastSlice.removeLast();
            lastSlice.addAll(coincidentSlices.getFirst());
            sliceEndPoints.removeLast();
            sliceEndPoints.addLast(sliceEndPoints.getFirst());
            sliceEndPoints.removeFirst();
            sliceStartPoints.removeFirst();
            coincidentSlices.removeFirst();
        }
        return result;
    }

    public static void localSelfIntersects(PlinePath pline, List<PlineIntersect> output) {
        if (pline.size() < 2) {
            return;
        }
        if (pline.size() == 2) {
            if (pline.isClosed() && Points.almostEqual(((PlineVertex)pline.get(0)).bulge(), -((PlineVertex)pline.get(1)).bulge())) {
                output.add(new PlineIntersect(0, 1, ((PlineVertex)pline.get(1)).pos()));
                output.add(new PlineIntersect(1, 0, ((PlineVertex)pline.get(0)).pos()));
            }
            return;
        }
        Consumer3 testAndAddIntersect = (i, j, k) -> {
            PlineVertex v1 = (PlineVertex)pline.get((int)i);
            PlineVertex v2 = (PlineVertex)pline.get((int)j);
            PlineVertex v3 = (PlineVertex)pline.get((int)k);
            if (Points.almostEqual(v1.pos(), v2.pos(), 1.0E-5)) {
                output.add(new PlineIntersect((int)i, (int)j, v1.pos()));
            } else {
                IntrPlineSegsResult intrResult = ContourIntersections.intrPlineSegs(v1, v2, v2, v3);
                switch (intrResult.intrType) {
                    case NoIntersect: {
                        break;
                    }
                    case TangentIntersect: 
                    case OneIntersect: {
                        if (Points.almostEqual(intrResult.point1, v2.pos(), 1.0E-5)) break;
                        output.add(new PlineIntersect((int)i, (int)j, intrResult.point1));
                        break;
                    }
                    case TwoIntersects: {
                        if (!Points.almostEqual(intrResult.point1, v2.pos(), 1.0E-5)) {
                            output.add(new PlineIntersect((int)i, (int)j, intrResult.point1));
                        }
                        if (Points.almostEqual(intrResult.point2, v2.pos(), 1.0E-5)) break;
                        output.add(new PlineIntersect((int)i, (int)j, intrResult.point2));
                        break;
                    }
                    case SegmentOverlap: 
                    case ArcOverlap: {
                        output.add(new PlineIntersect((int)i, (int)j, intrResult.point1));
                    }
                }
            }
        };
        for (int i2 = 2; i2 < pline.size(); ++i2) {
            testAndAddIntersect.accept((Object)(i2 - 2), (Object)(i2 - 1), (Object)i2);
        }
        if (pline.isClosed()) {
            testAndAddIntersect.accept((Object)(pline.size() - 2), (Object)(pline.size() - 1), (Object)0);
            testAndAddIntersect.accept((Object)(pline.size() - 1), (Object)0, (Object)1);
        }
    }

    static void globalSelfIntersects(PlinePath pline, List<PlineIntersect> output, StaticSpatialIndex spatialIndex) {
        if (pline.size() < 3) {
            return;
        }
        HashSet visitedSegmentPairs = new HashSet(pline.size());
        IntArrayDeque queryStack = new IntArrayDeque(8);
        StaticSpatialIndex.Visitor visitor = (i, minX, minY, maxX, maxY) -> {
            int j = Utils.nextWrappingIndex(i, pline);
            PlineVertex v1 = (PlineVertex)pline.get(i);
            PlineVertex v2 = (PlineVertex)pline.get(j);
            IntPredicate indexVisitor = hitIndexStart -> {
                int hitIndexEnd = Utils.nextWrappingIndex(hitIndexStart, pline);
                if (i == hitIndexStart || i == hitIndexEnd || j == hitIndexStart || j == hitIndexEnd) {
                    return true;
                }
                if (visitedSegmentPairs.contains(new SimpleOrderedPair((Object)hitIndexStart, (Object)i))) {
                    return true;
                }
                visitedSegmentPairs.add(new SimpleOrderedPair((Object)i, (Object)hitIndexStart));
                PlineVertex u1 = (PlineVertex)pline.get(hitIndexStart);
                PlineVertex u2 = (PlineVertex)pline.get(hitIndexEnd);
                Predicate<Point2D.Double> intrAtStartPt = intr -> Points.almostEqual(v1.pos(), intr) || Points.almostEqual(u1.pos(), intr);
                IntrPlineSegsResult intrResult = ContourIntersections.intrPlineSegs(v1, v2, u1, u2);
                switch (intrResult.intrType) {
                    case NoIntersect: {
                        break;
                    }
                    case TangentIntersect: 
                    case OneIntersect: {
                        if (intrAtStartPt.test(intrResult.point1)) break;
                        output.add(new PlineIntersect(i, hitIndexStart, intrResult.point1));
                        break;
                    }
                    case TwoIntersects: 
                    case SegmentOverlap: 
                    case ArcOverlap: {
                        if (!intrAtStartPt.test(intrResult.point1)) {
                            output.add(new PlineIntersect(i, hitIndexStart, intrResult.point1));
                        }
                        if (intrAtStartPt.test(intrResult.point2)) break;
                        output.add(new PlineIntersect(i, hitIndexStart, intrResult.point2));
                    }
                }
                return true;
            };
            spatialIndex.visitQuery(minX - 1.0E-8, minY - 1.0E-8, maxX + 1.0E-8, maxY + 1.0E-8, indexVisitor, queryStack);
            return true;
        };
        spatialIndex.visitItemBoxes(visitor);
    }

    public static void allSelfIntersects(PlinePath pline, List<PlineIntersect> output, StaticSpatialIndex spatialIndex) {
        ContourIntersections.localSelfIntersects(pline, output);
        ContourIntersections.globalSelfIntersects(pline, output, spatialIndex);
    }

    static void findIntersects(PlinePath pline1, PlinePath pline2, StaticSpatialIndex pline1SpatialIndex, PlineIntersectsResult output) {
        IntArrayList queryResults = new IntArrayList();
        IntArrayDeque queryStack = new IntArrayDeque(8);
        HashSet possibleDuplicates = new HashSet();
        List<PlineIntersect> intrs = output.intersects;
        List<PlineCoincidentIntersect> coincidentIntrs = output.coincidentIntersects;
        BiPredicate<Integer, Integer> pline2SegVisitor = (i2, j2) -> {
            PlineVertex p2v1 = (PlineVertex)pline2.get((int)i2);
            PlineVertex p2v2 = (PlineVertex)pline2.get((int)j2);
            queryResults.clear();
            AABB bb = PlineVertex.createFastApproxBoundingBox(p2v1, p2v2);
            pline1SpatialIndex.query(bb.minX(), bb.minY(), bb.maxX(), bb.maxY(), queryResults, queryStack);
            PrimitiveIterator.OfInt ofInt = queryResults.iterator();
            while (ofInt.hasNext()) {
                int i1 = (Integer)ofInt.next();
                int j1 = Utils.nextWrappingIndex(i1, pline1);
                PlineVertex p1v1 = (PlineVertex)pline1.get(i1);
                PlineVertex p1v2 = (PlineVertex)pline1.get(j1);
                Predicate<Point2D.Double> intrAtStartPt = intr -> Points.almostEqual(p1v1.pos(), intr) || Points.almostEqual(p2v1.pos(), intr);
                IntrPlineSegsResult intrResult = ContourIntersections.intrPlineSegs(p1v1, p1v2, p2v1, p2v2);
                switch (intrResult.intrType) {
                    case NoIntersect: {
                        break;
                    }
                    case TangentIntersect: 
                    case OneIntersect: {
                        if (intrAtStartPt.test(intrResult.point1)) break;
                        intrs.add(new PlineIntersect(i1, (int)i2, intrResult.point1));
                        break;
                    }
                    case TwoIntersects: {
                        if (!intrAtStartPt.test(intrResult.point1)) {
                            intrs.add(new PlineIntersect(i1, (int)i2, intrResult.point1));
                        }
                        if (intrAtStartPt.test(intrResult.point2)) break;
                        intrs.add(new PlineIntersect(i1, (int)i2, intrResult.point2));
                        break;
                    }
                    case SegmentOverlap: 
                    case ArcOverlap: {
                        coincidentIntrs.add(new PlineCoincidentIntersect(i1, (int)i2, intrResult.point1, intrResult.point2));
                        if (Points.almostEqual(p1v1.pos(), intrResult.point1) || Points.almostEqual(p1v1.pos(), intrResult.point2)) {
                            possibleDuplicates.add(new SimpleOrderedPair((Object)Utils.prevWrappingIndex(i1, pline1), i2));
                        }
                        if (!Points.almostEqual(p2v1.pos(), intrResult.point1) && !Points.almostEqual(p2v1.pos(), intrResult.point2)) break;
                        possibleDuplicates.add(new SimpleOrderedPair((Object)i1, (Object)Utils.prevWrappingIndex(i2, pline2)));
                    }
                }
            }
            return true;
        };
        pline2.visitSegIndices(pline2SegVisitor);
        intrs.removeIf(intr -> {
            boolean found = possibleDuplicates.contains(new SimpleOrderedPair((Object)intr.sIndex1, (Object)intr.sIndex2));
            if (!found) {
                return false;
            }
            Point2D.Double endPt1 = ((PlineVertex)pline1.get(Utils.nextWrappingIndex(intr.sIndex1, pline1))).pos();
            if (Points.almostEqual(intr.pos, endPt1)) {
                return true;
            }
            Point2D.Double endPt2 = ((PlineVertex)pline2.get(Utils.nextWrappingIndex(intr.sIndex2, pline2))).pos();
            return Points.almostEqual(intr.pos, endPt2);
        });
    }

    static IntrPlineSegsResult intrPlineSegs(PlineVertex v1, PlineVertex v2, PlineVertex u1, PlineVertex u2) {
        IntrPlineSegsResult result = new IntrPlineSegsResult();
        boolean vIsLine = v1.bulgeIsZero();
        boolean uIsLine = u1.bulgeIsZero();
        Consumer4 processLineArcIntr = (p0, p1, a1, a2) -> {
            BulgeConversionFunctions.ArcRadiusAndCenter arc = BulgeConversionFunctions.arcRadiusAndCenter(a1, a2);
            IntersectionResult intrResult = ContourIntersections.intrLineSeg2Circle2(p0, p1, arc.radius, arc.center);
            DoubleFunction<NonNullOrderedPair> pointInSweep = t -> {
                if (t + 1.0E-8 < 0.0 || t > 1.00000001) {
                    return new NonNullOrderedPair((Object)false, (Object)new Point2D.Double(0.0, 0.0));
                }
                Point2D.Double p = Utils.pointFromParametric(p0, p1, t);
                boolean withinSweep = Utils.pointWithinArcSweepAngle(arc.center, a1.pos(), a2.pos(), a1.bulge(), p);
                return new NonNullOrderedPair((Object)withinSweep, (Object)p);
            };
            ImmutableList<IntersectionPoint> intersections = intrResult.intersections();
            if (intersections.isEmpty()) {
                result.intrType = PlineSegIntrType.NoIntersect;
            } else if (intersections.size() == 1) {
                NonNullOrderedPair p = pointInSweep.apply(((IntersectionPoint)intersections.getFirst()).argumentA());
                if (((Boolean)p.first()).booleanValue()) {
                    result.intrType = PlineSegIntrType.OneIntersect;
                    result.point1 = (Point2D.Double)p.second();
                } else {
                    result.intrType = PlineSegIntrType.NoIntersect;
                }
            } else {
                assert (intersections.size() == 2) : "shouldn't get here without 2 intersects";
                NonNullOrderedPair p1_ = pointInSweep.apply(((IntersectionPoint)intersections.getFirst()).argumentA());
                NonNullOrderedPair p2_ = pointInSweep.apply(((IntersectionPoint)intersections.getLast()).argumentA());
                if (((Boolean)p1_.first()).booleanValue() && ((Boolean)p2_.first()).booleanValue()) {
                    result.intrType = PlineSegIntrType.TwoIntersects;
                    result.point1 = (Point2D.Double)p1_.second();
                    result.point2 = (Point2D.Double)p2_.second();
                } else if (((Boolean)p1_.first()).booleanValue()) {
                    result.intrType = PlineSegIntrType.OneIntersect;
                    result.point1 = (Point2D.Double)p1_.second();
                } else if (((Boolean)p2_.first()).booleanValue()) {
                    result.intrType = PlineSegIntrType.OneIntersect;
                    result.point1 = (Point2D.Double)p2_.second();
                } else {
                    result.intrType = PlineSegIntrType.NoIntersect;
                }
            }
        };
        if (vIsLine && uIsLine) {
            IntersectionResultEx intrResult = ContourIntersections.intrLineSeg2LineSeg2(v1.pos(), v2.pos(), u1.pos(), u2.pos());
            ImmutableList<IntersectionPointEx> intersections = intrResult.intersections();
            switch (intrResult.getStatus()) {
                case NO_INTERSECTION_PARALLEL: 
                case NO_INTERSECTION: {
                    result.intrType = PlineSegIntrType.NoIntersect;
                    break;
                }
                case INTERSECTION: {
                    result.intrType = PlineSegIntrType.OneIntersect;
                    result.point1 = (Point2D.Double)intersections.getFirst();
                    break;
                }
                case NO_INTERSECTION_COINCIDENT: {
                    result.intrType = PlineSegIntrType.SegmentOverlap;
                    double firstB = ((IntersectionPointEx)intersections.get(0)).getArgumentB();
                    double secondB = ((IntersectionPointEx)intersections.get(1)).getArgumentB();
                    if (firstB < secondB) {
                        result.point1 = Utils.pointFromParametric(u1.pos(), u2.pos(), firstB);
                        result.point2 = Utils.pointFromParametric(u1.pos(), u2.pos(), secondB);
                        break;
                    }
                    result.point1 = Utils.pointFromParametric(u1.pos(), u2.pos(), secondB);
                    result.point2 = Utils.pointFromParametric(u1.pos(), u2.pos(), firstB);
                }
            }
        } else if (vIsLine) {
            processLineArcIntr.accept((Object)v1.pos(), (Object)v2.pos(), (Object)u1, (Object)u2);
        } else if (uIsLine) {
            processLineArcIntr.accept((Object)u1.pos(), (Object)u2.pos(), (Object)v1, (Object)v2);
        } else {
            BulgeConversionFunctions.ArcRadiusAndCenter arc1 = BulgeConversionFunctions.arcRadiusAndCenter(v1, v2);
            BulgeConversionFunctions.ArcRadiusAndCenter arc2 = BulgeConversionFunctions.arcRadiusAndCenter(u1, u2);
            Function3 startAndSweepAngle = (sp, center, bulge) -> {
                double startAngle = Utils.normalizeRadians(Utils.angle(center, sp));
                double sweepAngle = 4.0 * Math.atan(bulge);
                return new NonNullOrderedPair((Object)startAngle, (Object)sweepAngle);
            };
            Predicate<Point2D.Double> bothArcsSweepPoint = pt -> Utils.pointWithinArcSweepAngle(arc1.center, v1.pos(), v2.pos(), v1.bulge(), pt) && Utils.pointWithinArcSweepAngle(arc2.center, u1.pos(), u2.pos(), u1.bulge(), pt);
            IntersectionResult intrResult = ContourIntersections.intrCircle2Circle2(arc1.radius, arc1.center, arc2.radius, arc2.center);
            switch (intrResult.getStatus()) {
                case NO_INTERSECTION_OUTSIDE: 
                case NO_INTERSECTION_INSIDE: {
                    result.intrType = PlineSegIntrType.NoIntersect;
                    break;
                }
                case INTERSECTION: {
                    ImmutableList<IntersectionPoint> intersections = intrResult.intersections();
                    if (intersections.size() == 1) {
                        if (bothArcsSweepPoint.test((Point2D.Double)intersections.getFirst())) {
                            result.intrType = PlineSegIntrType.OneIntersect;
                            result.point1 = (Point2D.Double)intersections.getFirst();
                            break;
                        }
                        result.intrType = PlineSegIntrType.NoIntersect;
                        break;
                    }
                    assert (intersections.size() == 2) : "there must be 2 intersections";
                    boolean pt1InSweep = bothArcsSweepPoint.test((Point2D.Double)intersections.getFirst());
                    boolean pt2InSweep = bothArcsSweepPoint.test((Point2D.Double)intersections.getLast());
                    if (pt1InSweep && pt2InSweep) {
                        result.intrType = PlineSegIntrType.TwoIntersects;
                        result.point1 = (Point2D.Double)intersections.getFirst();
                        result.point2 = (Point2D.Double)intersections.getLast();
                        break;
                    }
                    if (pt1InSweep) {
                        result.intrType = PlineSegIntrType.OneIntersect;
                        result.point1 = (Point2D.Double)intersections.getFirst();
                        break;
                    }
                    if (pt2InSweep) {
                        result.intrType = PlineSegIntrType.OneIntersect;
                        result.point1 = (Point2D.Double)intersections.getLast();
                        break;
                    }
                    result.intrType = PlineSegIntrType.NoIntersect;
                    break;
                }
                case NO_INTERSECTION_COINCIDENT: {
                    NonNullOrderedPair arc1StartAndSweep = (NonNullOrderedPair)startAndSweepAngle.apply((Object)v1.pos(), (Object)arc1.center, (Object)v1.bulge());
                    NonNullOrderedPair arc2StartAndSweep = ((Supplier<NonNullOrderedPair>)() -> {
                        if (v1.bulgeIsNeg() == u1.bulgeIsNeg()) {
                            return (NonNullOrderedPair)startAndSweepAngle.apply((Object)u1.pos(), (Object)arc2.center, (Object)u1.bulge());
                        }
                        return (NonNullOrderedPair)startAndSweepAngle.apply((Object)u2.pos(), (Object)arc2.center, (Object)(-u1.bulge()));
                    }).get();
                    double arc1End = (Double)arc1StartAndSweep.first() + (Double)arc1StartAndSweep.second();
                    double arc2End = (Double)arc2StartAndSweep.first() + (Double)arc2StartAndSweep.second();
                    if (Points.almostEqual((Double)arc1StartAndSweep.first(), arc2End)) {
                        result.intrType = PlineSegIntrType.OneIntersect;
                        result.point1 = v1.pos();
                        break;
                    }
                    if (Points.almostEqual((Double)arc2StartAndSweep.first(), arc1End)) {
                        result.intrType = PlineSegIntrType.OneIntersect;
                        result.point1 = u1.pos();
                        break;
                    }
                    boolean arc2StartsInArc1Sweep = Utils.angleIsWithinSweep((Double)arc1StartAndSweep.first(), (Double)arc1StartAndSweep.second(), (Double)arc2StartAndSweep.first());
                    boolean arc2EndsInArc1Sweep = Utils.angleIsWithinSweep((Double)arc1StartAndSweep.first(), (Double)arc1StartAndSweep.second(), arc2End);
                    if (arc2StartsInArc1Sweep && arc2EndsInArc1Sweep) {
                        result.intrType = PlineSegIntrType.ArcOverlap;
                        result.point1 = u1.pos();
                        result.point2 = u2.pos();
                        break;
                    }
                    if (arc2StartsInArc1Sweep) {
                        result.intrType = PlineSegIntrType.ArcOverlap;
                        result.point1 = u1.pos();
                        result.point2 = v2.pos();
                        break;
                    }
                    if (arc2EndsInArc1Sweep) {
                        result.intrType = PlineSegIntrType.ArcOverlap;
                        result.point1 = v1.pos();
                        result.point2 = u2.pos();
                        break;
                    }
                    boolean arc1StartsInArc2Sweep = Utils.angleIsWithinSweep((Double)arc2StartAndSweep.first(), (Double)arc2StartAndSweep.second(), (Double)arc1StartAndSweep.first());
                    if (arc1StartsInArc2Sweep) {
                        result.intrType = PlineSegIntrType.ArcOverlap;
                        result.point1 = v1.pos();
                        result.point2 = v2.pos();
                        break;
                    }
                    result.intrType = PlineSegIntrType.NoIntersect;
                }
            }
        }
        return result;
    }
}

