/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.contour;

import java.awt.geom.Point2D;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jhotdraw8.base.function.Consumer4;
import org.jhotdraw8.base.function.Function3;
import org.jhotdraw8.collection.pair.OrderedPair;
import org.jhotdraw8.collection.pair.SimpleOrderedPair;
import org.jhotdraw8.geom.AABB;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.Points2D;
import org.jhotdraw8.geom.contour.BulgeConversionFunctions;
import org.jhotdraw8.geom.contour.ContourIntersections;
import org.jhotdraw8.geom.contour.IntrPlineSegsResult;
import org.jhotdraw8.geom.contour.PlineSegIntrType;
import org.jhotdraw8.geom.contour.SplitResult;
import org.jhotdraw8.geom.contour.Utils;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;

public class PlineVertex
implements Cloneable {
    private final double x;
    private final double y;
    private double bulge;

    public PlineVertex(Point2D.Double p, double bulge) {
        this(p.getX(), p.getY(), bulge);
    }

    public PlineVertex(double x, double y) {
        this(x, y, 0.0);
    }

    public PlineVertex(double x, double y, double bulge) {
        this.x = x;
        this.y = y;
        this.bulge = bulge;
    }

    public boolean bulgeIsNeg() {
        return this.bulge < 0.0;
    }

    public boolean bulgeIsPos() {
        return this.bulge > 0.0;
    }

    public boolean bulgeIsZero() {
        return this.bulgeIsZero(1.0E-5);
    }

    public boolean bulgeIsZero(double epsilon) {
        return Math.abs(this.bulge) < epsilon;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double bulge() {
        return this.bulge;
    }

    public void bulge(double bulge) {
        this.bulge = bulge;
    }

    public Point2D.Double pos() {
        return new Point2D.Double(this.x, this.y);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlineVertex that = (PlineVertex)o;
        return Double.compare(that.x, this.x) == 0 && Double.compare(that.y, this.y) == 0 && Double.compare(that.bulge, this.bulge) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.bulge);
    }

    static AABB createFastApproxBoundingBox(PlineVertex v1, PlineVertex v2) {
        double ptYMax;
        double ptYMin;
        double endPointYMax;
        double endPointYMin;
        double ptXMax;
        double ptXMin;
        double endPointXMax;
        double endPointXMin;
        if (v1.bulgeIsZero()) {
            return new AABB(Math.min(v1.getX(), v2.getX()), Math.min(v1.getY(), v2.getY()), Math.max(v1.getX(), v2.getX()), Math.max(v1.getY(), v2.getY()));
        }
        double b = v1.bulge();
        double offsX = b * (v2.getY() - v1.getY()) / 2.0;
        double offsY = -b * (v2.getX() - v1.getX()) / 2.0;
        double pt1X = v1.getX() + offsX;
        double pt2X = v2.getX() + offsX;
        double pt1Y = v1.getY() + offsY;
        double pt2Y = v2.getY() + offsY;
        if (v1.getX() < v2.getX()) {
            endPointXMin = v1.getX();
            endPointXMax = v2.getX();
        } else {
            endPointXMin = v2.getX();
            endPointXMax = v1.getX();
        }
        if (pt1X < pt2X) {
            ptXMin = pt1X;
            ptXMax = pt2X;
        } else {
            ptXMin = pt2X;
            ptXMax = pt1X;
        }
        if (v1.getY() < v2.getY()) {
            endPointYMin = v1.getY();
            endPointYMax = v2.getY();
        } else {
            endPointYMin = v2.getY();
            endPointYMax = v1.getY();
        }
        if (pt1Y < pt2Y) {
            ptYMin = pt1Y;
            ptYMax = pt2Y;
        } else {
            ptYMin = pt2Y;
            ptYMax = pt1Y;
        }
        return new AABB(Math.min(endPointXMin, ptXMin), Math.min(endPointYMin, ptYMin), Math.max(endPointXMax, ptXMax), Math.max(endPointYMax, ptYMax));
    }

    static SplitResult splitAtPoint(PlineVertex v1, PlineVertex v2, Point2D.Double point) {
        SplitResult result = new SplitResult();
        if (v1.bulgeIsZero()) {
            result.updatedStart = v1;
            result.splitVertex = new PlineVertex(point, 0.0);
        } else if (Points.almostEqual(v1.pos(), v2.pos(), 1.0E-5) || Points.almostEqual(v1.pos(), point, 1.0E-5)) {
            result.updatedStart = new PlineVertex(point, 0.0);
            result.splitVertex = new PlineVertex(point, v1.bulge());
        } else if (Points.almostEqual(v2.pos(), point, 1.0E-5)) {
            result.updatedStart = v1;
            result.splitVertex = new PlineVertex(v2.pos(), 0.0);
        } else {
            BulgeConversionFunctions.ArcRadiusAndCenter radiusAndCenter = BulgeConversionFunctions.arcRadiusAndCenter(v1, v2);
            Point2D.Double arcCenter = radiusAndCenter.center;
            double a = Utils.angle(arcCenter, point);
            double arcStartAngle = Utils.angle(arcCenter, v1.pos());
            double theta1 = Utils.deltaAngle(arcStartAngle, a);
            double bulge1 = Math.tan(theta1 / 4.0);
            double arcEndAngle = Utils.angle(arcCenter, v2.pos());
            double theta2 = Utils.deltaAngle(a, arcEndAngle);
            double bulge2 = Math.tan(theta2 / 4.0);
            result.updatedStart = new PlineVertex(v1.pos(), bulge1);
            result.splitVertex = new PlineVertex(point, bulge2);
        }
        return result;
    }

    public static double segLength(PlineVertex v1, PlineVertex v2) {
        if (Points.almostEqual(v1.pos(), v2.pos())) {
            return 0.0;
        }
        if (v1.bulgeIsZero()) {
            return v1.pos().distance(v2.pos());
        }
        BulgeConversionFunctions.ArcRadiusAndCenter arc = BulgeConversionFunctions.arcRadiusAndCenter(v1, v2);
        double startAngle = Utils.angle(arc.center, v1.pos());
        double endAngle = Utils.angle(arc.center, v2.pos());
        return Math.abs(arc.radius * Utils.deltaAngle(startAngle, endAngle));
    }

    public static Point2D.Double segMidpoint(PlineVertex v1, PlineVertex v2) {
        if (v1.bulgeIsZero()) {
            return PlineVertex.midpoint(v1.pos(), v2.pos());
        }
        BulgeConversionFunctions.ArcRadiusAndCenter arc = BulgeConversionFunctions.arcRadiusAndCenter(v1, v2);
        double a1 = Utils.angle(arc.center, v1.pos());
        double a2 = Utils.angle(arc.center, v2.pos());
        double angleOffset = Math.abs(Utils.deltaAngle(a1, a2) / 2.0);
        double midAngle = v1.bulgeIsPos() ? a1 + angleOffset : a1 - angleOffset;
        return PlineVertex.pointOnCircle(arc.radius, arc.center, midAngle);
    }

    public static Point2D.Double midpoint(Point2D.Double p0, Point2D.Double p1) {
        return new Point2D.Double((p0.getX() + p1.getX()) / 2.0, (p0.getY() + p1.getY()) / 2.0);
    }

    public static Point2D.Double pointOnCircle(double radius, Point2D.Double center, double angle) {
        return new Point2D.Double(center.getX() + radius * Math.cos(angle), center.getY() + radius * Math.sin(angle));
    }

    static Point2D.Double closestPointOnSeg(PlineVertex v1, PlineVertex v2, Point2D.Double point) {
        double dist2;
        if (v1.bulgeIsZero()) {
            return Utils.closestPointOnLineSeg(v1.pos(), v2.pos(), point);
        }
        BulgeConversionFunctions.ArcRadiusAndCenter arc = BulgeConversionFunctions.arcRadiusAndCenter(v1, v2);
        if (Points.almostEqual(point, arc.center)) {
            return v1.pos();
        }
        if (Utils.pointWithinArcSweepAngle(arc.center, v1.pos(), v2.pos(), v1.bulge(), point)) {
            Point2D.Double vToPoint = Points2D.normalize(Points2D.subtract(point, arc.center));
            return Points2D.add(Points2D.multiply(vToPoint, arc.radius), arc.center);
        }
        double dist1 = v1.pos().distanceSq(point);
        if (dist1 < (dist2 = v2.pos().distanceSq(point))) {
            return v1.pos();
        }
        return v2.pos();
    }

    IntrPlineSegsResult intrPlineSegs(PlineVertex v1, PlineVertex v2, PlineVertex u1, PlineVertex u2) {
        IntrPlineSegsResult result = new IntrPlineSegsResult();
        boolean vIsLine = v1.bulgeIsZero();
        boolean uIsLine = u1.bulgeIsZero();
        Consumer4 processLineArcIntr = (p0, p1, a1, a2) -> {
            BulgeConversionFunctions.ArcRadiusAndCenter arc = BulgeConversionFunctions.arcRadiusAndCenter(a1, a2);
            IntersectionResult intrResult = ContourIntersections.intrLineSeg2Circle2(p0, p1, arc.radius, arc.center);
            Function<Double, OrderedPair> pointInSweep = t -> {
                if (t + 1.0E-8 < 0.0 || t > 1.00000001) {
                    return new SimpleOrderedPair((Object)false, (Object)new Point2D.Double(0.0, 0.0));
                }
                Point2D.Double p = Utils.pointFromParametric(p0, p1, t);
                boolean withinSweep = Utils.pointWithinArcSweepAngle(arc.center, a1.pos(), a2.pos(), a1.bulge(), p);
                return new SimpleOrderedPair((Object)withinSweep, (Object)p);
            };
            if (intrResult.intersections().isEmpty()) {
                result.intrType = PlineSegIntrType.NoIntersect;
            } else if (intrResult.intersections().size() == 1) {
                OrderedPair p = pointInSweep.apply(((IntersectionPoint)intrResult.intersections().getFirst()).argumentA());
                if (((Boolean)p.first()).booleanValue()) {
                    result.intrType = PlineSegIntrType.OneIntersect;
                    result.point1 = (Point2D.Double)p.second();
                } else {
                    result.intrType = PlineSegIntrType.NoIntersect;
                }
            } else {
                assert (intrResult.intersections().size() == 2) : "shouldn't get here without 2 intersects";
                OrderedPair p1_ = pointInSweep.apply(((IntersectionPoint)intrResult.intersections().getFirst()).argumentA());
                OrderedPair p2_ = pointInSweep.apply(((IntersectionPoint)intrResult.intersections().getFirst()).argumentA());
                if (((Boolean)p1_.first()).booleanValue() && ((Boolean)p2_.first()).booleanValue()) {
                    result.intrType = PlineSegIntrType.TwoIntersects;
                    result.point1 = (Point2D.Double)p1_.second();
                    result.point2 = (Point2D.Double)p2_.second();
                } else if (((Boolean)p1_.first()).booleanValue()) {
                    result.intrType = PlineSegIntrType.OneIntersect;
                    result.point1 = (Point2D.Double)p1_.second();
                } else if (((Boolean)p2_.first()).booleanValue()) {
                    result.intrType = PlineSegIntrType.OneIntersect;
                    result.point1 = (Point2D.Double)p2_.second();
                } else {
                    result.intrType = PlineSegIntrType.NoIntersect;
                }
            }
        };
        if (vIsLine && uIsLine) {
            IntersectionResultEx intrResult = ContourIntersections.intrLineSeg2LineSeg2(v1.pos(), v2.pos(), u1.pos(), u2.pos());
            switch (intrResult.getStatus()) {
                case NO_INTERSECTION_PARALLEL: 
                case NO_INTERSECTION_COINCIDENT: {
                    result.intrType = PlineSegIntrType.NoIntersect;
                    break;
                }
                case INTERSECTION: {
                    result.intrType = PlineSegIntrType.OneIntersect;
                    result.point1 = (Point2D.Double)intrResult.intersections().getFirst();
                    break;
                }
                case NO_INTERSECTION: {
                    result.intrType = PlineSegIntrType.SegmentOverlap;
                    result.point1 = Utils.pointFromParametric(u1.pos(), u2.pos(), ((IntersectionPointEx)intrResult.intersections().getFirst()).argumentA());
                    result.point2 = Utils.pointFromParametric(u1.pos(), u2.pos(), ((IntersectionPointEx)intrResult.intersections().getFirst()).getArgumentB());
                }
            }
        } else if (vIsLine) {
            processLineArcIntr.accept((Object)v1.pos(), (Object)v2.pos(), (Object)u1, (Object)u2);
        } else if (uIsLine) {
            processLineArcIntr.accept((Object)u1.pos(), (Object)u2.pos(), (Object)v1, (Object)v2);
        } else {
            BulgeConversionFunctions.ArcRadiusAndCenter arc1 = BulgeConversionFunctions.arcRadiusAndCenter(v1, v2);
            BulgeConversionFunctions.ArcRadiusAndCenter arc2 = BulgeConversionFunctions.arcRadiusAndCenter(u1, u2);
            Function3 startAndSweepAngle = (sp, center, bulge) -> {
                double startAngle = Utils.normalizeRadians(Utils.angle(center, sp));
                double sweepAngle = 4.0 * Math.atan(bulge);
                return new SimpleOrderedPair((Object)startAngle, (Object)sweepAngle);
            };
            Predicate<Point2D.Double> bothArcsSweepPoint = pt -> Utils.pointWithinArcSweepAngle(arc1.center, v1.pos(), v2.pos(), v1.bulge(), pt) && Utils.pointWithinArcSweepAngle(arc2.center, u1.pos(), u2.pos(), u1.bulge(), pt);
            IntersectionResult intrResult = ContourIntersections.intrCircle2Circle2(arc1.radius, arc1.center, arc2.radius, arc2.center);
            switch (intrResult.getStatus()) {
                case NO_INTERSECTION_INSIDE: 
                case NO_INTERSECTION_OUTSIDE: {
                    result.intrType = PlineSegIntrType.NoIntersect;
                    break;
                }
                case INTERSECTION: {
                    if (intrResult.intersections().size() == 1) {
                        if (bothArcsSweepPoint.test((Point2D.Double)intrResult.intersections().getFirst())) {
                            result.intrType = PlineSegIntrType.OneIntersect;
                            result.point1 = (Point2D.Double)intrResult.intersections().getFirst();
                            break;
                        }
                        result.intrType = PlineSegIntrType.NoIntersect;
                        break;
                    }
                    assert (intrResult.intersections().size() == 2) : "there must be 2 intersections";
                    boolean pt1InSweep = bothArcsSweepPoint.test((Point2D.Double)intrResult.intersections().getFirst());
                    boolean pt2InSweep = bothArcsSweepPoint.test((Point2D.Double)intrResult.intersections().getLast());
                    if (pt1InSweep && pt2InSweep) {
                        result.intrType = PlineSegIntrType.TwoIntersects;
                        result.point1 = (Point2D.Double)intrResult.intersections().getFirst();
                        result.point2 = (Point2D.Double)intrResult.intersections().getLast();
                        break;
                    }
                    if (pt1InSweep) {
                        result.intrType = PlineSegIntrType.OneIntersect;
                        result.point1 = (Point2D.Double)intrResult.intersections().getFirst();
                        break;
                    }
                    if (pt2InSweep) {
                        result.intrType = PlineSegIntrType.OneIntersect;
                        result.point1 = (Point2D.Double)intrResult.intersections().getLast();
                        break;
                    }
                    result.intrType = PlineSegIntrType.NoIntersect;
                    break;
                }
                case NO_INTERSECTION_COINCIDENT: {
                    OrderedPair arc1StartAndSweep = (OrderedPair)startAndSweepAngle.apply((Object)v1.pos(), (Object)arc1.center, (Object)v1.bulge());
                    OrderedPair arc2StartAndSweep = v1.bulgeIsNeg() == u1.bulgeIsNeg() ? (OrderedPair)startAndSweepAngle.apply((Object)u1.pos(), (Object)arc2.center, (Object)u1.bulge()) : (OrderedPair)startAndSweepAngle.apply((Object)u2.pos(), (Object)arc2.center, (Object)(-u1.bulge()));
                    double arc1End = (Double)arc1StartAndSweep.first() + (Double)arc1StartAndSweep.second();
                    double arc2End = (Double)arc2StartAndSweep.first() + (Double)arc2StartAndSweep.second();
                    if (Points.almostEqual((Double)arc1StartAndSweep.first(), arc2End)) {
                        result.intrType = PlineSegIntrType.OneIntersect;
                        result.point1 = v1.pos();
                        break;
                    }
                    if (Points.almostEqual((Double)arc2StartAndSweep.first(), arc1End)) {
                        result.intrType = PlineSegIntrType.OneIntersect;
                        result.point1 = u1.pos();
                        break;
                    }
                    boolean arc2StartsInArc1Sweep = Utils.angleIsWithinSweep((Double)arc1StartAndSweep.first(), (Double)arc1StartAndSweep.second(), (Double)arc2StartAndSweep.first());
                    boolean arc2EndsInArc1Sweep = Utils.angleIsWithinSweep((Double)arc1StartAndSweep.first(), (Double)arc1StartAndSweep.second(), arc2End);
                    if (arc2StartsInArc1Sweep && arc2EndsInArc1Sweep) {
                        result.intrType = PlineSegIntrType.ArcOverlap;
                        result.point1 = u1.pos();
                        result.point2 = u2.pos();
                        break;
                    }
                    if (arc2StartsInArc1Sweep) {
                        result.intrType = PlineSegIntrType.ArcOverlap;
                        result.point1 = u1.pos();
                        result.point2 = v2.pos();
                        break;
                    }
                    if (arc2EndsInArc1Sweep) {
                        result.intrType = PlineSegIntrType.ArcOverlap;
                        result.point1 = v1.pos();
                        result.point2 = u2.pos();
                        break;
                    }
                    boolean arc1StartsInArc2Sweep = Utils.angleIsWithinSweep((Double)arc2StartAndSweep.first(), (Double)arc2StartAndSweep.second(), (Double)arc1StartAndSweep.first());
                    if (arc1StartsInArc2Sweep) {
                        result.intrType = PlineSegIntrType.ArcOverlap;
                        result.point1 = v1.pos();
                        result.point2 = v2.pos();
                        break;
                    }
                    result.intrType = PlineSegIntrType.NoIntersect;
                }
            }
        }
        return result;
    }

    public String toString() {
        return "PlineVertex{x=" + this.x + ", y=" + this.y + ", bulge=" + this.bulge + "}";
    }

    public PlineVertex clone() {
        try {
            return (PlineVertex)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

