/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.contour;

import java.util.function.IntPredicate;
import org.jhotdraw8.collection.primitive.IntArrayDeque;
import org.jhotdraw8.collection.primitive.IntArrayList;

public class StaticSpatialIndex {
    private final int[] m_indices;
    private final double[] m_boxes;
    private final int nodeSize;
    private final int[] m_levelBounds;
    private final int m_numItems;
    private final int m_numLevels;
    private final int m_numNodes;
    private double m_minX;
    private double m_minY;
    private double m_maxX;
    private double m_maxY;
    private int m_pos;

    public StaticSpatialIndex(int numItems) {
        this(numItems, 16);
    }

    public StaticSpatialIndex(int numItems, int nodeSize) {
        if (numItems <= 0) {
            throw new IllegalArgumentException("number of items (" + numItems + ") must be greater than 0");
        }
        if (2 > nodeSize || nodeSize > 65535) {
            throw new IllegalArgumentException("node size (" + nodeSize + ") must be between 2 and 65535");
        }
        this.nodeSize = nodeSize;
        this.m_numItems = numItems;
        int n = numItems;
        int numNodes = numItems;
        this.m_numLevels = StaticSpatialIndex.computeNumLevels(numItems, nodeSize);
        this.m_levelBounds = new int[this.m_numLevels];
        this.m_levelBounds[0] = n * 4;
        int i = 1;
        do {
            n = (int)Math.ceil((double)n / (double)nodeSize);
            this.m_levelBounds[i] = (numNodes += n) * 4;
            ++i;
        } while (n != 1);
        this.m_numNodes = numNodes;
        this.m_boxes = new double[numNodes * 4];
        this.m_indices = new int[numNodes];
        this.m_pos = 0;
        this.m_minX = Double.POSITIVE_INFINITY;
        this.m_minY = Double.POSITIVE_INFINITY;
        this.m_maxX = Double.NEGATIVE_INFINITY;
        this.m_maxY = Double.NEGATIVE_INFINITY;
    }

    static int hilbertXYToIndex(int x, int y) {
        int a = x ^ y;
        int b = 0xFFFF ^ a;
        int c = 0xFFFF ^ (x | y);
        int d = x & (y ^ 0xFFFF);
        int A = a | b >> 1;
        int B = a >> 1 ^ a;
        int C = c >> 1 ^ b & d >> 1 ^ c;
        int D = a & c >> 1 ^ d >> 1 ^ d;
        a = A;
        b = B;
        c = C;
        d = D;
        A = a & a >> 2 ^ b & b >> 2;
        B = a & b >> 2 ^ b & (a ^ b) >> 2;
        C ^= a & c >> 2 ^ b & d >> 2;
        D ^= b & c >> 2 ^ (a ^ b) & d >> 2;
        a = A;
        b = B;
        c = C;
        d = D;
        A = a & a >> 4 ^ b & b >> 4;
        B = a & b >> 4 ^ b & (a ^ b) >> 4;
        C ^= a & c >> 4 ^ b & d >> 4;
        D ^= b & c >> 4 ^ (a ^ b) & d >> 4;
        a = A;
        b = B;
        c = C;
        d = D;
        C ^= a & c >> 8 ^ b & d >> 8;
        D ^= b & c >> 8 ^ (a ^ b) & d >> 8;
        a = C ^ C >> 1;
        b = D ^ D >> 1;
        int i0 = x ^ y;
        int i1 = b | 0xFFFF ^ (i0 | a);
        i0 = (i0 | i0 << 8) & 0xFF00FF;
        i0 = (i0 | i0 << 4) & 0xF0F0F0F;
        i0 = (i0 | i0 << 2) & 0x33333333;
        i0 = (i0 | i0 << 1) & 0x55555555;
        i1 = (i1 | i1 << 8) & 0xFF00FF;
        i1 = (i1 | i1 << 4) & 0xF0F0F0F;
        i1 = (i1 | i1 << 2) & 0x33333333;
        i1 = (i1 | i1 << 1) & 0x55555555;
        return i1 << 1 | i0;
    }

    static int computeNumLevels(int numItems, int nodeSize) {
        int n = numItems;
        int levelBoundsSize = 1;
        do {
            n = (int)Math.ceil((float)n / (float)nodeSize);
            ++levelBoundsSize;
        } while (n != 1);
        return levelBoundsSize;
    }

    static void swap(int[] values, double[] boxes, int[] indices, int i, int j) {
        int temp = values[i];
        values[i] = values[j];
        values[j] = temp;
        int k = 4 * i;
        int m = 4 * j;
        double a = boxes[k];
        double b = boxes[k + 1];
        double c = boxes[k + 2];
        double d = boxes[k + 3];
        boxes[k] = boxes[m];
        boxes[k + 1] = boxes[m + 1];
        boxes[k + 2] = boxes[m + 2];
        boxes[k + 3] = boxes[m + 3];
        boxes[m] = a;
        boxes[m + 1] = b;
        boxes[m + 2] = c;
        boxes[m + 3] = d;
        int e = indices[i];
        indices[i] = indices[j];
        indices[j] = e;
    }

    double minX() {
        return this.m_minX;
    }

    double minY() {
        return this.m_minY;
    }

    double maxX() {
        return this.m_maxX;
    }

    double maxY() {
        return this.m_maxY;
    }

    public void add(double minX, double minY, double maxX, double maxY) {
        int index;
        this.m_indices[index] = index = this.m_pos >> 2;
        this.m_boxes[this.m_pos++] = minX;
        this.m_boxes[this.m_pos++] = minY;
        this.m_boxes[this.m_pos++] = maxX;
        this.m_boxes[this.m_pos++] = maxY;
        if (minX < this.m_minX) {
            this.m_minX = minX;
        }
        if (minY < this.m_minY) {
            this.m_minY = minY;
        }
        if (maxX > this.m_maxX) {
            this.m_maxX = maxX;
        }
        if (maxY > this.m_maxY) {
            this.m_maxY = maxY;
        }
    }

    public void finish() {
        int i;
        assert (this.m_pos >> 2 == this.m_numItems) : "added item count should equal static size given";
        if (this.m_numItems <= this.nodeSize) {
            this.m_indices[this.m_pos >> 2] = 0;
            this.m_boxes[this.m_pos++] = this.m_minX;
            this.m_boxes[this.m_pos++] = this.m_minY;
            this.m_boxes[this.m_pos++] = this.m_maxX;
            this.m_boxes[this.m_pos++] = this.m_maxY;
            return;
        }
        double width = this.m_maxX - this.m_minX;
        double height = this.m_maxY - this.m_minY;
        int[] hilbertValues = new int[this.m_numItems];
        int pos = 0;
        for (i = 0; i < this.m_numItems; ++i) {
            double minX = this.m_boxes[pos++];
            double minY = this.m_boxes[pos++];
            double maxX = this.m_boxes[pos++];
            double maxY = this.m_boxes[pos++];
            double hilbertMax = 65535.0;
            int hx = (int)(65535.0 * ((minX + maxX) / 2.0 - this.m_minX) / width);
            int hy = (int)(65535.0 * ((minY + maxY) / 2.0 - this.m_minY) / height);
            hilbertValues[i] = StaticSpatialIndex.hilbertXYToIndex(hx, hy);
        }
        this.sort(hilbertValues, this.m_boxes, this.m_indices, 0, this.m_numItems - 1);
        pos = 0;
        for (i = 0; i < this.m_numLevels - 1; ++i) {
            int end = this.m_levelBounds[i];
            while (pos < end) {
                double nodeMinX = Double.POSITIVE_INFINITY;
                double nodeMinY = Double.POSITIVE_INFINITY;
                double nodeMaxX = Double.NEGATIVE_INFINITY;
                double nodeMaxY = Double.NEGATIVE_INFINITY;
                int nodeIndex = pos;
                for (int j = 0; j < this.nodeSize && pos < end; ++j) {
                    double minX = this.m_boxes[pos++];
                    double minY = this.m_boxes[pos++];
                    double maxX = this.m_boxes[pos++];
                    double maxY = this.m_boxes[pos++];
                    if (minX < nodeMinX) {
                        nodeMinX = minX;
                    }
                    if (minY < nodeMinY) {
                        nodeMinY = minY;
                    }
                    if (maxX > nodeMaxX) {
                        nodeMaxX = maxX;
                    }
                    if (!(maxY > nodeMaxY)) continue;
                    nodeMaxY = maxY;
                }
                this.m_indices[this.m_pos >> 2] = nodeIndex;
                this.m_boxes[this.m_pos++] = nodeMinX;
                this.m_boxes[this.m_pos++] = nodeMinY;
                this.m_boxes[this.m_pos++] = nodeMaxX;
                this.m_boxes[this.m_pos++] = nodeMaxY;
            }
        }
    }

    void visitBoundingBoxes(Visitor visitor) {
        int nodeIndex = 4 * this.m_numNodes - 4;
        int level = this.m_numLevels - 1;
        IntArrayDeque stack = new IntArrayDeque(16);
        boolean done = false;
        while (!done) {
            int end = Math.min(nodeIndex + this.nodeSize * 4, this.m_levelBounds[level]);
            for (int pos = nodeIndex; pos < end; pos += 4) {
                int index = this.m_indices[pos >> 2];
                if (!visitor.visit(level, this.m_boxes[pos], this.m_boxes[pos + 1], this.m_boxes[pos + 2], this.m_boxes[pos + 3])) {
                    return;
                }
                if (nodeIndex < this.m_numItems * 4) continue;
                stack.pushAsInt(index);
                stack.pushAsInt(level - 1);
            }
            if (stack.size() > 1) {
                level = stack.popAsInt();
                nodeIndex = stack.popAsInt();
                continue;
            }
            done = true;
        }
    }

    void visitItemBoxes(Visitor visitor) {
        for (int i = 0; i < this.m_levelBounds[0]; i += 4) {
            if (visitor.visit(this.m_indices[i >> 2], this.m_boxes[i], this.m_boxes[i + 1], this.m_boxes[i + 2], this.m_boxes[i + 3])) continue;
            return;
        }
    }

    public void query(double minX, double minY, double maxX, double maxY, IntArrayList results) {
        IntPredicate visitor = index -> {
            results.addAsInt(index);
            return true;
        };
        this.visitQuery(minX, minY, maxX, maxY, visitor);
    }

    public void query(double minX, double minY, double maxX, double maxY, IntArrayList results, IntArrayDeque stack) {
        IntPredicate visitor = index -> {
            results.addAsInt(index);
            return true;
        };
        this.visitQuery(minX, minY, maxX, maxY, visitor, stack);
    }

    public void visitQuery(double minX, double minY, double maxX, double maxY, IntPredicate visitor) {
        IntArrayDeque stack = new IntArrayDeque(16);
        this.visitQuery(minX, minY, maxX, maxY, visitor, stack);
    }

    public void visitQuery(double minX, double minY, double maxX, double maxY, IntPredicate visitor, IntArrayDeque stack) {
        if (this.m_pos != 4 * this.m_numNodes) {
            throw new IllegalStateException("data not yet indexed - call Finish() before querying");
        }
        int nodeIndex = 4 * this.m_numNodes - 4;
        int level = this.m_numLevels - 1;
        stack.clear();
        boolean done = false;
        while (!done) {
            int end = Math.min(nodeIndex + this.nodeSize * 4, this.m_levelBounds[level]);
            for (int pos = nodeIndex; pos < end; pos += 4) {
                int index = this.m_indices[pos >> 2];
                if (maxX < this.m_boxes[pos] || maxY < this.m_boxes[pos + 1] || minX > this.m_boxes[pos + 2] || minY > this.m_boxes[pos + 3]) continue;
                if (nodeIndex < this.m_numItems * 4) {
                    boolean bl = done = !visitor.test(index);
                    if (!done) continue;
                    break;
                }
                stack.pushAsInt(index);
                stack.pushAsInt(level - 1);
            }
            if (stack.size() > 1) {
                level = stack.popAsInt();
                nodeIndex = stack.popAsInt();
                continue;
            }
            done = true;
        }
    }

    void sort(int[] values, double[] boxes, int[] indices, int left, int right) {
        assert (left <= right) : "left index should never be past right index";
        if (left / this.nodeSize >= right / this.nodeSize) {
            return;
        }
        int pivot = values[left + right >> 1];
        int i = left - 1;
        int j = right + 1;
        while (true) {
            if (values[++i] < pivot) {
                continue;
            }
            while (values[--j] > pivot) {
            }
            if (i >= j) break;
            StaticSpatialIndex.swap(values, boxes, indices, i, j);
        }
        this.sort(values, boxes, indices, left, j);
        this.sort(values, boxes, indices, j + 1, right);
    }

    @FunctionalInterface
    public static interface Visitor {
        public boolean visit(int var1, double var2, double var4, double var6, double var8);
    }
}

