/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jhotdraw8.geom.Angles;
import org.jhotdraw8.geom.Lines;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class IntersectCircleCircle {
    private IntersectCircleCircle() {
    }

    public static IntersectionResultEx intersectCircleCircleEx(Point2D c1, double r1, Point2D c2, double r2) {
        return IntersectCircleCircle.intersectCircleCircleEx(c1.getX(), c1.getY(), r1, c2.getX(), c2.getY(), r2, 1.1641532182693481E-10);
    }

    public static IntersectionResult intersectCircleCircle(Point2D c1, double r1, Point2D c2, double r2, double epsilon) {
        return IntersectCircleCircle.intersectCircleCircle(c1.getX(), c1.getY(), r1, c2.getX(), c2.getY(), r2, epsilon);
    }

    public static IntersectionResultEx intersectCircleCircleEx(double c1x, double c1y, double r1, double c2x, double c2y, double r2) {
        return IntersectCircleCircle.intersectCircleCircleEx(c1x, c1y, r1, c2x, c2y, r2, 1.1641532182693481E-10);
    }

    public static IntersectionResultEx intersectCircleCircleEx(double c1x, double c1y, double r1, double c2x, double c2y, double r2, double epsilon) {
        IntersectionStatus status;
        ArrayList<IntersectionPointEx> result = new ArrayList<IntersectionPointEx>();
        double r_max = r1 + r2;
        double r_min = Math.abs(r1 - r2);
        double c_dist = Points.distance(c1x, c1y, c2x, c2y);
        if (c_dist > r_max) {
            status = IntersectionStatus.NO_INTERSECTION_OUTSIDE;
        } else if (c_dist < r_min) {
            status = r1 < r2 ? IntersectionStatus.NO_INTERSECTION_INSIDE : IntersectionStatus.NO_INTERSECTION_OUTSIDE;
        } else if (Points.almostZero(c_dist, epsilon) && Points.almostEqual(r1, r2, epsilon)) {
            status = IntersectionStatus.NO_INTERSECTION_COINCIDENT;
        } else {
            status = IntersectionStatus.INTERSECTION;
            double a = (r1 * r1 - r2 * r2 + c_dist * c_dist) / (2.0 * c_dist);
            double h = Math.sqrt(r1 * r1 - a * a);
            Point2D.Double p = Lines.lerp(c1x, c1y, c2x, c2y, a / c_dist);
            double b = h / c_dist;
            double dy = c2y - c1y;
            double dx = c2x - c1x;
            double p1x = p.getX() - b * dy;
            double p1y = p.getY() + b * dx;
            result.add(new IntersectionPointEx(new Point2D.Double(p1x, p1y), Angles.atan2(p1y - c1y, p1x - c1x), Angles.perp(p1x - c1x, p1y - c1y), Angles.atan2(p1y - c2y, p1x - c2x), Angles.perp(p1x - c2x, p1y - c2y)));
            double p2x = p.getX() + b * dy;
            double p2y = p.getY() - b * dx;
            if (!Points.almostEqual(c_dist, r_max, epsilon)) {
                result.add(new IntersectionPointEx(new Point2D.Double(p2x, p2y), Angles.atan2(p2y - c1y, p2x - c1x), Angles.perp(p2x - c1x, p2y - c1y), Angles.atan2(p2y - c2y, p2x - c2x), Angles.perp(p2x - c2x, p2y - c2y)));
            }
        }
        return new IntersectionResultEx(status, result);
    }

    public static IntersectionResult intersectCircleCircle(double c1x, double c1y, double r1, double c2x, double c2y, double r2, double epsilon) {
        IntersectionStatus status;
        ArrayList<IntersectionPoint> result = new ArrayList<IntersectionPoint>();
        double r_max = r1 + r2;
        double r_min = Math.abs(r1 - r2);
        double c_distSq = Points.squaredDistance(c1x, c1y, c2x, c2y);
        double c_dist = Math.sqrt(c_distSq);
        if (c_dist > r_max) {
            status = IntersectionStatus.NO_INTERSECTION_OUTSIDE;
        } else if (c_dist < r_min) {
            status = r1 < r2 ? IntersectionStatus.NO_INTERSECTION_INSIDE : IntersectionStatus.NO_INTERSECTION_OUTSIDE;
        } else if (Points.almostZero(c_dist, epsilon) && Points.almostEqual(r1, r2, epsilon)) {
            status = IntersectionStatus.NO_INTERSECTION_COINCIDENT;
        } else {
            status = IntersectionStatus.INTERSECTION;
            double a = (r1 * r1 - r2 * r2 + c_distSq) / (2.0 * c_dist);
            double h = Math.sqrt(r1 * r1 - a * a);
            Point2D.Double p = Lines.lerp(c1x, c1y, c2x, c2y, a / c_dist);
            double b = h / c_dist;
            double dy = c2y - c1y;
            double dx = c2x - c1x;
            double p1x = p.getX() - b * dy;
            double p1y = p.getY() + b * dx;
            result.add(new IntersectionPoint(p1x, p1y, Angles.atan2(p1y - c1y, p1x - c1x)));
            double p2x = p.getX() + b * dy;
            double p2y = p.getY() - b * dx;
            if (!Points.almostEqual(c_dist, r_max, epsilon)) {
                result.add(new IntersectionPoint(p2x, p2y, Angles.atan2(p2y - c1y, p2x - c1x)));
            }
        }
        return new IntersectionResult(status, result);
    }
}

