/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jhotdraw8.geom.Angles;
import org.jhotdraw8.geom.CubicCurves;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.intersect.IntersectCubicCurveEllipse;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;

public class IntersectCircleCubicCurve {
    private IntersectCircleCubicCurve() {
    }

    public static IntersectionResult intersectCubicCurveCircle(Point2D p0, Point2D p1, Point2D p2, Point2D p3, Point2D c, double r) {
        return IntersectCubicCurveEllipse.intersectCubicCurveEllipse(p0, p1, p2, p3, c, r, r);
    }

    public static IntersectionResult intersectCubicCurveCircle(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3, double cx, double cy, double r) {
        return IntersectCubicCurveEllipse.intersectCubicCurveEllipse(x0, y0, x1, y1, x2, y2, x3, y3, cx, cy, r, r);
    }

    public static IntersectionResult intersectCubicCurveCircle(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3, double cx, double cy, double r, double epsilon) {
        return IntersectCubicCurveEllipse.intersectCubicCurveEllipse(x0, y0, x1, y1, x2, y2, x3, y3, cx, cy, r, r, epsilon);
    }

    public static IntersectionResultEx intersectCubicCurveCircleEx(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3, double cx, double cy, double r) {
        return IntersectCircleCubicCurve.intersectCubicCurveCircleEx(x0, y0, x1, y1, x2, y2, x3, y3, cx, cy, r, 1.0E-8);
    }

    public static IntersectionResultEx intersectCubicCurveCircleEx(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3, double cx, double cy, double r, double epsilon) {
        IntersectionResult result = IntersectCircleCubicCurve.intersectCubicCurveCircle(x0, y0, x1, y1, x2, y2, x3, y3, cx, cy, r, epsilon);
        ArrayList<IntersectionPointEx> list = new ArrayList<IntersectionPointEx>();
        for (IntersectionPoint ip : result.intersections()) {
            double x = ip.getX();
            double y = ip.getY();
            PointAndDerivative pdA = CubicCurves.eval(x0, y0, x1, y1, x2, y2, x3, y3, ip.argumentA());
            list.add(new IntersectionPointEx(x, y, ip.argumentA(), pdA.dx(), pdA.dy(), Angles.atan2(y - cy, x - cx), y - cy, cx - x));
        }
        return new IntersectionResultEx(result.getStatus(), list);
    }
}

