/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.jhotdraw8.geom.intersect.IntersectAABBLine;
import org.jhotdraw8.geom.intersect.IntersectCircleLine;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;
import org.jhotdraw8.geom.intersect.Intersections;

public class IntersectCircleRectangle {
    private IntersectCircleRectangle() {
    }

    public static IntersectionResultEx intersectLineRectangleEx(Point2D a0, Point2D a1, Point2D r0, Point2D r1) {
        return IntersectAABBLine.intersectLineAABBEx(a0, a1, Math.min(r0.getX(), r1.getX()), Math.min(r0.getY(), r1.getY()), Math.max(r0.getX(), r1.getX()), Math.max(r0.getY(), r1.getY()));
    }

    public static IntersectionResultEx intersectLineRectangleEx(Point2D a0, Point2D a1, Rectangle2D.Double r) {
        return IntersectAABBLine.intersectLineAABBEx(a0, a1, r.getMinX(), r.getMinY(), r.getMaxX(), r.getMaxY());
    }

    public static IntersectionResultEx intersectRectangleLineEx(Rectangle2D.Double r, Point2D a0, Point2D a1) {
        return IntersectAABBLine.intersectAABBLineEx(r.getMinX(), r.getMinY(), r.getMaxX(), r.getMaxY(), a0, a1);
    }

    public static IntersectionResultEx intersectCircleRectangleEx(double c1x, double c1y, double r1, double x, double y, double w, double h) {
        return IntersectCircleRectangle.intersectCircleRectangleEx(new Point2D.Double(c1x, c1y), r1, new Point2D.Double(x, y), new Point2D.Double(x + w, y + h));
    }

    public static IntersectionResultEx intersectCircleRectangleEx(Point2D c, double r, Point2D r0, Point2D r1) {
        Point2D.Double topLeft = Intersections.topLeft(r0, r1);
        Point2D.Double bottomRight = Intersections.bottomRight(r0, r1);
        Point2D.Double topRight = new Point2D.Double(bottomRight.getX(), topLeft.getY());
        Point2D.Double bottomLeft = new Point2D.Double(topLeft.getX(), bottomRight.getY());
        IntersectionResultEx inter1 = IntersectCircleLine.intersectCircleLineEx(c, r, topLeft, topRight);
        IntersectionResultEx inter2 = IntersectCircleLine.intersectCircleLineEx(c, r, topRight, bottomRight);
        IntersectionResultEx inter3 = IntersectCircleLine.intersectCircleLineEx(c, r, bottomRight, bottomLeft);
        IntersectionResultEx inter4 = IntersectCircleLine.intersectCircleLineEx(c, r, bottomLeft, topLeft);
        ArrayList<IntersectionPointEx> result = new ArrayList<IntersectionPointEx>();
        result.addAll(inter1.intersections().asList());
        result.addAll(inter2.intersections().asList());
        result.addAll(inter3.intersections().asList());
        result.addAll(inter4.intersections().asList());
        IntersectionStatus status = !result.isEmpty() ? IntersectionStatus.INTERSECTION : inter1.getStatus();
        return new IntersectionResultEx(status, result);
    }
}

