/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jhotdraw8.geom.CubicCurves;
import org.jhotdraw8.geom.Lines;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.Points2D;
import org.jhotdraw8.geom.Polynomial;
import org.jhotdraw8.geom.intersect.IntersectLinePoint;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;
import org.jhotdraw8.geom.intersect.Intersections;

public class IntersectCubicCurveLine {
    private IntersectCubicCurveLine() {
    }

    public static IntersectionResult intersectCubicCurveLine(double a0x, double a0y, double a1x, double a1y, double a2x, double a2y, double a3x, double a3y, double b0x, double b0y, double b1x, double b1y, double epsilon) {
        return IntersectCubicCurveLine.intersectCubicCurveLine(new Point2D.Double(a0x, a0y), new Point2D.Double(a1x, a1y), new Point2D.Double(a2x, a2y), new Point2D.Double(a3x, a3y), new Point2D.Double(b0x, b0y), new Point2D.Double(b1x, b1y), epsilon);
    }

    public static IntersectionResult intersectCubicCurveLine(Point2D a0, Point2D a1, Point2D a2, Point2D a3, Point2D b0, Point2D b1) {
        return IntersectCubicCurveLine.intersectCubicCurveLine(a0, a1, a2, a3, b0, b1, 1.0E-8);
    }

    public static IntersectionResult intersectCubicCurveLine(Point2D p0, Point2D p1, Point2D p2, Point2D p3, Point2D a0, Point2D a1, double epsilon) {
        Point2D.Double topLeft = Intersections.topLeft(a0, a1);
        Point2D.Double bottomRight = Intersections.bottomRight(a0, a1);
        ArrayList<IntersectionPoint> result = new ArrayList<IntersectionPoint>();
        Point2D.Double c3 = Points2D.sum(Points2D.multiply(p0, -1.0), Points2D.multiply(p1, 3.0), Points2D.multiply(p2, -3.0), p3);
        Point2D.Double c2 = Points2D.sum(Points2D.multiply(p0, 3.0), Points2D.multiply(p1, -6.0), Points2D.multiply(p2, 3.0));
        Point2D.Double c1 = Points2D.add(Points2D.multiply(p0, -3.0), Points2D.multiply(p1, 3.0));
        Point2D c0 = p0;
        double a0y = a0.getY();
        double a1y = a1.getY();
        double a1x = a1.getX();
        double a0x = a0.getX();
        Point2D.Double n = new Point2D.Double(a0y - a1y, a1x - a0x);
        double cl = a0x * a1y - a1x * a0y;
        double[] roots = new Polynomial(Points2D.dotProduct(n, c3), Points2D.dotProduct(n, c2), Points2D.dotProduct(n, c1), Points2D.dotProduct(n, c0) + cl).getRoots();
        IntersectionStatus status = IntersectionStatus.NO_INTERSECTION;
        for (double t : roots) {
            if (!(0.0 <= t) || !(t <= 1.0)) continue;
            Point2D.Double p5 = Lines.lerp(p0, p1, t);
            Point2D.Double p6 = Lines.lerp(p1, p2, t);
            Point2D.Double p7 = Lines.lerp(p2, p3, t);
            Point2D.Double p8 = Lines.lerp(p5, p6, t);
            Point2D.Double p9 = Lines.lerp(p6, p7, t);
            Point2D.Double p10 = Lines.lerp(p8, p9, t);
            if (Points.almostEqual(a0x, a1x, epsilon)) {
                if (!(topLeft.getY() <= p10.getY()) || !(p10.getY() <= bottomRight.getY())) continue;
                status = IntersectionStatus.INTERSECTION;
                result.add(new IntersectionPoint(p10, t));
                continue;
            }
            if (Points.almostEqual(a0y, a1y, epsilon)) {
                if (!(topLeft.getX() <= p10.getX()) || !(p10.getX() <= bottomRight.getX())) continue;
                status = IntersectionStatus.INTERSECTION;
                result.add(new IntersectionPoint(p10, t));
                continue;
            }
            if (!Intersections.gte(p10, topLeft) || !Intersections.lte(p10, bottomRight)) continue;
            status = IntersectionStatus.INTERSECTION;
            result.add(new IntersectionPoint(p10, t));
        }
        return new IntersectionResult(status, result);
    }

    public static IntersectionResultEx intersectCubicCurveLineEx(double a0x, double a0y, double a1x, double a1y, double a2x, double a2y, double a3x, double a3y, double b0x, double b0y, double b1x, double b1y, double epsilon) {
        IntersectionResult result = IntersectCubicCurveLine.intersectCubicCurveLine(a0x, a0y, a1x, a1y, a2x, a2y, a3x, a3y, b0x, b0y, b1x, b1y, epsilon);
        ArrayList<IntersectionPointEx> list = new ArrayList<IntersectionPointEx>();
        for (IntersectionPoint ip : result.intersections()) {
            double x = ip.getX();
            double y = ip.getY();
            PointAndDerivative pdA = CubicCurves.eval(a0x, a0y, a1x, a1y, a2x, a2y, a3x, a3y, ip.argumentA());
            list.add(new IntersectionPointEx(x, y, ip.argumentA(), pdA.dx(), pdA.dy(), IntersectLinePoint.argumentOnLine(b0x, b0y, b1x, b1y, x, y), b1x - b0x, b1y - b0y));
        }
        return new IntersectionResultEx(result.getStatus(), list);
    }

    public static IntersectionResultEx intersectCubicCurveLineEx(double a0x, double a0y, double a1x, double a1y, double a2x, double a2y, double a3x, double a3y, double b0x, double b0y, double b1x, double b1y) {
        return IntersectCubicCurveLine.intersectCubicCurveLineEx(a0x, a0y, a1x, a1y, a2x, a2y, a3x, a3y, b0x, b0y, b1x, b1y, 1.0E-8);
    }
}

