/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.PrimitiveIterator;
import org.jhotdraw8.collection.primitive.DoubleArrayList;
import org.jhotdraw8.geom.CubicCurves;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.Points2D;
import org.jhotdraw8.geom.Polynomial;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class IntersectCubicCurvePoint {
    private IntersectCubicCurvePoint() {
    }

    public static IntersectionResultEx intersectCubicCurvePointEx(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3, double cx, double cy) {
        return IntersectCubicCurvePoint.intersectCubicCurvePointEx(x0, y0, x1, y1, x2, y2, x3, y3, cx, cy, 1.0E-8);
    }

    public static IntersectionResultEx intersectCubicCurvePointEx(double a0x, double a0y, double a1x, double a1y, double a2x, double a2y, double a3x, double a3y, double cx, double cy, double epsilon) {
        IntersectionResult result = IntersectCubicCurvePoint.intersectCubicCurvePoint(a0x, a0y, a1x, a1y, a2x, a2y, a3x, a3y, cx, cy, epsilon);
        ArrayList<IntersectionPointEx> list = new ArrayList<IntersectionPointEx>();
        for (IntersectionPoint ip : result.intersections()) {
            double x = ip.getX();
            double y = ip.getY();
            PointAndDerivative pdA = CubicCurves.eval(a0x, a0y, a1x, a1y, a2x, a2y, a3x, a3y, ip.argumentA());
            list.add(new IntersectionPointEx(x, y, ip.argumentA(), pdA.dx(), pdA.dy(), 0.0, 1.0, 0.0));
        }
        return new IntersectionResultEx(result.getStatus(), list);
    }

    public static IntersectionResult intersectCubicCurvePoint(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3, double cx, double cy, double epsilon) {
        double c3x = -(x0 - 3.0 * x1 + 3.0 * x2 - x3);
        double c3y = -(y0 - 3.0 * y1 + 3.0 * y2 - y3);
        double c2x = 3.0 * (x0 - 2.0 * x1 + x2);
        double c2y = 3.0 * (y0 - 2.0 * y1 + y2);
        double c1x = -3.0 * (x0 - x1);
        double c1y = -3.0 * (y0 - y1);
        double c0x = x0;
        double c0y = y0;
        double a = c3x * c3x + c3y * c3y;
        double b = 2.0 * (c2x * c3x + c2y * c3y);
        double c = c2x * c2x + c2y * c2y + 2.0 * c1x * c3x + 2.0 * c1y * c3y;
        double d = 2.0 * (c1x * c2x + c1y * c2y + c0x * c3x + c0y * c3y - c3x * cx - c3y * cy);
        double e = c1x * c1x + c1y * c1y + 2.0 * c0x * c2x + 2.0 * c0y * c2y - 2.0 * c2x * cx - 2.0 * c2y * cy;
        double f = 2.0 * (c0x * c1x + c0y * c1y - c1x * cx - c1y * cy);
        DoubleArrayList clampedRoots = new Polynomial(6.0 * a, 5.0 * b, 4.0 * c, 3.0 * d, 2.0 * e, f).getRootsInInterval(0.0, 1.0);
        DoubleArrayList roots = new DoubleArrayList();
        roots.addAll((Collection)clampedRoots);
        roots.add(Double.valueOf(0.0));
        roots.add(Double.valueOf(1.0));
        ArrayList<IntersectionPoint> result = new ArrayList<IntersectionPoint>();
        Point2D.Double p0 = new Point2D.Double(x0, y0);
        Point2D.Double p1 = new Point2D.Double(x1, y1);
        Point2D.Double p2 = new Point2D.Double(x2, y2);
        Point2D.Double p3 = new Point2D.Double(x3, y3);
        double rr = epsilon * epsilon;
        double bestDistance = Double.POSITIVE_INFINITY;
        PrimitiveIterator.OfDouble ofDouble = roots.iterator();
        while (ofDouble.hasNext()) {
            double t = (Double)ofDouble.next();
            Point2D[] point2DArray = new Point2D[]{Points2D.multiply(p2, 3.0 * (1.0 - t) * t * t), Points2D.multiply(p3, t * t * t)};
            Point2D.Double p = Points2D.sum(Points2D.multiply(p0, (1.0 - t) * (1.0 - t) * (1.0 - t)), Points2D.multiply(p1, 3.0 * (1.0 - t) * (1.0 - t) * t), point2DArray);
            double dd = (p.getX() - cx) * (p.getX() - cx) + (p.getY() - cy) * (p.getY() - cy);
            if (!(dd < rr)) continue;
            if (Math.abs(dd - bestDistance) < 1.0E-8) {
                result.add(new IntersectionPoint(p, t));
                continue;
            }
            if (!(dd < bestDistance)) continue;
            bestDistance = dd;
            result.clear();
            result.add(new IntersectionPoint(p, t));
        }
        return new IntersectionResult(result.isEmpty() ? IntersectionStatus.NO_INTERSECTION : IntersectionStatus.INTERSECTION, result);
    }
}

