/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jhotdraw8.geom.AABB;
import org.jhotdraw8.geom.Angles;
import org.jhotdraw8.geom.Lines;
import org.jhotdraw8.geom.Points2D;
import org.jhotdraw8.geom.intersect.IntersectLinePoint;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class IntersectEllipseLine {
    private IntersectEllipseLine() {
    }

    public static IntersectionResult intersectEllipseLine(Point2D ac, double arx, double ary, Point2D b0, Point2D b1) {
        IntersectionResult result = IntersectEllipseLine.intersectLineEllipse(b0, b1, ac, arx, ary);
        ArrayList<IntersectionPoint> list = new ArrayList<IntersectionPoint>();
        for (IntersectionPoint ip : result.intersections()) {
            double x = ip.getX();
            double y = ip.getY();
            list.add(new IntersectionPoint(x, y, Angles.atan2Ellipse(ac.getX(), ac.getY(), arx, ary, x, y)));
        }
        return new IntersectionResult(result.getStatus(), list);
    }

    public static IntersectionResultEx intersectEllipseLineEx(Point2D ac, double arx, double ary, Point2D b0, Point2D b1) {
        return IntersectEllipseLine.intersectEllipseLineEx(ac.getX(), ac.getY(), arx, ary, b0.getX(), b0.getY(), b1.getX(), b1.getY());
    }

    public static IntersectionResult intersectEllipseLine(double acx, double acy, double arx, double ary, double b0x, double b0y, double b1x, double b1y) {
        return IntersectEllipseLine.intersectEllipseLine(acx, acy, arx, ary, b0x, b0y, b1x, b1y, 1.0E-8);
    }

    public static IntersectionResultEx intersectEllipseLineEx(double acx, double acy, double arx, double ary, double b0x, double b0y, double b1x, double b1y) {
        return IntersectEllipseLine.intersectEllipseLineEx(acx, acy, arx, ary, b0x, b0y, b1x, b1y, 1.0E-8);
    }

    public static IntersectionResultEx intersectEllipseLineEx(double acx, double acy, double arx, double ary, double b0x, double b0y, double b1x, double b1y, double epsilon) {
        IntersectionResult result = IntersectEllipseLine.intersectEllipseLine(acx, acy, arx, ary, b0x, b0y, b1x, b1y, epsilon);
        ArrayList<IntersectionPointEx> list = new ArrayList<IntersectionPointEx>();
        for (IntersectionPoint ip : result.intersections()) {
            double x = ip.getX();
            double y = ip.getY();
            list.add(new IntersectionPointEx(x, y, ip.argumentA(), y - acy, acx - x, IntersectLinePoint.argumentOnLine(b0x, b0y, b1x, b1y, x, y), b1x - b0x, b1y - b0y));
        }
        return new IntersectionResultEx(result.getStatus(), list);
    }

    public static IntersectionResult intersectEllipseLine(double cx, double cy, double rx, double ry, double x0, double y0, double x1, double y1, double epsilon) {
        IntersectionResult result = IntersectEllipseLine.intersectLineEllipse(x0, y0, x1, y1, cx, cy, rx, ry, epsilon);
        return result;
    }

    public static IntersectionResult intersectLineEllipse(Point2D a0, Point2D a1, AABB e) {
        double rx = e.width() * 0.5;
        double ry = e.height() * 0.5;
        return IntersectEllipseLine.intersectLineEllipse(a0, a1, new Point2D.Double(e.minX() + rx, e.minY() + ry), rx, ry);
    }

    public static IntersectionResult intersectLineEllipse(Point2D a0, Point2D a1, Point2D ec, double rx, double ry) {
        return IntersectEllipseLine.intersectLineEllipse(a0.getX(), a0.getY(), a1.getX(), a1.getY(), ec.getX(), ec.getY(), rx, ry, 1.0E-8);
    }

    public static IntersectionResult intersectLineEllipse(double x0, double y0, double x1, double y1, double cx, double cy, double rx, double ry, double epsilon) {
        ArrayList<IntersectionPoint> result = new ArrayList<IntersectionPoint>();
        Point2D.Double origin = new Point2D.Double(x0, y0);
        Point2D.Double dir = Points2D.subtract(x1, y1, x0, y0);
        Point2D.Double center = new Point2D.Double(cx, cy);
        Point2D.Double diff = Points2D.subtract(origin, center);
        Point2D.Double mDir = new Point2D.Double(dir.getX() / (rx * rx), dir.getY() / (ry * ry));
        Point2D.Double mDiff = new Point2D.Double(diff.getX() / (rx * rx), diff.getY() / (ry * ry));
        double a = Points2D.dotProduct(dir, mDir);
        double b = Points2D.dotProduct(dir, mDiff);
        double c = Points2D.dotProduct(diff, mDiff) - 1.0;
        double d = b * b - a * c;
        IntersectionStatus status = IntersectionStatus.NO_INTERSECTION;
        if (d < -epsilon) {
            status = IntersectionStatus.NO_INTERSECTION_OUTSIDE;
        } else if (d > 0.0) {
            double root = Math.sqrt(d);
            double t0 = (-b - root) / a;
            double t1 = (-b + root) / a;
            if ((t0 < 0.0 || 1.0 < t0) && (t1 < 0.0 || 1.0 < t1)) {
                status = t0 < 0.0 && t1 < 0.0 || t0 > 1.0 && t1 > 1.0 ? IntersectionStatus.NO_INTERSECTION_OUTSIDE : IntersectionStatus.NO_INTERSECTION_INSIDE;
            } else {
                status = IntersectionStatus.INTERSECTION;
                if (0.0 <= t0 && t0 <= 1.0) {
                    result.add(new IntersectionPoint(Lines.lerp(x0, y0, x1, y1, t0), t0));
                }
                if (0.0 <= t1 && t1 <= 1.0) {
                    result.add(new IntersectionPoint(Lines.lerp(x0, y0, x1, y1, t1), t1));
                }
            }
        } else {
            double t = -b / a;
            if (0.0 <= t && t <= 1.0) {
                status = IntersectionStatus.INTERSECTION;
                result.add(new IntersectionPoint(Lines.lerp(x0, y0, x1, y1, t), t));
            } else {
                status = IntersectionStatus.NO_INTERSECTION_OUTSIDE;
            }
        }
        return new IntersectionResult(status, result);
    }

    public static IntersectionResultEx intersectLineEllipseEx(double x0, double y0, double x1, double y1, double cx, double cy, double rx, double ry) {
        return IntersectEllipseLine.intersectLineEllipseEx(x0, y0, x1, y1, cx, cy, rx, ry, 1.0E-8);
    }

    public static IntersectionResultEx intersectLineEllipseEx(double x0, double y0, double x1, double y1, double cx, double cy, double rx, double ry, double epsilon) {
        IntersectionResult result = IntersectEllipseLine.intersectLineEllipse(x0, y0, x1, y1, cx, cy, rx, ry, epsilon);
        double atx = x1 - x0;
        double aty = y1 - y0;
        ArrayList<IntersectionPointEx> list = new ArrayList<IntersectionPointEx>();
        for (IntersectionPoint ip : result.intersections()) {
            double barg = Angles.atan2Ellipse(cx, cy, rx, ry, ip.getX(), ip.getY());
            list.add(new IntersectionPointEx(ip.getX(), ip.getY(), ip.argumentA(), atx, aty, barg, ip.getY() - cy, cx - ip.getX()));
        }
        return new IntersectionResultEx(result.getStatus(), list);
    }
}

