/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jhotdraw8.geom.intersect.IntersectEllipseLine;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.Intersections;

public class IntersectEllipseRectangle {
    private IntersectEllipseRectangle() {
    }

    public static IntersectionResult intersectEllipseRectangle(Point2D c, double rx, double ry, Point2D r1, Point2D r2) {
        Point2D.Double topLeft = Intersections.topLeft(r1, r2);
        Point2D.Double bottomRight = Intersections.bottomRight(r1, r2);
        Point2D.Double topRight = new Point2D.Double(bottomRight.getX(), topLeft.getY());
        Point2D.Double bottomLeft = new Point2D.Double(topLeft.getX(), bottomRight.getY());
        IntersectionResult inter1 = IntersectEllipseLine.intersectEllipseLine(c, rx, ry, topLeft, topRight);
        IntersectionResult inter2 = IntersectEllipseLine.intersectEllipseLine(c, rx, ry, topRight, bottomRight);
        IntersectionResult inter3 = IntersectEllipseLine.intersectEllipseLine(c, rx, ry, bottomRight, bottomLeft);
        IntersectionResult inter4 = IntersectEllipseLine.intersectEllipseLine(c, rx, ry, bottomLeft, topLeft);
        ArrayList result = new ArrayList();
        result.addAll(inter1.intersections().asList());
        result.addAll(inter2.intersections().asList());
        result.addAll(inter3.intersections().asList());
        result.addAll(inter4.intersections().asList());
        return new IntersectionResult(result);
    }

    public static IntersectionResultEx intersectEllipseRectangleEx(Point2D c, double rx, double ry, Point2D r1, Point2D r2) {
        Point2D.Double topLeft = Intersections.topLeft(r1, r2);
        Point2D.Double bottomRight = Intersections.bottomRight(r1, r2);
        Point2D.Double topRight = new Point2D.Double(bottomRight.getX(), topLeft.getY());
        Point2D.Double bottomLeft = new Point2D.Double(topLeft.getX(), bottomRight.getY());
        IntersectionResultEx inter1 = IntersectEllipseLine.intersectEllipseLineEx(c, rx, ry, topLeft, topRight);
        IntersectionResultEx inter2 = IntersectEllipseLine.intersectEllipseLineEx(c, rx, ry, topRight, bottomRight);
        IntersectionResultEx inter3 = IntersectEllipseLine.intersectEllipseLineEx(c, rx, ry, bottomRight, bottomLeft);
        IntersectionResultEx inter4 = IntersectEllipseLine.intersectEllipseLineEx(c, rx, ry, bottomLeft, topLeft);
        ArrayList<IntersectionPointEx> result = new ArrayList<IntersectionPointEx>();
        result.addAll(inter1.intersections().asList());
        result.addAll(inter2.intersections().asList());
        result.addAll(inter3.intersections().asList());
        result.addAll(inter4.intersections().asList());
        return new IntersectionResultEx(result);
    }
}

