/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.intersect.IntersectLineCubicCurve;
import org.jhotdraw8.geom.intersect.IntersectLineLine;
import org.jhotdraw8.geom.intersect.IntersectLineQuadCurve;
import org.jhotdraw8.geom.intersect.IntersectRayCubicCurve;
import org.jhotdraw8.geom.intersect.IntersectRayLine;
import org.jhotdraw8.geom.intersect.IntersectRayQuadCurve;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class IntersectLinePathIterator {
    private IntersectLinePathIterator() {
    }

    public static IntersectionResultEx intersectLinePathIteratorEx(double a0x, double a0y, double a1x, double a1y, PathIterator pit) {
        return IntersectLinePathIterator.intersectLinePathIteratorEx(a0x, a0y, a1x, a1y, pit, 1.0);
    }

    public static IntersectionResultEx intersectLinePathIteratorEx(Point2D a0, Point2D a1, PathIterator pit, double maxT) {
        return IntersectLinePathIterator.intersectLinePathIteratorEx(a0.getX(), a0.getY(), a1.getX(), a1.getY(), pit, maxT);
    }

    public static IntersectionResultEx intersectLinePathIteratorEx(double a0x, double a0y, double a1x, double a1y, PathIterator pit, double maxT) {
        ArrayList<IntersectionPointEx> lineIntersections = new ArrayList<IntersectionPointEx>();
        ArrayList<IntersectionPointEx> insideIntersections = new ArrayList<IntersectionPointEx>();
        double[] coords = new double[6];
        double firstX = 0.0;
        double firstY = 0.0;
        double lastX = 0.0;
        double lastY = 0.0;
        int clockwiseCrossingsSum = 0;
        int counterClockwiseCrossingsSum = 0;
        int clockwiseCrossings = 0;
        int counterClockwiseCrossings = 0;
        int segment = 0;
        int windingRule = pit.getWindingRule();
        while (!pit.isDone()) {
            IntersectionResultEx rayCheck;
            IntersectionResultEx boundaryCheck;
            int type = pit.currentSegment(coords);
            switch (type) {
                case 4: {
                    boundaryCheck = IntersectLineLine.intersectLineLineEx(a0x, a0y, a1x, a1y, lastX, lastY, firstX, firstY);
                    rayCheck = IntersectRayLine.intersectRayLineEx(a0x, a0y, 1.0, 0.0, Double.MAX_VALUE, lastX, lastY, firstX, firstY, 1.0E-8);
                    break;
                }
                case 3: {
                    double x = coords[4];
                    double y = coords[5];
                    boundaryCheck = IntersectLineCubicCurve.intersectLineCubicCurveEx(a0x, a0y, a1x, a1y, lastX, lastY, coords[0], coords[1], coords[2], coords[3], x, y);
                    rayCheck = IntersectRayCubicCurve.intersectRayCubicCurveEx(a0x, a0y, 1.0, 0.0, Double.MAX_VALUE, lastX, lastY, coords[0], coords[1], coords[2], coords[3], x, y, 1.0E-8);
                    lastX = x;
                    lastY = y;
                    break;
                }
                case 1: {
                    double x = coords[0];
                    double y = coords[1];
                    boundaryCheck = IntersectLineLine.intersectLineLineEx(a0x, a0y, a1x, a1y, lastX, lastY, x, y);
                    rayCheck = IntersectRayLine.intersectRayLineEx(a0x, a0y, 1.0, 0.0, Double.MAX_VALUE, lastX, lastY, x, y, 1.0E-8);
                    lastX = x;
                    lastY = y;
                    break;
                }
                case 0: {
                    lastX = firstX = coords[0];
                    lastY = firstY = coords[1];
                    boundaryCheck = null;
                    rayCheck = null;
                    break;
                }
                case 2: {
                    double x = coords[2];
                    double y = coords[3];
                    boundaryCheck = IntersectLineQuadCurve.intersectLineQuadCurveEx(a0x, a0y, a1x, a1y, lastX, lastY, coords[0], coords[1], x, y);
                    rayCheck = IntersectRayQuadCurve.intersectRayQuadCurveEx(a0x, a0y, 1.0, 0.0, Double.MAX_VALUE, lastX, lastY, coords[0], coords[1], x, y, 1.0E-8);
                    lastX = x;
                    lastY = y;
                    break;
                }
                default: {
                    boundaryCheck = null;
                    rayCheck = null;
                }
            }
            if (boundaryCheck != null && boundaryCheck.getStatus() == IntersectionStatus.INTERSECTION) {
                for (IntersectionPointEx isect : boundaryCheck.intersections()) {
                    lineIntersections.add(isect.withSegmentB(segment));
                }
            }
            if (rayCheck != null && rayCheck.getStatus() == IntersectionStatus.INTERSECTION) {
                for (IntersectionPointEx ip : rayCheck.intersections()) {
                    double ty = ip.getDerivativeB().getY();
                    if (Points.almostZero(ty)) continue;
                    if (ty > 0.0) {
                        ++clockwiseCrossings;
                        continue;
                    }
                    ++counterClockwiseCrossings;
                }
            }
            switch (type) {
                case 4: {
                    clockwiseCrossingsSum += clockwiseCrossings;
                    counterClockwiseCrossingsSum += counterClockwiseCrossings;
                    counterClockwiseCrossings = 0;
                    clockwiseCrossings = 0;
                    if (windingRule == 0) {
                        if ((clockwiseCrossingsSum + counterClockwiseCrossingsSum) % 2 != 1) break;
                        insideIntersections.add(new IntersectionPointEx(a0x, a0y, 0.0, 0.0, 0.0, 0, 0.0, 0.0, 0.0, segment));
                        break;
                    }
                    if (windingRule != 1 || clockwiseCrossingsSum == counterClockwiseCrossingsSum) break;
                    insideIntersections.add(new IntersectionPointEx(a0x, a0y, 0.0, 0.0, 0.0, 0, 0.0, 0.0, 0.0, segment));
                    break;
                }
                case 0: {
                    counterClockwiseCrossings = 0;
                    clockwiseCrossings = 0;
                }
            }
            pit.next();
        }
        if (!lineIntersections.isEmpty()) {
            return new IntersectionResultEx(lineIntersections);
        }
        if (!insideIntersections.isEmpty()) {
            return new IntersectionResultEx(IntersectionStatus.NO_INTERSECTION_INSIDE, insideIntersections);
        }
        return new IntersectionResultEx(List.of());
    }

    public static IntersectionResultEx intersectLinePathIteratorEx(Point2D a0, Point2D a1, PathIterator pit) {
        IntersectionResultEx i = IntersectLinePathIterator.intersectLinePathIteratorEx(a0, a1, pit, 1.0);
        if (i.getStatus() == IntersectionStatus.INTERSECTION && ((IntersectionPointEx)i.intersections().getFirst()).argumentA() > 1.0) {
            return new IntersectionResultEx(IntersectionStatus.NO_INTERSECTION, new ArrayList<IntersectionPointEx>());
        }
        return i;
    }
}

