/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jhotdraw8.geom.Lines;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.Points2D;
import org.jhotdraw8.geom.Polynomial;
import org.jhotdraw8.geom.QuadCurves;
import org.jhotdraw8.geom.intersect.IntersectLinePoint;
import org.jhotdraw8.geom.intersect.IntersectQuadCurveLine;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;
import org.jhotdraw8.geom.intersect.Intersections;

public class IntersectLineQuadCurve {
    private IntersectLineQuadCurve() {
    }

    public static IntersectionResult intersectLineQuadCurve(Point2D a0, Point2D a1, Point2D p0, Point2D p1, Point2D p2) {
        return IntersectLineQuadCurve.intersectLineQuadCurve(a0.getX(), a0.getY(), a1.getX(), a1.getY(), p0.getX(), p0.getY(), p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static IntersectionResult intersectLineQuadCurve(double a0x, double a0y, double a1x, double a1y, double p0x, double p0y, double p1x, double p1y, double p2x, double p2y) {
        return IntersectLineQuadCurve.intersectLineQuadCurve(a0x, a0y, a1x, a1y, p0x, p0y, p1x, p1y, p2x, p2y, 1.0E-8);
    }

    public static IntersectionResult intersectLineQuadCurve(double a0x, double a0y, double a1x, double a1y, double p0x, double p0y, double p1x, double p1y, double p2x, double p2y, double epsilon) {
        Point2D.Double topLeft = Intersections.topLeft(a0x, a0y, a1x, a1y);
        Point2D.Double bottomRight = Intersections.bottomRight(a0x, a0y, a1x, a1y);
        ArrayList<IntersectionPoint> result = new ArrayList<IntersectionPoint>();
        Point2D.Double p0 = new Point2D.Double(p0x, p0y);
        Point2D.Double p1 = new Point2D.Double(p1x, p1y);
        Point2D.Double c2 = Points2D.add(Points2D.add(p0, Points2D.multiply(p1, -2.0)), p2x, p2y);
        Point2D.Double c1 = Points2D.add(Points2D.multiply(p0, -2.0), Points2D.multiply(p1, 2.0));
        Point2D.Double c0 = p0;
        Point2D.Double n = new Point2D.Double(a0y - a1y, a1x - a0x);
        double cl = a0x * a1y - a1x * a0y;
        double[] roots = new Polynomial(Points2D.dotProduct(n, c2), Points2D.dotProduct(n, c1), Points2D.dotProduct(n, c0) + cl).getRoots();
        IntersectionStatus status = IntersectionStatus.NO_INTERSECTION;
        for (double t : roots) {
            Point2D.Double p5;
            Point2D.Double p4;
            Point2D.Double p6;
            double t1;
            if (!(0.0 <= t) || !(t <= 1.0) || !(-epsilon <= (t1 = IntersectLinePoint.argumentOnLine(a0x, a0y, a1x, a1y, (p6 = Lines.lerp(p4 = Lines.lerp(p0, p1, t), p5 = Lines.lerp(p1x, p1y, p2x, p2y, t), t)).getX(), p6.getY()))) || !(t1 <= 1.0 + epsilon)) continue;
            status = IntersectionStatus.INTERSECTION;
            result.add(new IntersectionPoint(p6, t1));
        }
        return new IntersectionResult(status, result);
    }

    public static IntersectionResultEx intersectLineQuadCurveEx(double a0x, double a0y, double a1x, double a1y, double p0x, double p0y, double p1x, double p1y, double p2x, double p2y) {
        return IntersectLineQuadCurve.intersectLineQuadCurveEx(a0x, a0y, a1x, a1y, p0x, p0y, p1x, p1y, p2x, p2y, 1.0E-8);
    }

    public static IntersectionResultEx intersectLineQuadCurveEx(double a0x, double a0y, double a1x, double a1y, double p0x, double p0y, double p1x, double p1y, double p2x, double p2y, double epsilon) {
        IntersectionResult result = IntersectQuadCurveLine.intersectQuadCurveLine(p0x, p0y, p1x, p1y, p2x, p2y, a0x, a0y, a1x, a1y, epsilon);
        ArrayList<IntersectionPointEx> list = new ArrayList<IntersectionPointEx>();
        for (IntersectionPoint ip : result.intersections()) {
            double px = ip.getX();
            double py = ip.getY();
            PointAndDerivative pdA = QuadCurves.eval(p0x, p0y, p1x, p1y, p2x, p2y, ip.argumentA());
            list.add(new IntersectionPointEx(px, py, IntersectLinePoint.argumentOnLine(a0x, a0y, a1x, a1y, px, py), a1x - a0x, a1y - a0y, ip.argumentA(), pdA.dx(), pdA.dy()));
        }
        return new IntersectionResultEx(result.getStatus(), list);
    }

    public static IntersectionResultEx intersectQuadCurveLineEx(double p0x, double p0y, double p1x, double p1y, double p2x, double p2y, double a0x, double a0y, double a1x, double a1y) {
        return IntersectLineQuadCurve.intersectQuadCurveLineEx(p0x, p0y, p1x, p1y, p2x, p2y, a0x, a0y, a1x, a1y, 1.0E-8);
    }

    public static IntersectionResultEx intersectQuadCurveLineEx(double p0x, double p0y, double p1x, double p1y, double p2x, double p2y, double a0x, double a0y, double a1x, double a1y, double epsilon) {
        IntersectionResult result = IntersectQuadCurveLine.intersectQuadCurveLine(p0x, p0y, p1x, p1y, p2x, p2y, a0x, a0y, a1x, a1y, epsilon);
        ArrayList<IntersectionPointEx> list = new ArrayList<IntersectionPointEx>();
        for (IntersectionPoint ip : result.intersections()) {
            double px = ip.getX();
            double py = ip.getY();
            PointAndDerivative pdA = QuadCurves.eval(p0x, p0y, p1x, p1y, p2x, p2y, ip.argumentA());
            list.add(new IntersectionPointEx(px, py, ip.argumentA(), pdA.dx(), pdA.dy(), IntersectLinePoint.argumentOnLine(a0x, a0y, a1x, a1y, px, py), a1x - a0x, a1y - a0y));
        }
        return new IntersectionResultEx(result.getStatus(), list);
    }
}

