/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.intersect.IntersectCubicCurvePoint;
import org.jhotdraw8.geom.intersect.IntersectLinePoint;
import org.jhotdraw8.geom.intersect.IntersectPointQuadCurve;
import org.jhotdraw8.geom.intersect.IntersectRayCubicCurve;
import org.jhotdraw8.geom.intersect.IntersectRayLine;
import org.jhotdraw8.geom.intersect.IntersectRayQuadCurve;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class IntersectPathIteratorPoint {
    private IntersectPathIteratorPoint() {
    }

    public static IntersectionResult intersectPathIteratorPoint(PathIterator pit, double px, double py, double tolerance) {
        ArrayList<IntersectionPoint> lineIntersections = new ArrayList<IntersectionPoint>();
        ArrayList<IntersectionPoint> insideIntersections = new ArrayList<IntersectionPoint>();
        double[] seg = new double[6];
        double firstx = 0.0;
        double firsty = 0.0;
        double lastx = 0.0;
        double lasty = 0.0;
        int i = 0;
        int windingRule = pit.getWindingRule();
        int clockwiseCrossingsSum = 0;
        int counterClockwiseCrossingsSum = 0;
        int clockwiseCrossings = 0;
        int counterClockwiseCrossings = 0;
        int segment = 0;
        while (!pit.isDone()) {
            IntersectionResultEx rayCheck;
            IntersectionResult boundaryCheck;
            int type = pit.currentSegment(seg);
            switch (type) {
                case 4: {
                    boundaryCheck = IntersectLinePoint.intersectLinePoint(lastx, lasty, firstx, firsty, px, py, tolerance);
                    rayCheck = IntersectRayLine.intersectRayLineEx(px, py, 1.0, 0.0, Double.MAX_VALUE, lastx, lasty, firstx, firsty, 1.0E-8);
                    break;
                }
                case 3: {
                    double x = seg[4];
                    double y = seg[5];
                    boundaryCheck = IntersectCubicCurvePoint.intersectCubicCurvePoint(lastx, lasty, seg[0], seg[1], seg[2], seg[3], x, y, px, py, tolerance);
                    rayCheck = IntersectRayCubicCurve.intersectRayCubicCurveEx(px, py, 1.0, 0.0, Double.MAX_VALUE, lastx, lasty, seg[0], seg[1], seg[2], seg[3], x, y, 1.0E-8);
                    lastx = x;
                    lasty = y;
                    break;
                }
                case 1: {
                    double x = seg[0];
                    double y = seg[1];
                    boundaryCheck = IntersectLinePoint.intersectLinePoint(lastx, lasty, x, y, px, py, tolerance);
                    rayCheck = IntersectRayLine.intersectRayLineEx(px, py, 1.0, 0.0, Double.MAX_VALUE, lastx, lasty, x, y, 1.0E-8);
                    lastx = x;
                    lasty = y;
                    break;
                }
                case 0: {
                    lastx = firstx = seg[0];
                    lasty = firsty = seg[1];
                    boundaryCheck = null;
                    rayCheck = null;
                    break;
                }
                case 2: {
                    double x = seg[2];
                    double y = seg[3];
                    boundaryCheck = IntersectPointQuadCurve.intersectQuadCurvePoint(lastx, lasty, seg[0], seg[1], x, y, px, py, tolerance);
                    rayCheck = IntersectRayQuadCurve.intersectRayQuadCurveEx(px, py, 1.0, 0.0, Double.MAX_VALUE, lastx, lasty, seg[0], seg[1], x, y, 1.0E-8);
                    lastx = x;
                    lasty = y;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported segment type: " + type);
                }
            }
            if (boundaryCheck != null && boundaryCheck.getStatus() == IntersectionStatus.INTERSECTION) {
                IntersectionPoint first = (IntersectionPoint)boundaryCheck.intersections().getFirst();
                lineIntersections.add(new IntersectionPoint(first.getX(), first.getY(), first.argumentA(), segment));
                break;
            }
            if (rayCheck != null && rayCheck.getStatus() == IntersectionStatus.INTERSECTION) {
                for (IntersectionPointEx ip : rayCheck.intersections()) {
                    double ty = ip.getDerivativeB().getY();
                    if (Points.almostZero(ty)) continue;
                    if (ty > 0.0) {
                        ++clockwiseCrossings;
                        continue;
                    }
                    ++counterClockwiseCrossings;
                }
            }
            switch (type) {
                case 4: {
                    clockwiseCrossingsSum += clockwiseCrossings;
                    counterClockwiseCrossingsSum += counterClockwiseCrossings;
                    counterClockwiseCrossings = 0;
                    clockwiseCrossings = 0;
                    if (windingRule == 0) {
                        if ((clockwiseCrossingsSum + counterClockwiseCrossingsSum) % 2 != 1) break;
                        insideIntersections.add(new IntersectionPoint(px, py, 0.0, segment));
                        break;
                    }
                    if (windingRule != 1 || clockwiseCrossingsSum == counterClockwiseCrossingsSum) break;
                    insideIntersections.add(new IntersectionPoint(px, py, 0.0, segment));
                    break;
                }
                case 0: {
                    counterClockwiseCrossings = 0;
                    clockwiseCrossings = 0;
                }
            }
            ++segment;
            pit.next();
            ++i;
        }
        if (!lineIntersections.isEmpty()) {
            return new IntersectionResult(lineIntersections);
        }
        if (!insideIntersections.isEmpty()) {
            return new IntersectionResult(IntersectionStatus.NO_INTERSECTION_INSIDE, insideIntersections);
        }
        return new IntersectionResult(List.of());
    }
}

