/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import org.jhotdraw8.geom.intersect.IntersectCubicCurvePathIterator;
import org.jhotdraw8.geom.intersect.IntersectLinePathIterator;
import org.jhotdraw8.geom.intersect.IntersectQuadCurvePathIterator;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class IntersectPathIteratorShape {
    private IntersectPathIteratorShape() {
    }

    public static IntersectionResultEx intersectPathIteratorShapeEx(PathIterator pit, Shape shape) {
        ArrayList<IntersectionPointEx> intersections = new ArrayList<IntersectionPointEx>();
        ArrayList insideIntersections = new ArrayList();
        double firstX = 0.0;
        double firstY = 0.0;
        double lastX = 0.0;
        double lastY = 0.0;
        int segment = 0;
        IntersectionStatus state = IntersectionStatus.NO_INTERSECTION;
        double[] coords = new double[6];
        while (!pit.isDone()) {
            IntersectionResultEx segmentResult;
            int type = pit.currentSegment(coords);
            switch (type) {
                case 4: {
                    segmentResult = IntersectLinePathIterator.intersectLinePathIteratorEx(lastX, lastY, firstX, firstY, shape.getPathIterator(null));
                    break;
                }
                case 3: {
                    segmentResult = IntersectCubicCurvePathIterator.intersectCubicCurvePathIteratorEx(lastX, lastY, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5], shape.getPathIterator(null));
                    lastX = coords[2];
                    lastY = coords[3];
                    break;
                }
                case 1: {
                    segmentResult = IntersectLinePathIterator.intersectLinePathIteratorEx(lastX, lastY, coords[0], coords[1], shape.getPathIterator(null));
                    lastX = coords[2];
                    lastY = coords[3];
                    break;
                }
                case 0: {
                    lastX = firstX = coords[0];
                    lastY = firstY = coords[1];
                    segmentResult = null;
                    break;
                }
                case 2: {
                    segmentResult = IntersectQuadCurvePathIterator.intersectQuadCurvePathIteratorEx(lastX, lastY, coords[0], coords[1], coords[2], coords[3], shape.getPathIterator(null));
                    lastX = coords[2];
                    lastY = coords[3];
                    break;
                }
                default: {
                    segmentResult = null;
                }
            }
            if (segmentResult != null) {
                block7 : switch (segmentResult.getStatus()) {
                    case INTERSECTION: {
                        for (IntersectionPointEx isect : segmentResult.intersections()) {
                            intersections.add(isect.withSegmentA(segment));
                        }
                        state = IntersectionStatus.INTERSECTION;
                        break;
                    }
                    case NO_INTERSECTION_INSIDE: {
                        switch (state) {
                            case NO_INTERSECTION: {
                                state = IntersectionStatus.NO_INTERSECTION_INSIDE;
                                break block7;
                            }
                            case NO_INTERSECTION_OUTSIDE: {
                                state = IntersectionStatus.NO_INTERSECTION_INSIDE_AND_OUTSIDE;
                                break block7;
                            }
                        }
                        break;
                    }
                    case NO_INTERSECTION_OUTSIDE: {
                        switch (state) {
                            case NO_INTERSECTION: {
                                state = IntersectionStatus.NO_INTERSECTION_OUTSIDE;
                                break block7;
                            }
                            case NO_INTERSECTION_INSIDE: {
                                state = IntersectionStatus.NO_INTERSECTION_INSIDE_AND_OUTSIDE;
                                break block7;
                            }
                        }
                        break;
                    }
                    case NO_INTERSECTION_INSIDE_AND_OUTSIDE: {
                        switch (state) {
                            case NO_INTERSECTION: 
                            case NO_INTERSECTION_OUTSIDE: 
                            case NO_INTERSECTION_INSIDE: {
                                state = IntersectionStatus.NO_INTERSECTION_INSIDE_AND_OUTSIDE;
                                break block7;
                            }
                        }
                    }
                }
            }
            pit.next();
        }
        return new IntersectionResultEx(state, intersections);
    }
}

