/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.PrimitiveIterator;
import org.jhotdraw8.collection.primitive.DoubleArrayList;
import org.jhotdraw8.geom.Points2D;
import org.jhotdraw8.geom.Polynomial;
import org.jhotdraw8.geom.QuadCurves;
import org.jhotdraw8.geom.intersect.IntersectCubicCurvePoint;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class IntersectQuadCurveCubicCurve {
    private static final double CURVE_A_B_TOLERANCE = 0.001;
    private static final double ROOT_X_Y_TOLERANCE = 1.0E-4;

    private IntersectQuadCurveCubicCurve() {
    }

    public static IntersectionResult intersectQuadCurveCubicCurve(double a0x, double a0y, double a1x, double a1y, double a2x, double a2y, double b0x, double b0y, double b1x, double b1y, double b2x, double b2y, double b3x, double b3y) {
        return IntersectQuadCurveCubicCurve.intersectQuadCurveCubicCurve(a0x, a0y, a1x, a1y, a2x, a2y, b0x, b0y, b1x, b1y, b2x, b2y, b3x, b3y, 1.0E-8);
    }

    public static IntersectionResultEx intersectQuadCurveCubicCurveEx(double a0x, double a0y, double a1x, double a1y, double a2x, double a2y, double b0x, double b0y, double b1x, double b1y, double b2x, double b2y, double b3x, double b3y) {
        return IntersectQuadCurveCubicCurve.intersectQuadCurveCubicCurveEx(a0x, a0y, a1x, a1y, a2x, a2y, b0x, b0y, b1x, b1y, b2x, b2y, b3x, b3y, 1.0E-8);
    }

    public static IntersectionResult intersectQuadCurveCubicCurve(double a0x, double a0y, double a1x, double a1y, double a2x, double a2y, double b0x, double b0y, double b1x, double b1y, double b2x, double b2y, double b3x, double b3y, double epsilon) {
        return IntersectQuadCurveCubicCurve.intersectQuadCurveCubicCurve(new Point2D.Double(a0x, a0y), new Point2D.Double(a1x, a1y), new Point2D.Double(a2x, a2y), new Point2D.Double(b0x, b0y), new Point2D.Double(b1x, b1y), new Point2D.Double(b2x, b2y), new Point2D.Double(b3x, b3y));
    }

    public static IntersectionResult intersectQuadCurveCubicCurve(Point2D a0, Point2D a1, Point2D a2, Point2D b0, Point2D b1, Point2D b2, Point2D b3) {
        return IntersectQuadCurveCubicCurve.intersectQuadCurveCubicCurve(a0, a1, a2, b0, b1, b2, b3, 1.0E-8);
    }

    public static IntersectionResult intersectQuadCurveCubicCurve(Point2D a0, Point2D a1, Point2D a2, Point2D b0, Point2D b1, Point2D b2, Point2D b3, double epsilon) {
        Point2D.Double c12 = Points2D.add(a0, Points2D.add(Points2D.multiply(a1, -2.0), a2));
        Point2D.Double c11 = Points2D.add(Points2D.multiply(a0, -2.0), Points2D.multiply(a1, 2.0));
        Point2D.Double c10 = new Point2D.Double(a0.getX(), a0.getY());
        Point2D.Double c23 = Points2D.sum(Points2D.multiply(b0, -1.0), Points2D.multiply(b1, 3.0), Points2D.multiply(b2, -3.0), b3);
        Point2D.Double c22 = Points2D.sum(Points2D.multiply(b0, 3.0), Points2D.multiply(b1, -6.0), Points2D.multiply(b2, 3.0));
        Point2D.Double c21 = Points2D.add(Points2D.multiply(b0, -3.0), Points2D.multiply(b1, 3.0));
        Point2D c20 = b0;
        double c10x = ((Point2D)c10).getX();
        double c10y = ((Point2D)c10).getY();
        double c11x = ((Point2D)c11).getX();
        double c11y = ((Point2D)c11).getY();
        double c12x = ((Point2D)c12).getX();
        double c12y = ((Point2D)c12).getY();
        double c20x = c20.getX();
        double c20y = c20.getY();
        double c21x = ((Point2D)c21).getX();
        double c21y = ((Point2D)c21).getY();
        double c22x = ((Point2D)c22).getX();
        double c22y = ((Point2D)c22).getY();
        double c23x = ((Point2D)c23).getX();
        double c23y = ((Point2D)c23).getY();
        double c10x2 = c10x * c10x;
        double c10y2 = c10y * c10y;
        double c11x2 = c11x * c11x;
        double c11y2 = c11y * c11y;
        double c12x2 = c12x * c12x;
        double c12y2 = c12y * c12y;
        double c20x2 = c20x * c20x;
        double c20y2 = c20y * c20y;
        double c21x2 = c21x * c21x;
        double c21y2 = c21y * c21y;
        double c22x2 = c22x * c22x;
        double c22y2 = c22y * c22y;
        double c23x2 = c23x * c23x;
        double c23y2 = c23y * c23y;
        Polynomial poly = new Polynomial(-2.0 * c12x * c12y * c23x * c23y + c12x2 * c23y2 + c12y2 * c23x2, -2.0 * c12x * c12y * c22x * c23y - 2.0 * c12x * c12y * c22y * c23x + 2.0 * c12y2 * c22x * c23x + 2.0 * c12x2 * c22y * c23y, -2.0 * c12x * c21x * c12y * c23y - 2.0 * c12x * c12y * c21y * c23x - 2.0 * c12x * c12y * c22x * c22y + 2.0 * c21x * c12y2 * c23x + c12y2 * c22x2 + c12x2 * (2.0 * c21y * c23y + c22y2), 2.0 * c10x * c12x * c12y * c23y + 2.0 * c10y * c12x * c12y * c23x + c11x * c11y * c12x * c23y + c11x * c11y * c12y * c23x - 2.0 * c20x * c12x * c12y * c23y - 2.0 * c12x * c20y * c12y * c23x - 2.0 * c12x * c21x * c12y * c22y - 2.0 * c12x * c12y * c21y * c22x - 2.0 * c10x * c12y2 * c23x - 2.0 * c10y * c12x2 * c23y + 2.0 * c20x * c12y2 * c23x + 2.0 * c21x * c12y2 * c22x - c11y2 * c12x * c23x - c11x2 * c12y * c23y + c12x2 * (2.0 * c20y * c23y + 2.0 * c21y * c22y), 2.0 * c10x * c12x * c12y * c22y + 2.0 * c10y * c12x * c12y * c22x + c11x * c11y * c12x * c22y + c11x * c11y * c12y * c22x - 2.0 * c20x * c12x * c12y * c22y - 2.0 * c12x * c20y * c12y * c22x - 2.0 * c12x * c21x * c12y * c21y - 2.0 * c10x * c12y2 * c22x - 2.0 * c10y * c12x2 * c22y + 2.0 * c20x * c12y2 * c22x - c11y2 * c12x * c22x - c11x2 * c12y * c22y + c21x2 * c12y2 + c12x2 * (2.0 * c20y * c22y + c21y2), 2.0 * c10x * c12x * c12y * c21y + 2.0 * c10y * c12x * c21x * c12y + c11x * c11y * c12x * c21y + c11x * c11y * c21x * c12y - 2.0 * c20x * c12x * c12y * c21y - 2.0 * c12x * c20y * c21x * c12y - 2.0 * c10x * c21x * c12y2 - 2.0 * c10y * c12x2 * c21y + 2.0 * c20x * c21x * c12y2 - c11y2 * c12x * c21x - c11x2 * c12y * c21y + 2.0 * c12x2 * c20y * c21y, -2.0 * c10x * c10y * c12x * c12y - c10x * c11x * c11y * c12y - c10y * c11x * c11y * c12x + 2.0 * c10x * c12x * c20y * c12y + 2.0 * c10y * c20x * c12x * c12y + c11x * c20x * c11y * c12y + c11x * c11y * c12x * c20y - 2.0 * c20x * c12x * c20y * c12y - 2.0 * c10x * c20x * c12y2 + c10x * c11y2 * c12x + c10y * c11x2 * c12y - 2.0 * c10y * c12x2 * c20y - c20x * c11y2 * c12x - c11x2 * c20y * c12y + c10x2 * c12y2 + c10y2 * c12x2 + c20x2 * c12y2 + c12x2 * c20y2);
        DoubleArrayList roots = poly.getRootsInInterval(0.0, 1.0);
        ArrayList<IntersectionPoint> result = new ArrayList<IntersectionPoint>();
        PrimitiveIterator.OfDouble ofDouble = roots.iterator();
        block0: while (ofDouble.hasNext()) {
            double s = (Double)ofDouble.next();
            double[] xRoots = new Polynomial(c12x, c11x, c10x - c20x - s * c21x - s * s * c22x - s * s * s * c23x).getRoots();
            double[] yRoots = new Polynomial(c12y, c11y, c10y - c20y - s * c21y - s * s * c22y - s * s * s * c23y).getRoots();
            if (xRoots.length <= 0 || yRoots.length <= 0) continue;
            for (double xRoot : xRoots) {
                if (!(0.0 <= xRoot) || !(xRoot <= 1.0)) continue;
                for (double yRoot : yRoots) {
                    if (!(Math.abs(xRoot - yRoot) < 1.0E-4)) continue;
                    result.add(new IntersectionPoint(Points2D.sum(Points2D.multiply(c23, s * s * s), Points2D.multiply(c22, s * s), Points2D.multiply(c21, s), c20), xRoot));
                    continue block0;
                }
            }
        }
        return new IntersectionResult(result.isEmpty() ? IntersectionStatus.NO_INTERSECTION : IntersectionStatus.INTERSECTION, result);
    }

    public static IntersectionResultEx intersectQuadCurveCubicCurveEx(double a0x, double a0y, double a1x, double a1y, double a2x, double a2y, double b0x, double b0y, double b1x, double b1y, double b2x, double b2y, double b3x, double b3y, double epsilon) {
        IntersectionResult resultA = IntersectQuadCurveCubicCurve.intersectQuadCurveCubicCurve(new Point2D.Double(a0x, a0y), new Point2D.Double(a1x, a1y), new Point2D.Double(a2x, a2y), new Point2D.Double(b0x, b0y), new Point2D.Double(b1x, b1y), new Point2D.Double(b2x, b2y), new Point2D.Double(b3x, b3y), epsilon);
        ArrayList<IntersectionPointEx> list = new ArrayList<IntersectionPointEx>();
        for (IntersectionPoint ip : resultA.intersections()) {
            double x = ip.getX();
            double y = ip.getY();
            IntersectionResultEx resultB = IntersectCubicCurvePoint.intersectCubicCurvePointEx(b0x, b0y, b1x, b1y, b2x, b2y, b3x, b3y, x, y, epsilon);
            IntersectionPointEx firstB = (IntersectionPointEx)resultB.intersections().getFirst();
            list.add(new IntersectionPointEx(ip, ip.argumentA(), QuadCurves.eval(b0x, b0y, b1x, b1y, b2x, b2y, ip.argumentA()).getDerivative(Point2D.Double::new), firstB.argumentA(), firstB.getDerivativeA()));
        }
        return new IntersectionResultEx(resultA.getStatus(), list);
    }
}

