/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;
import org.jhotdraw8.geom.Points;
import org.jhotdraw8.geom.intersect.IntersectQuadCurveCubicCurve;
import org.jhotdraw8.geom.intersect.IntersectQuadCurveLine;
import org.jhotdraw8.geom.intersect.IntersectQuadCurveQuadCurve;
import org.jhotdraw8.geom.intersect.IntersectRayCubicCurve;
import org.jhotdraw8.geom.intersect.IntersectRayLine;
import org.jhotdraw8.geom.intersect.IntersectRayQuadCurve;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class IntersectQuadCurvePathIterator {
    private IntersectQuadCurvePathIterator() {
    }

    public static IntersectionResultEx intersectQuadCurvePathIteratorEx(double a0x, double a0y, double a1x, double a1y, double a2x, double a2y, PathIterator pit) {
        ArrayList<IntersectionPointEx> lineIntersections = new ArrayList<IntersectionPointEx>();
        ArrayList<IntersectionPointEx> insideIntersections = new ArrayList<IntersectionPointEx>();
        double[] seg = new double[6];
        double firstx = 0.0;
        double firsty = 0.0;
        double lastx = 0.0;
        double lasty = 0.0;
        int clockwiseCrossingsSum = 0;
        int counterClockwiseCrossingsSum = 0;
        int clockwiseCrossings = 0;
        int counterClockwiseCrossings = 0;
        int segment = 0;
        int windingRule = pit.getWindingRule();
        while (!pit.isDone()) {
            IntersectionResultEx rayCheck;
            IntersectionResultEx boundaryCheck;
            int type = pit.currentSegment(seg);
            switch (type) {
                case 4: {
                    boundaryCheck = IntersectQuadCurveLine.intersectQuadCurveLineEx(a0x, a0y, a1x, a1y, a2x, a2y, lastx, lasty, firstx, firsty);
                    rayCheck = IntersectRayLine.intersectRayLineEx(a0x, a0y, 1.0, 0.0, Double.MAX_VALUE, lastx, lasty, firstx, firsty, 1.0E-8);
                    break;
                }
                case 3: {
                    double x = seg[4];
                    double y = seg[5];
                    boundaryCheck = IntersectQuadCurveCubicCurve.intersectQuadCurveCubicCurveEx(a0x, a0y, a1x, a1y, a2x, a2y, lastx, lasty, seg[0], seg[1], seg[2], seg[3], x, y);
                    rayCheck = IntersectRayCubicCurve.intersectRayCubicCurveEx(a0x, a0y, 1.0, 0.0, Double.MAX_VALUE, lastx, lasty, seg[0], seg[1], seg[2], seg[3], x, y, 1.0E-8);
                    lastx = x;
                    lasty = y;
                    break;
                }
                case 1: {
                    double x = seg[0];
                    double y = seg[1];
                    boundaryCheck = IntersectQuadCurveLine.intersectQuadCurveLineEx(a0x, a0y, a1x, a1y, a2x, a2y, lastx, lasty, x, y);
                    rayCheck = IntersectRayLine.intersectRayLineEx(a0x, a0y, 1.0, 0.0, Double.MAX_VALUE, lastx, lasty, x, y, 1.0E-8);
                    lastx = x;
                    lasty = y;
                    break;
                }
                case 0: {
                    lastx = firstx = seg[0];
                    lasty = firsty = seg[1];
                    boundaryCheck = null;
                    rayCheck = null;
                    break;
                }
                case 2: {
                    double x = seg[2];
                    double y = seg[3];
                    boundaryCheck = IntersectQuadCurveQuadCurve.intersectQuadCurveQuadCurveEx(a0x, a0y, a1x, a1y, a2x, a2y, lastx, lasty, seg[0], seg[1], x, y);
                    rayCheck = IntersectRayQuadCurve.intersectRayQuadCurveEx(a0x, a0y, 1.0, 0.0, Double.MAX_VALUE, lastx, lasty, seg[0], seg[1], x, y, 1.0E-8);
                    lastx = x;
                    lasty = y;
                    break;
                }
                default: {
                    boundaryCheck = null;
                    rayCheck = null;
                }
            }
            if (boundaryCheck != null && boundaryCheck.getStatus() == IntersectionStatus.INTERSECTION) {
                for (IntersectionPointEx isect : boundaryCheck.intersections()) {
                    lineIntersections.add(isect.withSegmentB(segment));
                }
            }
            if (rayCheck != null && rayCheck.getStatus() == IntersectionStatus.INTERSECTION) {
                for (IntersectionPointEx ip : rayCheck.intersections()) {
                    double ty = ip.getDerivativeB().getY();
                    if (Points.almostZero(ty)) continue;
                    if (ty > 0.0) {
                        ++clockwiseCrossings;
                        continue;
                    }
                    ++counterClockwiseCrossings;
                }
            }
            switch (type) {
                case 4: {
                    clockwiseCrossingsSum += clockwiseCrossings;
                    counterClockwiseCrossingsSum += counterClockwiseCrossings;
                    counterClockwiseCrossings = 0;
                    clockwiseCrossings = 0;
                    if (windingRule == 0) {
                        if ((clockwiseCrossingsSum + counterClockwiseCrossingsSum) % 2 != 1) break;
                        insideIntersections.add(new IntersectionPointEx(a0x, a0y, 0.0, 0.0, 0.0, 0, 0.0, 0.0, 0.0, segment));
                        break;
                    }
                    if (windingRule != 1 || clockwiseCrossingsSum == counterClockwiseCrossingsSum) break;
                    insideIntersections.add(new IntersectionPointEx(a0x, a0y, 0.0, 0.0, 0.0, 0, 0.0, 0.0, 0.0, segment));
                    break;
                }
                case 0: {
                    counterClockwiseCrossings = 0;
                    clockwiseCrossings = 0;
                }
            }
            pit.next();
        }
        if (!lineIntersections.isEmpty()) {
            return new IntersectionResultEx(lineIntersections);
        }
        if (!insideIntersections.isEmpty()) {
            return new IntersectionResultEx(IntersectionStatus.NO_INTERSECTION_INSIDE, insideIntersections);
        }
        return new IntersectionResultEx(List.of());
    }
}

