/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jhotdraw8.geom.Lines;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.Points2D;
import org.jhotdraw8.geom.Polynomial;
import org.jhotdraw8.geom.QuadCurves;
import org.jhotdraw8.geom.intersect.IntersectLinePoint;
import org.jhotdraw8.geom.intersect.IntersectPointRay;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class IntersectQuadCurveRay {
    private IntersectQuadCurveRay() {
    }

    public static IntersectionResult intersectQuadCurveRay(Point2D p0, Point2D p1, Point2D p2, Point2D ao, Point2D ad, double maxT) {
        return IntersectQuadCurveRay.intersectQuadCurveRay(p0, p1, p2, ao, ad, maxT, 1.0E-8);
    }

    public static IntersectionResult intersectQuadCurveRay(Point2D p0, Point2D p1, Point2D p2, Point2D ao, Point2D ad, double maxT, double epsilon) {
        Point2D.Double c2 = Points2D.sum(p0, Points2D.multiply(p1, -2.0), p2);
        Point2D.Double c1 = Points2D.multiply(Points2D.subtract(p0, p1), -2.0);
        Point2D c0 = p0;
        double a0x = ao.getX();
        double a0y = ao.getY();
        double a1x = a0x + ad.getX();
        double a1y = a0y + ad.getY();
        Point2D.Double n = new Point2D.Double(a0y - a1y, a1x - a0x);
        double cl = a0x * a1y - a1x * a0y;
        double[] roots = new Polynomial(Points2D.dotProduct(n, c2), Points2D.dotProduct(n, c1), Points2D.dotProduct(n, c0) + cl).getRoots();
        ArrayList<IntersectionPoint> result = new ArrayList<IntersectionPoint>();
        IntersectionStatus status = IntersectionStatus.NO_INTERSECTION;
        for (double t : roots) {
            Point2D.Double p5;
            Point2D.Double p4;
            Point2D.Double p6;
            double t1;
            if (!(-epsilon <= t) || !(t <= 1.0 + epsilon) || !(-epsilon <= (t1 = IntersectLinePoint.argumentOnLine(a0x, a0y, a1x, a1y, (p6 = Lines.lerp(p4 = Lines.lerp(p0, p1, t), p5 = Lines.lerp(p1, p2, t), t)).getX(), p6.getY()))) || !(t1 <= maxT)) continue;
            status = IntersectionStatus.INTERSECTION;
            result.add(new IntersectionPoint(p6, t));
        }
        return new IntersectionResult(status, result);
    }

    public static IntersectionResult intersectQuadCurveRay(double ax0, double ay0, double ax1, double ay1, double ax2, double ay2, double box, double boy, double bdx, double bdy, double maxT) {
        return IntersectQuadCurveRay.intersectQuadCurveRay(ax0, ay0, ax1, ay1, ax2, ay2, box, boy, bdx, bdy, maxT, 1.0E-8);
    }

    public static IntersectionResult intersectQuadCurveRay(double ax0, double ay0, double ax1, double ay1, double ax2, double ay2, double box, double boy, double bdx, double bdy, double maxT, double epsilon) {
        return IntersectQuadCurveRay.intersectQuadCurveRay(new Point2D.Double(ax0, ay0), new Point2D.Double(ax1, ay1), new Point2D.Double(ax2, ay2), new Point2D.Double(box, boy), new Point2D.Double(bdx, bdy), maxT, epsilon);
    }

    public static IntersectionResultEx intersectQuadCurveLineEx(double p0x, double p0y, double p1x, double p1y, double p2x, double p2y, double aox, double aoy, double adx, double ady) {
        return IntersectQuadCurveRay.intersectQuadCurveLineEx(p0x, p0y, p1x, p1y, p2x, p2y, aox, aoy, adx, ady, 1.0E-8);
    }

    public static IntersectionResultEx intersectQuadCurveLineEx(double p0x, double p0y, double p1x, double p1y, double p2x, double p2y, double aox, double aoy, double adx, double ady, double epsilon) {
        IntersectionResult result = IntersectQuadCurveRay.intersectQuadCurveRay(p0x, p0y, p1x, p1y, p2x, p2y, aox, aoy, adx, ady, epsilon);
        ArrayList<IntersectionPointEx> list = new ArrayList<IntersectionPointEx>();
        for (IntersectionPoint ip : result.intersections()) {
            double px = ip.getX();
            double py = ip.getY();
            PointAndDerivative pdA = QuadCurves.eval(p0x, p0y, p1x, p1y, p2x, p2y, ip.argumentA());
            list.add(new IntersectionPointEx(px, py, ip.argumentA(), pdA.dx(), pdA.dy(), IntersectPointRay.projectedPointOnRay(aox, aoy, adx, ady, px, py), adx - aox, ady - aoy));
        }
        return new IntersectionResultEx(result.getStatus(), list);
    }
}

