/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jhotdraw8.geom.CubicCurves;
import org.jhotdraw8.geom.Lines;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.Points2D;
import org.jhotdraw8.geom.Polynomial;
import org.jhotdraw8.geom.intersect.IntersectCubicCurveRay;
import org.jhotdraw8.geom.intersect.IntersectLinePoint;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class IntersectRayCubicCurve {
    private IntersectRayCubicCurve() {
    }

    public static IntersectionResult intersectRayCubicCurve(double a0x, double a0y, double a1x, double a1y, double maxT, double p0x, double p0y, double p1x, double p1y, double p2x, double p2y, double p3x, double p3y, double epsilon) {
        Point2D.Double a0 = new Point2D.Double(a0x, a0y);
        Point2D.Double a1 = new Point2D.Double(a1x, a1y);
        Point2D.Double p0 = new Point2D.Double(p0x, p0y);
        Point2D.Double p1 = new Point2D.Double(p1x, p1y);
        Point2D.Double p2 = new Point2D.Double(p2x, p2y);
        Point2D.Double p3 = new Point2D.Double(p3x, p3y);
        return IntersectRayCubicCurve.intersectRayCubicCurve(a0, a1, maxT, p0, p1, p2, p3, 1.0E-8);
    }

    public static IntersectionResult intersectRayCubicCurve(Point2D ao, Point2D ad, double maxT, Point2D p0, Point2D p1, Point2D p2, Point2D p3, double epsilon) {
        double a0x = ao.getX();
        double a0y = ao.getY();
        double a1x = a0x + ad.getX();
        double a1y = a0y + ad.getY();
        ArrayList<IntersectionPoint> result = new ArrayList<IntersectionPoint>();
        Point2D.Double c3 = Points2D.sum(Points2D.multiply(p0, -1.0), Points2D.multiply(p1, 3.0), Points2D.multiply(p2, -3.0), p3);
        Point2D.Double c2 = Points2D.sum(Points2D.multiply(p0, 3.0), Points2D.multiply(p1, -6.0), Points2D.multiply(p2, 3.0));
        Point2D.Double c1 = Points2D.add(Points2D.multiply(p0, -3.0), Points2D.multiply(p1, 3.0));
        Point2D c0 = p0;
        Point2D.Double n = new Point2D.Double(a0y - a1y, a1x - a0x);
        double cl = a0x * a1y - a1x * a0y;
        Polynomial polynomial = new Polynomial(Points2D.dotProduct(n, c3), Points2D.dotProduct(n, c2), Points2D.dotProduct(n, c1), Points2D.dotProduct(n, c0) + cl);
        double[] roots = polynomial.getRoots();
        IntersectionStatus status = IntersectionStatus.NO_INTERSECTION;
        for (double t : roots) {
            Point2D.Double p9;
            if (!(-epsilon <= t) || !(t <= 1.0 + epsilon)) continue;
            Point2D.Double p5 = Lines.lerp(p0, p1, t);
            Point2D.Double p6 = Lines.lerp(p1, p2, t);
            Point2D.Double p7 = Lines.lerp(p2, p3, t);
            Point2D.Double p8 = Lines.lerp(p5, p6, t);
            Point2D.Double p10 = Lines.lerp(p8, p9 = Lines.lerp(p6, p7, t), t);
            double t1 = IntersectLinePoint.argumentOnLine(a0x, a0y, a1x, a1y, p10.getX(), p10.getY());
            if (!(-epsilon <= t1) || !(t1 <= maxT)) continue;
            status = IntersectionStatus.INTERSECTION;
            result.add(new IntersectionPoint(p10, t1));
        }
        return new IntersectionResult(status, result);
    }

    public static IntersectionResultEx intersectRayCubicCurveEx(double aox, double aoy, double adx, double ady, double maxT, double p0x, double p0y, double p1x, double p1y, double p2x, double p2y, double p3x, double p3y, double epsilon) {
        IntersectionResult result = IntersectCubicCurveRay.intersectCubicCurveRay(p0x, p0y, p1x, p1y, p2x, p2y, p3x, p3y, aox, aoy, adx, ady, maxT, epsilon);
        ArrayList<IntersectionPointEx> list = new ArrayList<IntersectionPointEx>();
        for (IntersectionPoint ip : result.intersections()) {
            double x = ip.getX();
            double y = ip.getY();
            PointAndDerivative pdA = CubicCurves.eval(p0x, p0y, p1x, p1y, p2x, p2y, p3x, p3y, ip.argumentA());
            list.add(new IntersectionPointEx(x, y, IntersectLinePoint.argumentOnLine(aox, aoy, adx, ady, x, y), adx, ady, ip.argumentA(), pdA.dx(), pdA.dy()));
        }
        return new IntersectionResultEx(result.getStatus(), list);
    }

    public static IntersectionResultEx intersectRayCubicCurveEx(double aox, double aoy, double adx, double ady, double maxT, double b0x, double b0y, double b1x, double b1y, double b2x, double b2y, double b3x, double b3y) {
        return IntersectRayCubicCurve.intersectRayCubicCurveEx(aox, aoy, adx, ady, maxT, b0x, b0y, b1x, b1y, b2x, b2y, b3x, b3y, 1.0E-8);
    }
}

