/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jhotdraw8.geom.intersect.IntersectRayCubicCurve;
import org.jhotdraw8.geom.intersect.IntersectRayLine;
import org.jhotdraw8.geom.intersect.IntersectRayQuadCurve;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;
import org.jhotdraw8.icollection.VectorList;

public class IntersectRayPathIterator {
    private IntersectRayPathIterator() {
    }

    public static IntersectionResultEx intersectRayPathIteratorEx(double aox, double aoy, double adx, double ady, PathIterator pit) {
        return IntersectRayPathIterator.intersectRayPathIteratorEx(aox, aoy, adx, ady, pit, 1.0);
    }

    public static IntersectionResultEx intersectRayPathIteratorEx(Point2D ao, Point2D ad, PathIterator pit, double maxT) {
        return IntersectRayPathIterator.intersectRayPathIteratorEx(ao.getX(), ao.getY(), ad.getX(), ad.getY(), pit, maxT);
    }

    public static IntersectionResultEx intersectRayPathIteratorEx(double aox, double aoy, double adx, double ady, PathIterator pit, double maxT) {
        VectorList lineIntersections = VectorList.of();
        double[] coords = new double[6];
        double firstX = 0.0;
        double firstY = 0.0;
        double lastX = 0.0;
        double lastY = 0.0;
        boolean clockwiseCrossingsSum = false;
        boolean counterClockwiseCrossingsSum = false;
        boolean clockwiseCrossings = false;
        boolean counterClockwiseCrossings = false;
        boolean segment = false;
        int windingRule = pit.getWindingRule();
        while (!pit.isDone()) {
            IntersectionResultEx rayCheck;
            int type = pit.currentSegment(coords);
            switch (type) {
                case 4: {
                    rayCheck = IntersectRayLine.intersectRayLineEx(aox, aoy, adx, ady, Double.MAX_VALUE, lastX, lastY, firstX, firstY, 1.0E-8);
                    break;
                }
                case 3: {
                    double x = coords[4];
                    double y = coords[5];
                    rayCheck = IntersectRayCubicCurve.intersectRayCubicCurveEx(aox, aoy, adx, ady, Double.MAX_VALUE, lastX, lastY, coords[0], coords[1], coords[2], coords[3], x, y, 1.0E-8);
                    lastX = x;
                    lastY = y;
                    break;
                }
                case 1: {
                    double x = coords[0];
                    double y = coords[1];
                    rayCheck = IntersectRayLine.intersectRayLineEx(aox, aoy, adx, ady, Double.MAX_VALUE, lastX, lastY, x, y, 1.0E-8);
                    lastX = x;
                    lastY = y;
                    break;
                }
                case 0: {
                    lastX = firstX = coords[0];
                    lastY = firstY = coords[1];
                    rayCheck = null;
                    break;
                }
                case 2: {
                    double x = coords[2];
                    double y = coords[3];
                    rayCheck = IntersectRayQuadCurve.intersectRayQuadCurveEx(aox, aoy, adx, ady, Double.MAX_VALUE, lastX, lastY, coords[0], coords[1], x, y, 1.0E-8);
                    lastX = x;
                    lastY = y;
                    break;
                }
                default: {
                    rayCheck = null;
                }
            }
            if (rayCheck != null && rayCheck.getStatus() == IntersectionStatus.INTERSECTION) {
                lineIntersections = lineIntersections.addAll(rayCheck.intersections());
            }
            pit.next();
        }
        return new IntersectionResultEx(lineIntersections.toMutable());
    }

    public static IntersectionResultEx intersectRayPathIteratorEx(Point2D a0, Point2D a1, PathIterator pit) {
        IntersectionResultEx i = IntersectRayPathIterator.intersectRayPathIteratorEx(a0, a1, pit, 1.0);
        if (i.getStatus() == IntersectionStatus.INTERSECTION && ((IntersectionPointEx)i.intersections().getFirst()).argumentA() > 1.0) {
            return new IntersectionResultEx(IntersectionStatus.NO_INTERSECTION, new ArrayList<IntersectionPointEx>());
        }
        return i;
    }
}

