/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.geom.intersect;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jhotdraw8.geom.Lines;
import org.jhotdraw8.geom.PointAndDerivative;
import org.jhotdraw8.geom.Points2D;
import org.jhotdraw8.geom.Polynomial;
import org.jhotdraw8.geom.QuadCurves;
import org.jhotdraw8.geom.intersect.IntersectLinePoint;
import org.jhotdraw8.geom.intersect.IntersectPointRay;
import org.jhotdraw8.geom.intersect.IntersectQuadCurveRay;
import org.jhotdraw8.geom.intersect.IntersectionPoint;
import org.jhotdraw8.geom.intersect.IntersectionPointEx;
import org.jhotdraw8.geom.intersect.IntersectionResult;
import org.jhotdraw8.geom.intersect.IntersectionResultEx;
import org.jhotdraw8.geom.intersect.IntersectionStatus;

public class IntersectRayQuadCurve {
    private IntersectRayQuadCurve() {
    }

    public static IntersectionResult intersectRayQuadCurve(Point2D ao, Point2D ad, double maxT, Point2D p0, Point2D p1, Point2D p2) {
        return IntersectRayQuadCurve.intersectRayQuadCurve(ao.getX(), ao.getY(), ad.getX(), ad.getY(), maxT, p0.getX(), p0.getY(), p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static IntersectionResult intersectRayQuadCurve(double aox, double aoy, double adx, double ady, double maxT, double p0x, double p0y, double p1x, double p1y, double p2x, double p2y) {
        return IntersectRayQuadCurve.intersectRayQuadCurve(aox, aoy, aox, aoy, maxT, p0x, p0y, p1x, p1y, p2x, p2y, 1.0E-8);
    }

    public static IntersectionResult intersectRayQuadCurve(double aox, double aoy, double adx, double ady, double maxT, double p0x, double p0y, double p1x, double p1y, double p2x, double p2y, double epsilon) {
        double a1x = aox + adx;
        double a1y = aoy + ady;
        ArrayList<IntersectionPoint> result = new ArrayList<IntersectionPoint>();
        Point2D.Double p0 = new Point2D.Double(p0x, p0y);
        Point2D.Double p1 = new Point2D.Double(p1x, p1y);
        Point2D.Double c2 = Points2D.add(Points2D.add(p0, Points2D.multiply(p1, -2.0)), p2x, p2y);
        Point2D.Double c1 = Points2D.add(Points2D.multiply(p0, -2.0), Points2D.multiply(p1, 2.0));
        Point2D.Double c0 = p0;
        Point2D.Double n = new Point2D.Double(aoy - a1y, a1x - aox);
        double cl = aox * a1y - a1x * aoy;
        double[] roots = new Polynomial(Points2D.dotProduct(n, c2), Points2D.dotProduct(n, c1), Points2D.dotProduct(n, c0) + cl).getRoots();
        IntersectionStatus status = IntersectionStatus.NO_INTERSECTION;
        for (double t : roots) {
            Point2D.Double p5;
            Point2D.Double p4;
            Point2D.Double p6;
            double t1;
            if (!(0.0 <= t) || !(t <= 1.0) || !(-epsilon <= (t1 = IntersectLinePoint.argumentOnLine(aox, aoy, a1x, a1y, (p6 = Lines.lerp(p4 = Lines.lerp(p0, p1, t), p5 = Lines.lerp(p1x, p1y, p2x, p2y, t), t)).getX(), p6.getY()))) || !(t1 <= maxT)) continue;
            status = IntersectionStatus.INTERSECTION;
            result.add(new IntersectionPoint(p6, t1));
        }
        return new IntersectionResult(status, result);
    }

    public static IntersectionResultEx intersectRayQuadCurveEx(double aox, double aoy, double adx, double ady, double maxT, double p0x, double p0y, double p1x, double p1y, double p2x, double p2y) {
        return IntersectRayQuadCurve.intersectRayQuadCurveEx(aox, aoy, adx, ady, p0x, maxT, p0y, p1x, p1y, p2x, p2y, 1.0E-8);
    }

    public static IntersectionResultEx intersectRayQuadCurveEx(double aox, double aoy, double adx, double ady, double maxT, double p0x, double p0y, double p1x, double p1y, double p2x, double p2y, double epsilon) {
        IntersectionResult result = IntersectQuadCurveRay.intersectQuadCurveRay(p0x, p0y, p1x, p1y, p2x, p2y, aox, aoy, adx, ady, maxT, epsilon);
        ArrayList<IntersectionPointEx> list = new ArrayList<IntersectionPointEx>();
        for (IntersectionPoint ip : result.intersections()) {
            double px = ip.getX();
            double py = ip.getY();
            PointAndDerivative pdA = QuadCurves.eval(p0x, p0y, p1x, p1y, p2x, p2y, ip.argumentA());
            list.add(new IntersectionPointEx(px, py, IntersectPointRay.projectedPointOnRay(aox, aoy, adx, ady, px, py), adx - aox, ady - aoy, ip.argumentA(), pdA.dx(), pdA.dy()));
        }
        return new IntersectionResultEx(result.getStatus(), list);
    }
}

